/*
 * Decompiled with CFR 0.152.
 */
package net.paladins.client.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.paladins.entity.BarrierEntity;
import net.spell_engine.api.render.CustomLayers;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.client.compatibility.ShaderCompatibility;
import net.spell_engine.client.util.Color;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class BarrierEntityRenderer<T extends BarrierEntity>
extends EntityRenderer<T> {
    private final ItemRenderer itemRenderer;
    public static final ResourceLocation blankTextureId = new ResourceLocation("paladins", "item/barrier");
    public static final List<BarrierEntity> activeBarriers = new ArrayList<BarrierEntity>();
    private static final int[] LIGHT_UP_ORDER = new int[]{0, 2, 8, 6, 4, 3, 9, 1, 5, 10, 7, 11};

    public static void setup() {
        WorldRenderEvents.AFTER_TRANSLUCENT.register(context -> {
            MultiBufferSource.BufferSource vcProvider = Minecraft.m_91087_().m_91269_().m_110104_();
            BarrierEntityRenderer.renderAllInWorld(context.matrixStack(), vcProvider, context.camera(), 0xF000F0, context.tickDelta());
        });
    }

    public BarrierEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.itemRenderer = context.m_174025_();
    }

    public ResourceLocation getTexture(T entity) {
        return null;
    }

    public void render(T entity, float yaw, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light) {
        if (entity.m_6084_()) {
            activeBarriers.add((BarrierEntity)((Object)entity));
        }
        super.m_7392_(entity, yaw, tickDelta, matrices, vertexConsumers, light);
    }

    public static void renderAllInWorld(PoseStack matrices, MultiBufferSource.BufferSource vertexConsumers, Camera camera, int light, float tickDelta) {
        matrices.m_85836_();
        Vec3 camPos = camera.m_90583_();
        matrices.m_85837_(-camPos.f_82479_, -camPos.f_82480_, -camPos.f_82481_);
        Config config = ShaderCompatibility.isShaderPackInUse() ? Config.IRIS : Config.VANILLA;
        VertexConsumer vertexConsumer = vertexConsumers.m_6299_(config.layer());
        for (BarrierEntity entity : activeBarriers) {
            matrices.m_85836_();
            matrices.m_85837_(entity.m_20185_(), entity.m_20186_() + 1.0, entity.m_20189_());
            BarrierEntityRenderer.renderShield(entity, matrices, vertexConsumer, light, tickDelta, config);
            matrices.m_85849_();
        }
        vertexConsumers.m_109911_();
        matrices.m_85849_();
        activeBarriers.clear();
    }

    public static void renderShield(BarrierEntity entity, PoseStack matrices, VertexConsumer vertexConsumer, int light, float tickDelta, Config config) {
        long time;
        Spell spell = entity.getSpell();
        if (spell == null) {
            return;
        }
        float radius = spell.range * 0.8f;
        float zSlant = 0.3926991f;
        float size = radius * Mth.m_14116_((float)3.0f) / 3.0f;
        float offset = radius * (Mth.m_14031_((float)zSlant) + 1.0f);
        int overlayUV = OverlayTexture.f_118083_;
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(blankTextureId);
        float u1 = sprite.m_118409_();
        float u2 = sprite.m_118410_();
        float v1 = sprite.m_118411_();
        float v2 = sprite.m_118412_();
        double fullTime = (double)entity.m_9236_().m_46467_() / 20.0;
        double delta = (fullTime - (double)(time = entity.m_9236_().m_46467_() / 20L)) * 2.0;
        if (delta > 1.0) {
            delta = 2.0 - delta;
        }
        delta = 1.0 - Math.pow(1.0 - delta, 4.0);
        for (int m = 0; m < 2; ++m) {
            for (int i = 0; i < 6; ++i) {
                matrices.m_85836_();
                if (m == 0) {
                    matrices.m_252781_(Axis.f_252529_.m_252961_((float)Math.PI));
                }
                matrices.m_252880_(offset, 0.0f, 0.0f);
                matrices.m_272245_(Axis.f_252436_.m_252961_((float)((double)((float)i / 3.0f) * Math.PI)), -offset, 0.0f, 0.0f);
                matrices.m_252781_(Axis.f_252403_.m_252961_(zSlant));
                float r = config.red();
                float g = config.green();
                float b = config.blue();
                float alpha = config.alpha();
                if (entity.f_19797_ >= entity.getTimeToLive() - entity.expirationDuration()) {
                    int relAge = entity.getTimeToLive() - entity.expirationDuration() - entity.f_19797_;
                    alpha = config.expirationPulseAlpha * Math.abs(Mth.m_14089_((float)((float)((double)((float)relAge * 1.25f / 10.0f) * Math.PI))));
                } else if (time % 12L == (long)LIGHT_UP_ORDER[i + m * 6]) {
                    float glow = (float)(0.5 * delta);
                    r = BarrierEntityRenderer.blend(r, 1.0f, glow);
                    g = BarrierEntityRenderer.blend(g, 1.0f, glow);
                    b = BarrierEntityRenderer.blend(b, 1.0f, glow);
                    alpha = BarrierEntityRenderer.blend(alpha, config.panelFlashAlpha(), glow);
                }
                Matrix4f matrix = new Matrix4f((Matrix4fc)matrices.m_85850_().m_252922_());
                Matrix3f normalMatrix = matrices.m_85850_().m_252943_();
                vertexConsumer.m_252986_(matrix, 0.0f, radius, -size).m_85950_(r, g, b, 0.0f).m_7421_(u1, v2).m_86008_(overlayUV).m_85969_(light).m_252939_(normalMatrix, 0.0f, 0.0f, 0.0f).m_5752_();
                vertexConsumer.m_252986_(matrix, 0.0f, 0.0f, -size).m_85950_(r, g, b, alpha).m_7421_(u1, v1).m_86008_(overlayUV).m_85969_(light).m_252939_(normalMatrix, 0.0f, 0.0f, 0.0f).m_5752_();
                vertexConsumer.m_252986_(matrix, 0.0f, 0.0f, size).m_85950_(r, g, b, alpha).m_7421_(u2, v1).m_86008_(overlayUV).m_85969_(light).m_252939_(normalMatrix, 0.0f, 0.0f, 0.0f).m_5752_();
                vertexConsumer.m_252986_(matrix, 0.0f, radius, size).m_85950_(r, g, b, 0.0f).m_7421_(u2, v2).m_86008_(overlayUV).m_85969_(light).m_252939_(normalMatrix, 0.0f, 0.0f, 0.0f).m_5752_();
                vertexConsumer.m_252986_(matrix, 0.0f, radius, size).m_85950_(r, g, b, 0.0f).m_7421_(u1, v2).m_86008_(overlayUV).m_85969_(light).m_252939_(normalMatrix, 0.0f, 0.0f, 0.0f).m_5752_();
                vertexConsumer.m_252986_(matrix, 0.0f, 0.0f, size).m_85950_(r, g, b, alpha).m_7421_(u1, v1).m_86008_(overlayUV).m_85969_(light).m_252939_(normalMatrix, 0.0f, 0.0f, 0.0f).m_5752_();
                vertexConsumer.m_252986_(matrix, 0.0f, 0.0f, -size).m_85950_(r, g, b, alpha).m_7421_(u2, v1).m_86008_(overlayUV).m_85969_(light).m_252939_(normalMatrix, 0.0f, 0.0f, 0.0f).m_5752_();
                vertexConsumer.m_252986_(matrix, 0.0f, radius, -size).m_85950_(r, g, b, 0.0f).m_7421_(u2, v2).m_86008_(overlayUV).m_85969_(light).m_252939_(normalMatrix, 0.0f, 0.0f, 0.0f).m_5752_();
                matrices.m_85849_();
                matrices.m_85836_();
                Matrix4f newMatrix = matrices.m_85850_().m_252922_();
                if (m == 0) {
                    matrices.m_252781_(Axis.f_252529_.m_252961_((float)Math.PI));
                }
                matrices.m_252880_(offset, 0.0f, 0.0f);
                matrices.m_272245_(Axis.f_252436_.m_252961_((float)((double)((float)(i - 1) / 3.0f) * Math.PI)), -offset, 0.0f, 0.0f);
                matrices.m_252781_(Axis.f_252403_.m_252961_(zSlant));
                vertexConsumer.m_252986_(matrix, 0.0f, radius, size).m_85950_(r, g, b, 0.0f).m_7421_(u2, v2).m_86008_(overlayUV).m_85969_(light).m_252939_(normalMatrix, 0.0f, 0.0f, 0.0f).m_5752_();
                vertexConsumer.m_252986_(matrix, 0.0f, 0.0f, size).m_85950_(r, g, b, alpha).m_7421_(u2, v1).m_86008_(overlayUV).m_85969_(light).m_252939_(normalMatrix, 0.0f, 0.0f, 0.0f).m_5752_();
                vertexConsumer.m_252986_(newMatrix, 0.0f, 0.0f, -size).m_85950_(r, g, b, alpha).m_7421_(u1, v1).m_86008_(overlayUV).m_85969_(light).m_252939_(normalMatrix, 0.0f, 0.0f, 0.0f).m_5752_();
                vertexConsumer.m_252986_(matrix, 0.0f, radius, size).m_85950_(r, g, b, 0.0f).m_7421_(u1, v2).m_86008_(overlayUV).m_85969_(light).m_252939_(normalMatrix, 0.0f, 0.0f, 0.0f).m_5752_();
                vertexConsumer.m_252986_(matrix, 0.0f, radius, size).m_85950_(r, g, b, 0.0f).m_7421_(u2, v2).m_86008_(overlayUV).m_85969_(light).m_252939_(normalMatrix, 0.0f, 0.0f, 0.0f).m_5752_();
                vertexConsumer.m_252986_(newMatrix, 0.0f, 0.0f, -size).m_85950_(r, g, b, alpha).m_7421_(u1, v1).m_86008_(overlayUV).m_85969_(light).m_252939_(normalMatrix, 0.0f, 0.0f, 0.0f).m_5752_();
                vertexConsumer.m_252986_(matrix, 0.0f, 0.0f, size).m_85950_(r, g, b, alpha).m_7421_(u2, v1).m_86008_(overlayUV).m_85969_(light).m_252939_(normalMatrix, 0.0f, 0.0f, 0.0f).m_5752_();
                vertexConsumer.m_252986_(matrix, 0.0f, radius, size).m_85950_(r, g, b, 0.0f).m_7421_(u1, v2).m_86008_(overlayUV).m_85969_(light).m_252939_(normalMatrix, 0.0f, 0.0f, 0.0f).m_5752_();
                matrices.m_85849_();
            }
        }
    }

    public static float blend(float min, float max, float delta) {
        return min + (max - min) * delta;
    }

    private record Config(RenderType layer, float red, float green, float blue, float alpha, float panelFlashAlpha, float expirationPulseAlpha) {
        private static final Color shield = Color.from((int)0xFFCC66);
        public static final Config VANILLA = new Config(CustomLayers.create((ResourceLocation)TextureAtlas.f_118259_, (RenderStateShard.ShaderStateShard)RenderStateShard.f_173068_, (RenderStateShard.TransparencyStateShard)RenderStateShard.f_110139_, (RenderStateShard.CullStateShard)RenderStateShard.f_110110_, (RenderStateShard.WriteMaskStateShard)RenderStateShard.f_110115_, (RenderStateShard.OverlayStateShard)RenderStateShard.f_110154_, (RenderStateShard.OutputStateShard)RenderStateShard.f_110123_, (boolean)true), shield.red(), shield.green(), shield.blue(), 0.8f, 0.9f, 1.0f);
        public static final Config IRIS = new Config(CustomLayers.create((ResourceLocation)TextureAtlas.f_118259_, (RenderStateShard.ShaderStateShard)RenderStateShard.f_173091_, (RenderStateShard.TransparencyStateShard)RenderStateShard.f_110136_, (RenderStateShard.CullStateShard)RenderStateShard.f_110110_, (RenderStateShard.WriteMaskStateShard)RenderStateShard.f_110115_, (RenderStateShard.OverlayStateShard)RenderStateShard.f_110154_, (RenderStateShard.OutputStateShard)RenderStateShard.f_110123_, (boolean)false), shield.red(), shield.green(), shield.blue(), 0.5f, 1.0f, 0.8f);
    }
}

