/*
 * Decompiled with CFR 0.152.
 */
package net.paladins.item;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.fabric_extras.shield_api.item.CustomShieldItem;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.paladins.PaladinsMod;
import net.paladins.config.ShieldsConfig;
import net.paladins.config.TweaksConfig;
import net.paladins.item.Group;
import net.spell_engine.api.item.ItemConfig;
import net.spell_engine.api.item.weapon.Weapon;

public class Shields {
    public static final ResourceLocation equipSoundId = new ResourceLocation("paladins", "shield_equip");
    public static final SoundEvent equipSound = SoundEvent.m_262824_((ResourceLocation)equipSoundId);
    public static final ArrayList<Entry> ENTRIES = new ArrayList();
    private static final String GENERIC_ARMOR_TOUGHNESS = "minecraft:generic.armor_toughness";
    private static final String GENERIC_MAX_HEALTH = "generic.max_health";
    private static final int durability_t0 = 168;
    private static final int durability_t1 = 336;
    private static final int durability_t2 = 672;
    private static final int durability_t3 = 1344;
    private static final int durability_t4 = 1344;
    public static Entry iron_kite_shield = Shields.shield("iron_kite_shield", () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42416_}), List.of(new ItemConfig.Attribute("minecraft:generic.armor_toughness", 1.0f, AttributeModifier.Operation.ADDITION), new ItemConfig.Attribute("generic.max_health", 2.0f, AttributeModifier.Operation.ADDITION)), 336);
    public static Entry golden_kite_shield = Shields.shield("golden_kite_shield", () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42417_}), List.of(), 168);
    public static Entry diamond_kite_shield = Shields.shield("diamond_kite_shield", () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42415_}), List.of(new ItemConfig.Attribute("minecraft:generic.armor_toughness", 1.0f, AttributeModifier.Operation.ADDITION), new ItemConfig.Attribute("generic.max_health", 2.0f, AttributeModifier.Operation.ADDITION)), 672);
    public static Entry netherite_kite_shield = Shields.shield("netherite_kite_shield", () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42418_}), List.of(new ItemConfig.Attribute("minecraft:generic.armor_toughness", 1.0f, AttributeModifier.Operation.ADDITION), new ItemConfig.Attribute("generic.max_health", 4.0f, AttributeModifier.Operation.ADDITION)), 1344);
    private static final String BETTER_END = "betterend";
    private static final String BETTER_NETHER = "betternether";

    private static Supplier<Ingredient> ingredient(String idString, boolean requirement, Item fallback) {
        ResourceLocation id = new ResourceLocation(idString);
        if (requirement) {
            return () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{fallback});
        }
        return () -> {
            Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(id);
            Item ingredient = item != null ? item : fallback;
            return Ingredient.m_43929_((ItemLike[])new ItemLike[]{ingredient});
        };
    }

    public static Entry shield(String name, Supplier<Ingredient> repair, List<ItemConfig.Attribute> attributes, int durability) {
        Entry entry = new Entry(new ResourceLocation("paladins", name), repair, attributes, durability);
        ENTRIES.add(entry);
        return entry;
    }

    public static void register(Map<String, ShieldsConfig.Entry> configs) {
        Supplier<Ingredient> repair;
        if (((TweaksConfig)PaladinsMod.tweaksConfig.value).ignore_items_required_mods || FabricLoader.getInstance().isModLoaded(BETTER_NETHER)) {
            repair = Shields.ingredient("betternether:nether_ruby", FabricLoader.getInstance().isModLoaded(BETTER_NETHER), Items.f_42418_);
            Shields.shield("ruby_kite_shield", repair, List.of(new ItemConfig.Attribute(GENERIC_ARMOR_TOUGHNESS, 1.0f, AttributeModifier.Operation.ADDITION), new ItemConfig.Attribute(GENERIC_MAX_HEALTH, 6.0f, AttributeModifier.Operation.ADDITION)), 1344);
        }
        if (((TweaksConfig)PaladinsMod.tweaksConfig.value).ignore_items_required_mods || FabricLoader.getInstance().isModLoaded(BETTER_END)) {
            repair = Shields.ingredient("betterend:aeternium_ingot", FabricLoader.getInstance().isModLoaded(BETTER_END), Items.f_42418_);
            Shields.shield("aeternium_kite_shield", repair, List.of(new ItemConfig.Attribute(GENERIC_ARMOR_TOUGHNESS, 1.0f, AttributeModifier.Operation.ADDITION), new ItemConfig.Attribute(GENERIC_MAX_HEALTH, 6.0f, AttributeModifier.Operation.ADDITION)), 1344);
        }
        ArrayList<CustomShieldItem> shields = new ArrayList<CustomShieldItem>();
        for (Entry entry : ENTRIES) {
            ShieldsConfig.Entry config = configs.get(entry.id.toString());
            if (config == null) {
                config = new ShieldsConfig.Entry();
                config.durability = entry.durability;
                config.attributes = entry.attributes;
                configs.put(entry.id.toString(), config);
            }
            ArrayList<Tuple> shieldAttributes = new ArrayList<Tuple>();
            for (Map.Entry attributeEntry : Weapon.attributesFrom(config.attributes).entrySet()) {
                shieldAttributes.add(new Tuple((Object)((Attribute)attributeEntry.getKey()), (Object)((AttributeModifier)attributeEntry.getValue())));
            }
            CustomShieldItem shield = new CustomShieldItem(equipSound, entry.repair, shieldAttributes, (Item.Properties)new FabricItemSettings().maxDamage(config.durability));
            Registry.m_122965_((Registry)BuiltInRegistries.f_257033_, (ResourceLocation)entry.id, (Object)shield);
            shields.add(shield);
        }
        ItemGroupEvents.modifyEntriesEvent(Group.KEY).register(content -> {
            for (Item shield : shields) {
                content.m_246326_((ItemLike)shield);
            }
        });
    }

    public record Entry(ResourceLocation id, Supplier<Ingredient> repair, List<ItemConfig.Attribute> attributes, int durability) {
    }
}

