/*
 * Decompiled with CFR 0.152.
 */
package net.paladins.util;

import java.util.List;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.paladins.entity.BarrierEntity;
import net.paladins.item.Shields;
import net.paladins.item.armor.PaladinArmor;
import net.paladins.item.armor.PriestArmor;

public class SoundHelper {
    public static final SoundEvent divineProtectionImpact = SoundEvent.m_262824_((ResourceLocation)new ResourceLocation("paladins", "divine_protection_impact"));
    public static List<String> soundKeys = List.of("divine_protection_release", "judgement_impact", "divine_protection_impact", "battle_banner_release", "battle_banner_presence", "holy_shock_damage", "holy_shock_heal", "holy_beam_start_casting", "holy_beam_casting", "holy_beam_damage", "holy_beam_heal", "holy_beam_release");
    public static Map<String, Float> soundDistances = Map.of("judgement_impact", Float.valueOf(48.0f));

    public static void registerSounds() {
        for (String soundKey : soundKeys) {
            ResourceLocation soundId = new ResourceLocation("paladins", soundKey);
            Float customTravelDistance = soundDistances.get(soundKey);
            SoundEvent soundEvent = customTravelDistance == null ? SoundEvent.m_262824_((ResourceLocation)soundId) : SoundEvent.m_262856_((ResourceLocation)soundId, (float)customTravelDistance.floatValue());
            Registry.m_122965_((Registry)BuiltInRegistries.f_256894_, (ResourceLocation)soundId, (Object)soundEvent);
        }
        Registry.m_122965_((Registry)BuiltInRegistries.f_256894_, (ResourceLocation)PaladinArmor.equipSoundId, (Object)PaladinArmor.equipSound);
        Registry.m_122965_((Registry)BuiltInRegistries.f_256894_, (ResourceLocation)PriestArmor.equipSoundId, (Object)PriestArmor.equipSound);
        Registry.m_122965_((Registry)BuiltInRegistries.f_256894_, (ResourceLocation)Shields.equipSoundId, (Object)Shields.equipSound);
        Registry.m_122965_((Registry)BuiltInRegistries.f_256894_, (ResourceLocation)BarrierEntity.activateSoundId, (Object)BarrierEntity.activateSound);
        Registry.m_122965_((Registry)BuiltInRegistries.f_256894_, (ResourceLocation)BarrierEntity.idleSoundId, (Object)BarrierEntity.idleSound);
        Registry.m_122965_((Registry)BuiltInRegistries.f_256894_, (ResourceLocation)BarrierEntity.impactSoundId, (Object)BarrierEntity.impactSound);
        Registry.m_122965_((Registry)BuiltInRegistries.f_256894_, (ResourceLocation)BarrierEntity.deactivateSoundId, (Object)BarrierEntity.deactivateSound);
    }

    public static void playSoundEvent(Level world, Entity entity, SoundEvent soundEvent) {
        SoundHelper.playSoundEvent(world, entity, soundEvent, 1.0f, 1.0f);
    }

    public static void playSoundEvent(Level world, Entity entity, SoundEvent soundEvent, float volume, float pitch) {
        world.m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), soundEvent, SoundSource.PLAYERS, volume, pitch);
    }
}

