/*
 * Decompiled with CFR 0.152.
 */
package net.paladins.village;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import net.fabric_extras.structure_pool.api.StructurePoolAPI;
import net.fabric_extras.structure_pool.api.StructurePoolConfig;
import net.fabricmc.fabric.api.object.builder.v1.trade.TradeOfferHelper;
import net.fabricmc.fabric.api.object.builder.v1.world.poi.PointOfInterestHelper;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.paladins.PaladinsMod;
import net.paladins.block.PaladinBlocks;
import net.paladins.item.Weapons;
import net.paladins.item.armor.Armors;
import net.paladins.item.armor.PaladinArmor;
import net.runes.api.RuneItems;

public class PaladinVillagers {
    public static final String PALADIN_MERCHANT = "monk";

    public static PoiType registerPOI(String name, Block block) {
        return PointOfInterestHelper.register((ResourceLocation)new ResourceLocation("paladins", name), (int)1, (int)10, (Iterable)ImmutableSet.copyOf((Collection)block.m_49965_().m_61056_()));
    }

    public static VillagerProfession registerProfession(String name, ResourceKey<PoiType> workStation) {
        ResourceLocation id = new ResourceLocation("paladins", name);
        return (VillagerProfession)Registry.m_122965_((Registry)BuiltInRegistries.f_256735_, (ResourceLocation)new ResourceLocation("paladins", name), (Object)new VillagerProfession(id.toString(), entry -> entry.m_203565_(workStation), entry -> entry.m_203565_(workStation), ImmutableSet.of(), ImmutableSet.of(), PaladinArmor.equipSound));
    }

    public static void register() {
        StructurePoolAPI.injectAll((StructurePoolConfig)((StructurePoolConfig)PaladinsMod.villageConfig.value));
        PoiType poi = PaladinVillagers.registerPOI(PALADIN_MERCHANT, PaladinBlocks.MONK_WORKBENCH);
        VillagerProfession profession = PaladinVillagers.registerProfession(PALADIN_MERCHANT, (ResourceKey<PoiType>)ResourceKey.m_135785_((ResourceKey)BuiltInRegistries.f_256941_.m_123023_(), (ResourceLocation)new ResourceLocation("paladins", PALADIN_MERCHANT)));
        List<Offer> paladinMerchantOffers = List.of(Offer.sell(1, new ItemStack((ItemLike)RuneItems.get((RuneItems.RuneType)RuneItems.RuneType.HEALING), 8), 2, 128, 1, 0.01f), Offer.sell(1, Weapons.acolyte_wand.item().m_7968_(), 4, 12, 5, 0.1f), Offer.sell(1, Weapons.wooden_great_hammer.item().m_7968_(), 8, 12, 8, 0.1f), Offer.buy(2, new ItemStack((ItemLike)Items.f_41870_, 5), 8, 12, 8, 0.0f), Offer.buy(2, new ItemStack((ItemLike)Items.f_42416_, 6), 9, 12, 8, 0.0f), Offer.buy(2, new ItemStack((ItemLike)Items.f_42026_, 6), 3, 12, 8, 0.0f), Offer.buy(2, new ItemStack((ItemLike)Items.f_42417_, 6), 9, 12, 8, 0.0f), Offer.sell(2, Weapons.holy_staff.item().m_7968_(), 12, 12, 10, 0.05f), Offer.sell(2, Weapons.iron_great_hammer.item().m_7968_(), 12, 12, 10, 0.05f), Offer.sell(3, Armors.paladinArmorSet_t1.head.m_7968_(), 15, 12, 13, 0.05f), Offer.sell(3, Armors.paladinArmorSet_t1.feet.m_7968_(), 15, 12, 13, 0.05f), Offer.sell(3, Armors.priestArmorSet_t1.head.m_7968_(), 15, 12, 13, 0.05f), Offer.sell(3, Armors.priestArmorSet_t1.feet.m_7968_(), 15, 12, 13, 0.05f), Offer.sell(4, Armors.paladinArmorSet_t1.chest.m_7968_(), 20, 12, 15, 0.05f), Offer.sell(4, Armors.paladinArmorSet_t1.legs.m_7968_(), 20, 12, 15, 0.05f), Offer.sell(4, Armors.priestArmorSet_t1.chest.m_7968_(), 20, 12, 15, 0.05f), Offer.sell(4, Armors.priestArmorSet_t1.legs.m_7968_(), 20, 12, 15, 0.05f));
        for (Offer offer : paladinMerchantOffers) {
            TradeOfferHelper.registerVillagerOffers((VillagerProfession)profession, (int)offer.level, factories -> factories.add((entity, random) -> new MerchantOffer(offer.input, offer.output, offer.maxUses, offer.experience, offer.priceMultiplier)));
        }
        TradeOfferHelper.registerVillagerOffers((VillagerProfession)profession, (int)5, factories -> {
            factories.add((entity, random) -> new VillagerTrades.EnchantedItemForEmeralds(Weapons.diamond_holy_staff.item(), 40, 3, 30, 0.0f).m_213663_(entity, random));
            factories.add((entity, random) -> new VillagerTrades.EnchantedItemForEmeralds(Weapons.diamond_claymore.item(), 40, 3, 30, 0.0f).m_213663_(entity, random));
            factories.add((entity, random) -> new VillagerTrades.EnchantedItemForEmeralds(Weapons.diamond_great_hammer.item(), 40, 3, 30, 0.0f).m_213663_(entity, random));
        });
    }

    private static class Offer {
        int level;
        ItemStack input;
        ItemStack output;
        int maxUses;
        int experience;
        float priceMultiplier;

        public Offer(int level, ItemStack input, ItemStack output, int maxUses, int experience, float priceMultiplier) {
            this.level = level;
            this.input = input;
            this.output = output;
            this.maxUses = maxUses;
            this.experience = experience;
            this.priceMultiplier = priceMultiplier;
        }

        public static Offer buy(int level, ItemStack item, int price, int maxUses, int experience, float priceMultiplier) {
            return new Offer(level, item, new ItemStack((ItemLike)Items.f_42616_, price), maxUses, experience, priceMultiplier);
        }

        public static Offer sell(int level, ItemStack item, int price, int maxUses, int experience, float priceMultiplier) {
            return new Offer(level, new ItemStack((ItemLike)Items.f_42616_, price), item, maxUses, experience, priceMultiplier);
        }
    }
}

