/*
 * Decompiled with CFR 0.152.
 */
package com.koteinik.chunksfadein.gui;

import com.koteinik.chunksfadein.MathUtils;
import com.koteinik.chunksfadein.config.Config;
import com.koteinik.chunksfadein.gui.SettingsScreen;
import com.koteinik.chunksfadein.gui.components.ChunksFadeInButton;
import com.koteinik.chunksfadein.gui.components.ChunksFadeInSlider;
import java.util.function.DoubleSupplier;
import java.util.function.Supplier;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class GuiUtils {
    public static final int SPACING_Y = 28;
    public static final int SPACING_X = 4;
    private static final int BUTTON_W = 180;
    private static final int BUTTON_H = 20;

    public static Component toggledText(String key, boolean value) {
        return GuiUtils.coloredFormatted(key, GuiUtils.color(value), value ? SettingsScreen.ON : SettingsScreen.OFF);
    }

    public static Component choiceText(String key, boolean value) {
        return GuiUtils.coloredFormatted(key, GuiUtils.color(value), value ? SettingsScreen.YES : SettingsScreen.NO);
    }

    public static Component doubleText(String key, double value) {
        return GuiUtils.formattedText(key, MathUtils.round(value, 2));
    }

    public static Component coloredFormatted(String key, String color, Component arg) {
        return GuiUtils.formattedText(key, color + arg.getString());
    }

    public static Component text(String key) {
        return GuiUtils.formattedText(key, new Object[0]);
    }

    public static Component formattedText(String key, Object ... args) {
        return Component.m_237110_((String)key, (Object[])args);
    }

    public static ChunksFadeInButton choiceButton(Screen screen, int column, int row, String textKey, String configKey) {
        return GuiUtils.choiceButton(screen, column, row, textKey, configKey, null, null);
    }

    public static ChunksFadeInButton choiceButton(Screen screen, int column, int row, String textKey, String configKey, Boolean forcedValue, Component tooltip) {
        return GuiUtils.button(screen, column, row, () -> GuiUtils.choiceText(textKey, Config.getBoolean(configKey)), () -> Config.flipBoolean(configKey), forcedValue, tooltip);
    }

    public static ChunksFadeInButton toggledButton(Screen screen, int column, int row, String textKey, String configKey) {
        return GuiUtils.toggledButton(screen, column, row, textKey, configKey, null, null);
    }

    public static ChunksFadeInButton toggledButton(Screen screen, int column, int row, String textKey, String configKey, Boolean forcedValue, Component tooltip) {
        return GuiUtils.button(screen, column, row, () -> GuiUtils.toggledText(textKey, Config.getBoolean(configKey)), () -> Config.flipBoolean(configKey), forcedValue, tooltip);
    }

    public static ChunksFadeInButton doneButton(Screen screen) {
        return new ChunksFadeInButton(GuiUtils.calculateX(screen.f_96543_, 0), screen.f_96544_ - 20 - 8, 180, 20, () -> CommonComponents.f_130655_, () -> screen.m_7379_());
    }

    public static ChunksFadeInSlider slider(SettingsScreen screen, int column, int row, DoubleSupplier updateValue, DoubleSupplier displayValue, String textKey, String configKey, double scale) {
        ChunksFadeInSlider slider = new ChunksFadeInSlider(GuiUtils.calculateX(screen.f_96543_, column), GuiUtils.calculateY(screen.f_96544_, row), 180, 20, updateValue, value -> GuiUtils.doubleText(textKey, displayValue.getAsDouble()), value -> Config.setDouble(configKey, value), scale);
        return slider;
    }

    public static ChunksFadeInButton button(Screen screen, int column, int row, Supplier<Component> createText, Runnable onPressed) {
        return GuiUtils.button(screen, column, row, createText, onPressed, null, null);
    }

    public static ChunksFadeInButton button(Screen screen, int column, int row, Supplier<Component> createText, Runnable onPressed, Boolean forcedValue, Component tooltip) {
        return new ChunksFadeInButton(GuiUtils.calculateX(screen.f_96543_, column), GuiUtils.calculateY(screen.f_96544_, row), 180, 20, createText, onPressed, forcedValue, tooltip);
    }

    private static int calculateY(int screenSize, int row) {
        return screenSize / 2 - 10 + row * 28;
    }

    private static int calculateX(int screenSize, int column) {
        int halfScreen = screenSize / 2;
        return column == 0 ? halfScreen - 90 : halfScreen + 180 * (column - (column < 0 ? 0 : 1)) + 4 * column;
    }

    private static String color(boolean value) {
        return value ? "\u00a72" : "\u00a7c";
    }
}

