/*
 * Decompiled with CFR 0.152.
 */
package com.koteinik.chunksfadein.mixin.chunk;

import com.koteinik.chunksfadein.MathUtils;
import com.koteinik.chunksfadein.config.Config;
import com.koteinik.chunksfadein.extensions.RenderSectionExt;
import me.jellysquid.mods.sodium.client.render.chunk.RenderSection;
import me.jellysquid.mods.sodium.client.render.chunk.region.RenderRegion;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Position;
import net.minecraft.core.SectionPos;
import net.minecraft.world.entity.Entity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={RenderSection.class}, remap=false)
public class RenderSectionMixin
implements RenderSectionExt {
    private static final float[] FULLY_ANIMATED_OFFSET = new float[]{0.0f, 0.0f, 0.0f};
    @Shadow
    @Final
    private RenderRegion region;
    @Shadow
    @Final
    private int chunkX;
    @Shadow
    @Final
    private int chunkY;
    @Shadow
    @Final
    private int chunkZ;
    private long lastFrameTime = 0L;
    private boolean hasRenderedBefore;
    private float fadeCoeff = 0.0f;
    private float animationProgress = 0.0f;
    private final float[] offset = new float[]{0.0f, 0.0f, 0.0f};

    @Override
    public boolean hasRenderedBefore() {
        return this.hasRenderedBefore;
    }

    @Override
    public void setRenderedBefore() {
        this.hasRenderedBefore = true;
    }

    @Override
    public float incrementFadeCoeff(long delta) {
        if (this.fadeCoeff == 1.0f) {
            return 1.0f;
        }
        this.fadeCoeff += (float)delta * Config.fadeChangePerNano;
        if (this.fadeCoeff > 1.0f) {
            this.fadeCoeff = 1.0f;
        }
        return this.fadeCoeff;
    }

    @Override
    public float[] incrementAnimationOffset(long delta) {
        if (this.animationProgress == 1.0f) {
            return FULLY_ANIMATED_OFFSET;
        }
        this.animationProgress += (float)delta * Config.animationChangePerNano;
        if (this.animationProgress > 1.0f) {
            this.animationProgress = 1.0f;
        }
        if (!this.hasRenderedBefore() && !Config.animateNearPlayer) {
            int camChunkZ;
            SectionPos chunkPos;
            int camChunkX;
            int z;
            int x;
            Minecraft client = Minecraft.m_91087_();
            Entity camera = client.f_91075_;
            if (camera != null && MathUtils.chunkInRange(x = this.chunkX, z = this.chunkZ, camChunkX = (chunkPos = SectionPos.m_235863_((Position)camera.m_20182_())).m_123341_(), camChunkZ = chunkPos.m_123343_(), 1)) {
                this.animationProgress = 1.0f;
            }
        }
        float curved = Config.animationInitialOffset - Config.animationCurve.calculate(Float.valueOf(this.animationProgress)).floatValue() * Config.animationInitialOffset;
        float animY = (curved = -curved) > 0.0f ? 0.0f : curved;
        this.offset[1] = animY;
        return this.offset;
    }

    @Override
    public long calculateAndGetDelta() {
        long currentFrameTime = System.currentTimeMillis();
        long delta = this.lastFrameTime == 0L ? 0L : currentFrameTime - this.lastFrameTime;
        this.lastFrameTime = currentFrameTime;
        return delta * 1000000L;
    }

    @Override
    public float[] getAnimationOffset() {
        return this.offset;
    }

    @Override
    public float getFadeCoeff() {
        return this.fadeCoeff;
    }
}

