/*
 * Decompiled with CFR 0.152.
 */
package com.koteinik.chunksfadein.mixin.iris;

import com.koteinik.chunksfadein.config.Config;
import com.koteinik.chunksfadein.core.FadeTypes;
import com.koteinik.chunksfadein.core.IrisOutputColorDeclaration;
import io.github.douira.glsl_transformer.ast.node.TranslationUnit;
import io.github.douira.glsl_transformer.ast.node.declaration.TypeAndInitDeclaration;
import io.github.douira.glsl_transformer.ast.node.expression.Expression;
import io.github.douira.glsl_transformer.ast.node.expression.LiteralExpression;
import io.github.douira.glsl_transformer.ast.node.external_declaration.DeclarationExternalDeclaration;
import io.github.douira.glsl_transformer.ast.node.statement.Statement;
import io.github.douira.glsl_transformer.ast.node.type.FullySpecifiedType;
import io.github.douira.glsl_transformer.ast.node.type.qualifier.LayoutQualifier;
import io.github.douira.glsl_transformer.ast.node.type.qualifier.LayoutQualifierPart;
import io.github.douira.glsl_transformer.ast.node.type.qualifier.NamedLayoutQualifierPart;
import io.github.douira.glsl_transformer.ast.node.type.qualifier.TypeQualifier;
import io.github.douira.glsl_transformer.ast.node.type.qualifier.TypeQualifierPart;
import io.github.douira.glsl_transformer.ast.node.type.specifier.BuiltinNumericTypeSpecifier;
import io.github.douira.glsl_transformer.ast.query.Root;
import io.github.douira.glsl_transformer.ast.query.index.ExternalDeclarationIndex;
import io.github.douira.glsl_transformer.ast.transform.ASTInjectionPoint;
import io.github.douira.glsl_transformer.ast.transform.ASTParser;
import io.github.douira.glsl_transformer.util.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.irisshaders.iris.pipeline.transform.parameter.SodiumParameters;
import net.irisshaders.iris.pipeline.transform.transformer.SodiumTransformer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SodiumTransformer.class}, remap=false)
public class IrisSodiumTransformerMixin {
    @Inject(method={"transform"}, at={@At(value="TAIL")})
    private static void modifyTransform(ASTParser t, TranslationUnit tree, Root root, SodiumParameters parameters, CallbackInfo ci) {
        boolean isLined = Config.fadeType == FadeTypes.LINED;
        switch (parameters.type.glShaderType) {
            case VERTEX: {
                ArrayList<String> vertInitTail = new ArrayList<String>();
                vertInitTail.add("fadeCoeff = Chunk_FadeDatas[_draw_id].fadeData.w;");
                vertInitTail.add("_vert_position = _vert_position + Chunk_FadeDatas[_draw_id].fadeData.xyz;");
                if (isLined) {
                    vertInitTail.add("localHeight = _vert_position.y;");
                }
                tree.appendFunctionBody("_vert_init", IrisSodiumTransformerMixin.parseStatements(t, root, vertInitTail));
                ArrayList<String> vDefines = new ArrayList<String>();
                vDefines.add("out float fadeCoeff;");
                vDefines.add("struct ChunkFadeData { vec4 fadeData; };");
                vDefines.add("layout(std140) uniform ubo_ChunkFadeDatas { ChunkFadeData Chunk_FadeDatas[256]; };");
                if (isLined) {
                    vDefines.add("out float localHeight;");
                }
                tree.parseAndInjectNodes(t, ASTInjectionPoint.BEFORE_FUNCTIONS, vDefines.stream());
                break;
            }
            case FRAGMENT: {
                ArrayList<String> fDefines = new ArrayList<String>();
                fDefines.add("in float fadeCoeff;");
                if (isLined) {
                    fDefines.add("in float localHeight;");
                }
                tree.parseAndInjectNodes(t, ASTInjectionPoint.BEFORE_FUNCTIONS, fDefines.stream());
                ArrayList<Object> mainTail = new ArrayList<Object>();
                if (isLined) {
                    mainTail.add("float fadeLineY = fadeCoeff * 16.0;");
                }
                IrisOutputColorDeclaration layout0 = IrisSodiumTransformerMixin.findOutputColorVariable(root);
                boolean isVec3 = layout0.type == Type.F32VEC3;
                Object fadeLogic = "";
                fadeLogic = (String)fadeLogic + "if(fadeCoeff >= 0.0 && fadeCoeff < 1.0) {";
                fadeLogic = (String)fadeLogic + layout0.name + " = mix(" + layout0.name + ", iris_FogColor";
                if (isVec3) {
                    fadeLogic = (String)fadeLogic + ".xyz";
                }
                fadeLogic = (String)fadeLogic + ", ";
                fadeLogic = isLined ? (String)fadeLogic + "localHeight <= fadeLineY ? 0.0 : 1.0" : (String)fadeLogic + "1.0 - fadeCoeff";
                fadeLogic = (String)fadeLogic + ");";
                fadeLogic = (String)fadeLogic + "}";
                mainTail.add(fadeLogic);
                tree.appendMainFunctionBody(t, (String[])mainTail.toArray(String[]::new));
                break;
            }
        }
    }

    private static IrisOutputColorDeclaration findOutputColorVariable(Root root) {
        for (Map.Entry entry : root.externalDeclarationIndex.index.entrySet()) {
            try {
                String key = (String)entry.getKey();
                HashSet entries = (HashSet)entry.getValue();
                ExternalDeclarationIndex.DeclarationEntry declarationEntry = (ExternalDeclarationIndex.DeclarationEntry)entries.stream().findAny().get();
                DeclarationExternalDeclaration externalDeclaration = (DeclarationExternalDeclaration)declarationEntry.declaration();
                TypeAndInitDeclaration declaration = (TypeAndInitDeclaration)externalDeclaration.getDeclaration();
                FullySpecifiedType type = declaration.getType();
                BuiltinNumericTypeSpecifier typeSpecifier = (BuiltinNumericTypeSpecifier)type.getTypeSpecifier();
                Type variableType = typeSpecifier.type;
                TypeQualifier typeQualifier = type.getTypeQualifier();
                for (TypeQualifierPart part : typeQualifier.getParts()) {
                    if (!(part instanceof LayoutQualifier)) continue;
                    LayoutQualifier qualifier = (LayoutQualifier)part;
                    for (LayoutQualifierPart layoutPart : qualifier.getParts()) {
                        LiteralExpression expression;
                        int value;
                        NamedLayoutQualifierPart namedPart;
                        Expression expression2;
                        if (!(layoutPart instanceof NamedLayoutQualifierPart) || !((expression2 = (namedPart = (NamedLayoutQualifierPart)layoutPart).getExpression()) instanceof LiteralExpression) || (value = (expression = (LiteralExpression)expression2).getNumber().intValue()) != 0) continue;
                        return new IrisOutputColorDeclaration(key, variableType);
                    }
                }
            }
            catch (Exception exception) {
            }
        }
        return new IrisOutputColorDeclaration("iris_FragData0", Type.F32VEC4);
    }

    private static List<Statement> parseStatements(ASTParser t, Root root, List<String> lines) {
        return IrisSodiumTransformerMixin.parseStatements(t, root, (String[])lines.toArray(String[]::new));
    }

    private static List<Statement> parseStatements(ASTParser t, Root root, String ... lines) {
        return t.parseStatements(root, lines);
    }
}

