/*
 * Decompiled with CFR 0.152.
 */
package com.koteinik.chunksfadein.mixin.misc;

import com.koteinik.chunksfadein.config.Config;
import com.koteinik.chunksfadein.core.ModrinthApi;
import java.util.ArrayList;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.login.ClientLoginPacketListener;
import net.minecraft.network.protocol.login.ClientboundGameProfilePacket;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientboundGameProfilePacket.class})
public class ClientPacketListenerMixin {
    @Inject(method={"apply"}, at={@At(value="TAIL")})
    private void modifyApply(ClientLoginPacketListener clientLoginPacketListener, CallbackInfo ci) {
        if (!Config.isUpdateNotifierEnabled) {
            return;
        }
        new Thread(() -> {
            ModrinthApi.ModrinthVersion latestVersion = ModrinthApi.getLatestModVersion();
            if (ClientPacketListenerMixin.isNewerVersion(latestVersion)) {
                ArrayList<Component> textList = new ArrayList<Component>();
                textList.add(Component.m_130674_((String)"\u00a77New version of \u00a72Chunks fade in \u00a77is available!"));
                Style linkStyle = Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, latestVersion.downloadUrl));
                textList.add(Component.m_130674_((String)("\u00a77v" + latestVersion.version.getFriendlyString() + "\u00a7r\u00a77 changelog:")));
                textList.add(Component.m_130674_((String)("\u00a77" + latestVersion.changelog)));
                textList.addAll(Component.m_130674_((String)"\u00a77\u00a7nClick to download").m_178405_(linkStyle));
                for (Component text : textList) {
                    Minecraft.m_91087_().f_91074_.m_213846_(text);
                }
            }
        }).start();
    }

    private static boolean isNewerVersion(ModrinthApi.ModrinthVersion modrinthVersion) {
        return ((ModContainer)FabricLoader.getInstance().getModContainer("chunksfadein").get()).getMetadata().getVersion().compareTo((Object)modrinthVersion.version) < 0;
    }
}

