/*
 * Decompiled with CFR 0.152.
 */
package com.koteinik.chunksfadein.mixin.shader;

import com.koteinik.chunksfadein.config.Config;
import com.koteinik.chunksfadein.core.FadeTypes;
import com.koteinik.chunksfadein.core.ShaderInjector;
import com.koteinik.chunksfadein.hooks.CompatibilityHook;
import me.jellysquid.mods.sodium.client.gl.shader.ShaderLoader;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ShaderLoader.class}, remap=false)
public abstract class ShaderLoaderMixin {
    private static final ShaderInjector fragmentInjectorFull = new ShaderInjector();
    private static final ShaderInjector fragmentInjectorLined = new ShaderInjector();
    private static final ShaderInjector vertexInjectorFull = new ShaderInjector();
    private static final ShaderInjector vertexInjectorLined = new ShaderInjector();

    @Inject(method={"getShaderSource"}, at={@At(value="RETURN")}, cancellable=true)
    private static void modifyConstructor(ResourceLocation name, CallbackInfoReturnable<String> cir) {
        if (!Config.isModEnabled || CompatibilityHook.isIrisShaderPackInUse()) {
            return;
        }
        String path = name.m_135815_();
        String[] splittedPath = path.split("/");
        String shaderFileName = splittedPath[splittedPath.length - 1];
        String source = (String)cir.getReturnValue();
        boolean isFull = Config.fadeType == FadeTypes.FULL;
        switch (shaderFileName) {
            case "block_layer_opaque.fsh": {
                source = (isFull ? fragmentInjectorFull : fragmentInjectorLined).get(source);
                break;
            }
            case "block_layer_opaque.vsh": {
                source = (isFull ? vertexInjectorFull : vertexInjectorLined).get(source);
                break;
            }
        }
        cir.setReturnValue((Object)source);
    }

    static {
        fragmentInjectorFull.insertAfterInVars("in float v_FadeCoeff;");
        fragmentInjectorLined.copyFrom(fragmentInjectorFull);
        fragmentInjectorFull.appendToFunction("void main()", "if(v_FadeCoeff >= 0.0 && v_FadeCoeff < 1.0) {frag_color} = mix({frag_color}, u_FogColor, 1.0 - v_FadeCoeff);");
        fragmentInjectorLined.insertAfterInVars("in float v_LocalHeight;");
        fragmentInjectorLined.appendToFunction("void main()", "if(v_FadeCoeff >= 0.0 && v_FadeCoeff < 1.0) { float fadeLineY = v_FadeCoeff * 16.0; {frag_color} = mix({frag_color}, u_FogColor, v_LocalHeight <= fadeLineY ? 0.0 : 1.0); }");
        vertexInjectorFull.insertAfterOutVars(true, "out float v_FadeCoeff;");
        vertexInjectorFull.insertAfterUniforms("struct ChunkFadeData {", "    vec4 fadeData;", "};", "layout(std140) uniform ubo_ChunkFadeDatas {", "    ChunkFadeData Chunk_FadeDatas[256];", "};");
        vertexInjectorFull.insertAfterVariable("vec3 position", "vec4 chunkFadeData = Chunk_FadeDatas[{mesh_id}].fadeData;", "position.y = position.y + chunkFadeData.y;");
        vertexInjectorFull.appendToFunction("void main()", "v_FadeCoeff = chunkFadeData.w;");
        vertexInjectorLined.copyFrom(vertexInjectorFull);
        vertexInjectorLined.insertAfterOutVars("out float v_LocalHeight;");
        vertexInjectorLined.appendToFunction("void main()", "v_LocalHeight = _vert_position.y;");
    }
}

