/*
 * Decompiled with CFR 0.152.
 */
package net.runes.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.stream.Stream;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

public class RuneCraftingRecipe
implements Recipe<Container> {
    final Ingredient base;
    final Ingredient addition;
    final ItemStack result;
    private final ResourceLocation id;
    public static final String NAME = "crafting";
    public static final RecipeType<RuneCraftingRecipe> TYPE = new RecipeType<RuneCraftingRecipe>(){

        public String toString() {
            return RuneCraftingRecipe.NAME;
        }
    };
    public static final Serializer SERIALIZER = new Serializer();

    public RuneCraftingRecipe(ResourceLocation id, Ingredient base, Ingredient addition, ItemStack result) {
        this.id = id;
        this.base = base;
        this.addition = addition;
        this.result = result;
    }

    public boolean m_5818_(Container inventory, Level world) {
        return this.base.test(inventory.m_8020_(0)) && this.addition.test(inventory.m_8020_(1));
    }

    public ItemStack m_5874_(Container inventory, RegistryAccess registryManager) {
        ItemStack itemStack = this.result.m_41777_();
        CompoundTag nbtCompound = inventory.m_8020_(0).m_41783_();
        if (nbtCompound != null) {
            itemStack.m_41751_(nbtCompound.m_6426_());
        }
        return itemStack;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public ItemStack m_8043_(RegistryAccess registryManager) {
        return this.result;
    }

    public boolean testAddition(ItemStack stack) {
        return this.addition.test(stack);
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)Blocks.f_50625_);
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public RecipeType<?> m_6671_() {
        return TYPE;
    }

    public boolean m_142505_() {
        return Stream.of(this.base, this.addition).anyMatch(ingredient -> ingredient.m_43908_().length == 0);
    }

    public static class Serializer
    implements RecipeSerializer<RuneCraftingRecipe> {
        public RuneCraftingRecipe read(ResourceLocation identifier, JsonObject jsonObject) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)jsonObject, (String)"base"));
            Ingredient ingredient2 = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)jsonObject, (String)"addition"));
            ItemStack itemStack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)jsonObject, (String)"result"));
            return new RuneCraftingRecipe(identifier, ingredient, ingredient2, itemStack);
        }

        public RuneCraftingRecipe read(ResourceLocation identifier, FriendlyByteBuf packetByteBuf) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)packetByteBuf);
            Ingredient ingredient2 = Ingredient.m_43940_((FriendlyByteBuf)packetByteBuf);
            ItemStack itemStack = packetByteBuf.m_130267_();
            return new RuneCraftingRecipe(identifier, ingredient, ingredient2, itemStack);
        }

        public void write(FriendlyByteBuf packetByteBuf, RuneCraftingRecipe recipe) {
            recipe.base.m_43923_(packetByteBuf);
            recipe.addition.m_43923_(packetByteBuf);
            packetByteBuf.m_130055_(recipe.result);
        }
    }
}

