/*
 * Decompiled with CFR 0.152.
 */
package net.runes.crafting;

import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.inventory.ItemCombinerMenuSlotDefinition;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.runes.crafting.RuneCrafter;
import net.runes.crafting.RuneCrafting;
import net.runes.crafting.RuneCraftingBlock;
import net.runes.crafting.RuneCraftingCriteria;
import net.runes.crafting.RuneCraftingRecipe;
import org.jetbrains.annotations.Nullable;

public class RuneCraftingScreenHandler
extends ItemCombinerMenu {
    public static final MenuType<RuneCraftingScreenHandler> HANDLER_TYPE = new MenuType(RuneCraftingScreenHandler::new, FeatureFlags.f_244377_);
    private final Level world;
    @Nullable
    private RuneCraftingRecipe currentRecipe;
    private final List<RuneCraftingRecipe> recipes;

    public RuneCraftingScreenHandler(int syncId, Inventory playerInventory) {
        this(syncId, playerInventory, ContainerLevelAccess.f_39287_);
    }

    public RuneCraftingScreenHandler(int syncId, Inventory playerInventory, FriendlyByteBuf packetByteBuf) {
        this(syncId, playerInventory, ContainerLevelAccess.f_39287_);
    }

    public RuneCraftingScreenHandler(int syncId, Inventory playerInventory, ContainerLevelAccess context) {
        super(HANDLER_TYPE, syncId, playerInventory, context);
        this.world = playerInventory.f_35978_.m_9236_();
        this.recipes = this.world.m_7465_().m_44013_(RuneCraftingRecipe.TYPE);
    }

    protected ItemCombinerMenuSlotDefinition m_266183_() {
        return ItemCombinerMenuSlotDefinition.m_266303_().m_266197_(0, 27, 47, stack -> true).m_266197_(1, 76, 47, stack -> true).m_266198_(2, 134, 47).m_266441_();
    }

    protected boolean m_8039_(BlockState state) {
        return state.m_60713_((Block)RuneCraftingBlock.INSTANCE);
    }

    protected boolean m_6560_(Player player, boolean present) {
        return this.currentRecipe != null && this.currentRecipe.m_5818_(this.f_39769_, this.world);
    }

    protected void m_142365_(Player player, ItemStack stack) {
        RuneCrafter runeCrafter;
        stack.m_41678_(player.m_9236_(), player, stack.m_41613_());
        this.f_39768_.m_58395_(player, this.getInputStacks());
        this.decrementStack(0);
        this.decrementStack(1);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            RuneCraftingCriteria.INSTANCE.trigger(serverPlayer);
        }
        if ((runeCrafter = (RuneCrafter)player).shouldPlayRuneCraftingSound(player.f_19797_)) {
            this.world.m_7785_(player.m_20185_(), player.m_20186_(), player.m_20189_(), RuneCrafting.SOUND, SoundSource.BLOCKS, this.world.f_46441_.m_188501_() * 0.1f + 0.9f, 1.0f, true);
            runeCrafter.onPlayedRuneCraftingSound(player.f_19797_);
        }
    }

    private List<ItemStack> getInputStacks() {
        return List.of(this.f_39769_.m_8020_(0), this.f_39769_.m_8020_(1));
    }

    private void decrementStack(int slot) {
        ItemStack itemStack = this.f_39769_.m_8020_(slot);
        itemStack.m_41774_(1);
        this.f_39769_.m_6836_(slot, itemStack);
    }

    public void m_6640_() {
        List list = this.world.m_7465_().m_44056_(RuneCraftingRecipe.TYPE, this.f_39769_, this.world);
        if (list.isEmpty()) {
            this.f_39768_.m_6836_(0, ItemStack.f_41583_);
        } else {
            this.currentRecipe = (RuneCraftingRecipe)list.get(0);
            ItemStack itemStack = this.currentRecipe.m_5874_(this.f_39769_, this.world.m_9598_());
            this.f_39768_.m_6029_((Recipe)this.currentRecipe);
            this.f_39768_.m_6836_(0, itemStack);
        }
    }

    protected boolean isUsableAsAddition(ItemStack stack) {
        return this.recipes.stream().anyMatch(recipe -> recipe.testAddition(stack));
    }

    public boolean m_5882_(ItemStack stack, Slot slot) {
        return slot.f_40218_ != this.f_39768_ && super.m_5882_(stack, slot);
    }
}

