/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.qendolin.betterclouds.ConfigGUI;
import com.qendolin.betterclouds.Main;
import com.qendolin.betterclouds.clouds.Debug;
import com.qendolin.betterclouds.compat.GLCompat;
import com.qendolin.betterclouds.renderdoc.CaptureManager;
import com.qendolin.betterclouds.renderdoc.RenderDoc;
import com.qendolin.betterclouds.renderdoc.RenderDocLoader;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.commands.arguments.StringRepresentableArgument;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;

public class Commands {
    static void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        Minecraft client = Minecraft.m_91087_();
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"betterclouds:profile").then(ClientCommandManager.argument((String)"interval", (ArgumentType)IntegerArgumentType.integer((int)30)).executes(context -> {
            int interval = IntegerArgumentType.getInteger((CommandContext)context, (String)"interval");
            Main.debugChatMessage("profiling.enabled", interval);
            Debug.profileInterval = interval;
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"betterclouds:profile").then(ClientCommandManager.argument((String)"interval", (ArgumentType)IntegerArgumentType.integer((int)30)).executes(context -> {
            int interval = IntegerArgumentType.getInteger((CommandContext)context, (String)"interval");
            Main.debugChatMessage("profiling.enabled", interval);
            Debug.profileInterval = interval;
            return 1;
        }))).then(ClientCommandManager.literal((String)"stop").executes(context -> {
            Main.debugChatMessage("profiling.disabled", new Object[0]);
            Debug.profileInterval = 0;
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"betterclouds:frustum").then(ClientCommandManager.literal((String)"capture").executes(context -> {
            client.f_91060_.m_173018_();
            return 1;
        }))).then(ClientCommandManager.literal((String)"release").executes(context -> {
            client.f_91060_.m_173019_();
            return 1;
        }))).then(ClientCommandManager.literal((String)"debugCulling").then(ClientCommandManager.argument((String)"enable", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            Debug.frustumCulling = BoolArgumentType.getBool((CommandContext)context, (String)"enable");
            return 1;
        }))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"betterclouds:generator").then(ClientCommandManager.literal((String)"pause").executes(context -> {
            Debug.generatorPause = true;
            Main.debugChatMessage("generatorPaused", new Object[0]);
            return 1;
        }))).then(ClientCommandManager.literal((String)"resume").executes(context -> {
            Debug.generatorPause = false;
            Main.debugChatMessage("generatorResumed", new Object[0]);
            return 1;
        }))).then(ClientCommandManager.literal((String)"update").executes(context -> {
            Debug.generatorForceUpdate = true;
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"betterclouds:animation").then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"pause").executes(context -> {
            Debug.animationPause = 0;
            Main.debugChatMessage("animationPaused", new Object[0]);
            return 1;
        })).then(ClientCommandManager.argument((String)"ticks", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> {
            Debug.animationPause = IntegerArgumentType.getInteger((CommandContext)context, (String)"ticks");
            Main.debugChatMessage("animationPaused", new Object[0]);
            return 1;
        })))).then(ClientCommandManager.literal((String)"resume").executes(context -> {
            Debug.animationPause = -1;
            Main.debugChatMessage("animationResumed", new Object[0]);
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"betterclouds:config").then(ClientCommandManager.literal((String)"open").executes(context -> {
            client.m_6937_(() -> client.m_91152_((Screen)ConfigGUI.create(null)));
            return 1;
        }))).then(ClientCommandManager.literal((String)"reload").executes(context -> {
            Main.debugChatMessage("reloadingConfig", new Object[0]);
            Main.getConfigHandler().serializer().load();
            Main.debugChatMessage("configReloaded", new Object[0]);
            return 1;
        }))).then(ClientCommandManager.literal((String)"gpuIncompatibleMessage").then(ClientCommandManager.argument((String)"enable", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            boolean enable = BoolArgumentType.getBool((CommandContext)context, (String)"enable");
            if (Main.getConfig().gpuIncompatibleMessageEnabled == enable) {
                return 1;
            }
            Main.getConfig().gpuIncompatibleMessageEnabled = enable;
            Main.getConfigHandler().serializer().save();
            Main.debugChatMessage("updatedPreferences", new Object[0]);
            return 1;
        }))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"betterclouds:debug").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"renderdoc").then(ClientCommandManager.literal((String)"capture").executes(context -> {
            if (RenderDoc.isAvailable()) {
                Main.debugChatMessage("renderdoc.capture.trigger", new Object[0]);
                CaptureManager.capture(result -> {
                    if (result == null) {
                        Main.debugChatMessage("renderdoc.capture.failure", new Object[0]);
                    } else {
                        Path path = Path.of(result.path(), new String[0]);
                        Main.debugChatMessage("renderdoc.capture.success", Component.m_237113_((String)path.toAbsolutePath().normalize().toString()).m_130938_(style -> style.m_131162_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, path.getParent().toString()))));
                    }
                });
                return 1;
            }
            if (RenderDocLoader.isAvailable()) {
                Main.debugChatMessage((Component)Component.m_237110_((String)Main.debugChatMessageKey("renderdoc.prompt.load"), (Object[])new Object[]{Component.m_237115_((String)Main.debugChatMessageKey("renderdoc.prompt.load.action")).m_130938_(style -> style.m_131162_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/betterclouds:debug renderdoc load")))}));
                return 0;
            }
            Main.debugChatMessage((Component)Component.m_237110_((String)Main.debugChatMessageKey("renderdoc.prompt.install"), (Object[])new Object[]{Component.m_237115_((String)Main.debugChatMessageKey("renderdoc.prompt.install.action")).m_130938_(style -> style.m_131162_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/betterclouds:debug renderdoc install")))}));
            return 0;
        }))).then(ClientCommandManager.literal((String)"install").executes(context -> {
            CompletableFuture.runAsync(() -> {
                if (!RenderDoc.isAvailable() && !RenderDocLoader.isAvailable()) {
                    Main.debugChatMessage("renderdoc.downloading", new Object[0]);
                    try {
                        RenderDocLoader.install();
                    }
                    catch (Exception e) {
                        Main.debugChatMessage("generic.error", e.toString());
                    }
                }
                Path path = RenderDocLoader.libPath();
                Main.debugChatMessage("renderdoc.installed", Component.m_237113_((String)path.toAbsolutePath().normalize().toString()).m_130938_(style -> style.m_131162_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, path.getParent().toString()))));
            });
            return 1;
        }))).then(ClientCommandManager.literal((String)"uninstall").executes(context -> {
            try {
                RenderDocLoader.uninstall();
            }
            catch (Exception e) {
                Main.debugChatMessage("generic.error", e.toString());
                return 0;
            }
            return 1;
        }))).then(ClientCommandManager.literal((String)"load").executes(context -> {
            if (!RenderDocLoader.isAvailable()) {
                Main.debugChatMessage((Component)Component.m_237110_((String)Main.debugChatMessageKey("renderdoc.prompt.install"), (Object[])new Object[]{Component.m_237115_((String)Main.debugChatMessageKey("renderdoc.prompt.install.action")).m_130938_(style -> style.m_131162_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/betterclouds:debug renderdoc install")))}));
                return 0;
            }
            if (RenderDoc.isAvailable()) {
                Main.debugChatMessage("renderdoc.load.ready", RenderDoc.getAPIVersion());
                return 1;
            }
            try {
                long expires = System.currentTimeMillis() + 43200000L;
                CaptureManager.writeLaunchConfig(new CaptureManager.LaunchConfig(true, true, expires));
            }
            catch (IOException e) {
                Main.debugChatMessage("generic.error", e.toString());
                return 0;
            }
            Main.debugChatMessage("renderdoc.load.queued", new Object[0]);
            return 1;
        })))).then(ClientCommandManager.literal((String)"fallback").then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"name", FallbackArgumentType.fallback()).executes(context -> {
            FallbackArgument fallback = FallbackArgumentType.getFallback(context, "name");
            boolean enabled = fallback.get(Main.glCompat);
            Main.debugChatMessage((Component)Component.m_237113_((String)String.format("Fallback %s is currently %s", fallback.m_7912_(), enabled ? "enabled" : "disabled")));
            return 1;
        })).then(ClientCommandManager.argument((String)"enable", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            FallbackArgument fallback = FallbackArgumentType.getFallback(context, "name");
            boolean enable = BoolArgumentType.getBool((CommandContext)context, (String)"enable");
            fallback.set(Main.glCompat, enable);
            client.m_91391_().whenComplete((unused, throwable) -> Main.debugChatMessage((Component)Component.m_237113_((String)String.format("Fallback %s is now %s", fallback.m_7912_(), enable ? "enabled" : "disabled"))));
            return 1;
        })))));
    }

    private static class FallbackArgumentType
    extends StringRepresentableArgument<FallbackArgument> {
        private FallbackArgumentType() {
            super(FallbackArgument.CODEC, FallbackArgument::values);
        }

        public static StringRepresentableArgument<FallbackArgument> fallback() {
            return new FallbackArgumentType();
        }

        public static FallbackArgument getFallback(CommandContext<?> context, String id) {
            return (FallbackArgument)((Object)context.getArgument(id, FallbackArgument.class));
        }
    }

    private static enum FallbackArgument implements StringRepresentable
    {
        BASE_INSTANCE(GLCompat::useBaseInstanceFallback, GLCompat::setUseBaseInstanceFallback),
        STENCIL_TEXTURE(GLCompat::useStencilTextureFallback, GLCompat::setUseStencilTextureFallback),
        TEX_STORAGE(GLCompat::useTexStorageFallback, GLCompat::setUseTexStorageFallback),
        DEPTH_WRITE(GLCompat::useDepthWriteFallback, GLCompat::setUseDepthWriteFallback);

        private static final StringRepresentable.EnumCodec<FallbackArgument> CODEC;
        private final Function<GLCompat, Boolean> getter;
        private final BiConsumer<GLCompat, Boolean> setter;

        private FallbackArgument(Function<GLCompat, Boolean> getter, BiConsumer<GLCompat, Boolean> setter) {
            this.getter = getter;
            this.setter = setter;
        }

        public void set(GLCompat compat, boolean enable) {
            this.setter.accept(compat, enable);
        }

        public boolean get(GLCompat compat) {
            return this.getter.apply(compat);
        }

        public String m_7912_() {
            return this.name().toLowerCase();
        }

        static {
            CODEC = StringRepresentable.m_216439_(FallbackArgument::values);
        }
    }
}

