/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds;

import com.google.gson.FieldNamingPolicy;
import com.mojang.blaze3d.platform.GlUtil;
import com.qendolin.betterclouds.Commands;
import com.qendolin.betterclouds.Config;
import com.qendolin.betterclouds.NamedLogger;
import com.qendolin.betterclouds.ShaderPresetLoader;
import com.qendolin.betterclouds.clouds.Debug;
import com.qendolin.betterclouds.compat.DistantHorizonsCompat;
import com.qendolin.betterclouds.compat.GLCompat;
import com.qendolin.betterclouds.compat.HardwareCompat;
import com.qendolin.betterclouds.compat.IrisCompat;
import com.qendolin.betterclouds.compat.Telemetry;
import com.qendolin.betterclouds.platform.EventHooks;
import com.qendolin.betterclouds.platform.ModLoader;
import com.qendolin.betterclouds.platform.ModVersion;
import com.qendolin.betterclouds.renderdoc.RenderDoc;
import dev.isxander.yacl3.config.v2.api.ConfigClassHandler;
import dev.isxander.yacl3.config.v2.api.serializer.GsonConfigSerializerBuilder;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.LogManager;

public class Main {
    public static final String MODID = "betterclouds";
    public static final boolean IS_DEV = ModLoader.isDevelopmentEnvironment();
    public static final boolean IS_CLIENT = ModLoader.isClientEnvironment();
    public static final NamedLogger LOGGER = new NamedLogger(LogManager.getLogger((String)"betterclouds"), !IS_DEV);
    public static GLCompat glCompat = null;
    public static ModVersion version = null;
    private static final Path CONFIG_PATH = ModLoader.getConfigDir().resolve("betterclouds-v1.json");
    private static ConfigClassHandler<Config> config;
    private static boolean isInitialized;

    public static void initGlCompat() {
        LOGGER.info("Initializing OpenGL compat");
        try {
            glCompat = new GLCompat(IS_DEV);
        }
        catch (Exception e) {
            Telemetry.INSTANCE.sendUnhandledException(e);
            throw e;
        }
        if (glCompat.isIncompatible()) {
            LOGGER.warn("Your GPU (or configuration) is not compatible with Better Clouds. Try updating your drivers?");
            LOGGER.info(" - Vendor:       {}", glCompat.getString(7936));
            LOGGER.info(" - Renderer:     {}", glCompat.getString(7937));
            LOGGER.info(" - GL Version:   {}", glCompat.getString(7938));
            LOGGER.info(" - GLSL Version: {}", glCompat.getString(35724));
            LOGGER.info(" - Extensions:   {}", String.join((CharSequence)", ", Main.glCompat.supportedCheckedExtensions));
            LOGGER.info(" - Functions:    {}", String.join((CharSequence)", ", Main.glCompat.supportedCheckedFunctions));
        } else if (glCompat.isPartiallyIncompatible()) {
            LOGGER.warn("Your GPU is not fully compatible with Better Clouds.");
            for (String fallback : glCompat.usedFallbacks()) {
                LOGGER.info("- Using {} fallback", fallback);
            }
        }
        Main.sendSystemDetailsTelemetry();
    }

    public static Config getConfig() {
        return (Config)config.instance();
    }

    public static boolean isProfilingEnabled() {
        return Debug.profileInterval > 0;
    }

    public static void debugChatMessage(String id, Object ... args) {
        Main.debugChatMessage((Component)Component.m_237110_((String)Main.debugChatMessageKey(id), (Object[])args));
    }

    public static void debugChatMessage(Component message) {
        Minecraft client = Minecraft.m_91087_();
        if (client == null || client.f_91073_ == null) {
            return;
        }
        client.f_91065_.m_93076_().m_93785_((Component)Component.m_237113_((String)"\u00a7e[\u00a7bBC\u00a7b\u00a7e]\u00a7r ").m_7220_(message));
    }

    public static String debugChatMessageKey(String id) {
        return "betterclouds.message." + id;
    }

    public static ModVersion getVersion() {
        return version;
    }

    public static ConfigClassHandler<Config> getConfigHandler() {
        return config;
    }

    public static void initializeClientEvents() {
        EventHooks.instance.onClientStarted(client -> glCompat.enableDebugOutputSynchronousDev());
        EventHooks.instance.onWorldJoin(client -> {
            if (glCompat.isIncompatible()) {
                CompletableFuture.delayedExecutor(5L, TimeUnit.SECONDS).execute(() -> client.execute(Main::sendGpuIncompatibleChatMessage));
            } else if (glCompat.isPartiallyIncompatible()) {
                CompletableFuture.delayedExecutor(5L, TimeUnit.SECONDS).execute(() -> client.execute(Main::sendGpuPartiallyIncompatibleChatMessage));
            }
            if (HardwareCompat.isMaybeIncompatible()) {
                CompletableFuture.delayedExecutor(5L, TimeUnit.SECONDS).execute(() -> client.execute(Main::sendHardwareMaybeIncompatibleChatMessage));
            }
            if (RenderDoc.isAvailable()) {
                Main.debugChatMessage("renderdoc.load.ready", RenderDoc.getAPIVersion());
            }
        });
        EventHooks.instance.onClientResourcesReload(() -> ShaderPresetLoader.INSTANCE);
        EventHooks.instance.onClientCommandRegistration(Commands::register);
    }

    public static void initializeClient() {
        if (!IS_CLIENT) {
            throw new IllegalStateException("Minecraft environment is not 'client' but the client initializer was called");
        }
        if (isInitialized) {
            return;
        }
        isInitialized = true;
        Main.initConfig();
        Main.loadConfig();
        version = ModLoader.getModVersion(MODID);
        DistantHorizonsCompat.initialize();
        IrisCompat.initialize();
        Main.sendSystemDetailsTelemetry();
        if (!IS_DEV) {
            return;
        }
        LOGGER.info("Initialized in dev mode, performance might vary");
    }

    public static boolean initialized() {
        return isInitialized;
    }

    private static void initConfig() {
        if (!IS_CLIENT || Main.config != null) {
            return;
        }
        Main.config = ConfigClassHandler.createBuilder(Config.class).id(ResourceLocation.m_214293_((String)MODID, (String)"betterclouds-v1")).serializer(config -> GsonConfigSerializerBuilder.create((ConfigClassHandler)config).appendGsonBuilder(b -> b.setLenient().serializeNulls().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().registerTypeAdapter(Config.class, Config.INSTANCE_CREATOR).registerTypeAdapter(Config.ShaderConfigPreset.class, Config.ShaderConfigPreset.INSTANCE_CREATOR).registerTypeAdapter(ResourceKey.class, (Object)Config.REGISTRY_KEY_SERIALIZER)).setPath(CONFIG_PATH).setJson5(false).build()).build();
    }

    private static void loadConfig() {
        assert (config != null);
        try {
            config.load();
            return;
        }
        catch (Exception loadException) {
            LOGGER.error("Failed to load config: ", (Throwable)loadException);
            File file = CONFIG_PATH.toFile();
            if (file.exists() && file.isFile()) {
                String backupName = FilenameUtils.getBaseName((String)file.getName()) + "-backup-" + new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date()) + "." + FilenameUtils.getExtension((String)file.getName());
                Path backup = Path.of(CONFIG_PATH.toAbsolutePath().getParent().toString(), backupName);
                try {
                    Files.copy(file.toPath(), backup, StandardCopyOption.REPLACE_EXISTING);
                    LOGGER.info("Created config backup at: {}", backup);
                }
                catch (Exception backupException) {
                    LOGGER.error("Failed to create config backup: ", (Throwable)backupException);
                }
            } else if (file.exists()) {
                file.delete();
                LOGGER.info("Deleted old config");
            }
            try {
                config.save();
                LOGGER.info("Created new config");
                config.load();
            }
            catch (Exception loadException2) {
                LOGGER.error("Failed to load config again, please report this issue: ", (Throwable)loadException2);
            }
            return;
        }
    }

    private static void sendSystemDetailsTelemetry() {
        if (!isInitialized || glCompat == null) {
            return;
        }
        if (Main.getConfig().lastTelemetryVersion >= 3) {
            return;
        }
        Telemetry.INSTANCE.sendSystemInfo().whenComplete((success, throwable) -> {
            Minecraft client = Minecraft.m_91087_();
            if (success.booleanValue() && client != null) {
                client.execute(() -> {
                    Main.getConfig().lastTelemetryVersion = 3;
                    config.save();
                });
            }
        });
    }

    public static void sendGpuIncompatibleChatMessage() {
        if (!Main.getConfig().gpuIncompatibleMessageEnabled) {
            return;
        }
        Main.debugChatMessage((Component)Component.m_237115_((String)Main.debugChatMessageKey("gpuIncompatible")).m_7220_((Component)Component.m_237113_((String)"\n - ")).m_7220_((Component)Component.m_237115_((String)Main.debugChatMessageKey("generic.disable")).m_130938_(style -> style.m_131155_(Boolean.valueOf(true)).m_131162_(Boolean.valueOf(true)).m_131140_(ChatFormatting.GRAY).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/betterclouds:config gpuIncompatibleMessage false")))));
    }

    public static void sendGpuPartiallyIncompatibleChatMessage() {
        if (!Main.getConfig().gpuIncompatibleMessageEnabled) {
            return;
        }
        Main.debugChatMessage((Component)Component.m_237115_((String)Main.debugChatMessageKey("gpuPartiallyIncompatible")).m_7220_((Component)Component.m_237113_((String)"\n - ")).m_7220_((Component)Component.m_237115_((String)Main.debugChatMessageKey("generic.disable")).m_130938_(style -> style.m_131155_(Boolean.valueOf(true)).m_131162_(Boolean.valueOf(true)).m_131140_(ChatFormatting.GRAY).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/betterclouds:config gpuIncompatibleMessage false")))));
    }

    public static void sendHardwareMaybeIncompatibleChatMessage() {
        if (!Main.getConfig().gpuIncompatibleMessageEnabled) {
            return;
        }
        Main.debugChatMessage((Component)Component.m_237110_((String)Main.debugChatMessageKey("hwMaybeIncompatible"), (Object[])new Object[]{GlUtil.m_84819_(), GlUtil.m_84820_()}).m_7220_((Component)Component.m_237113_((String)"\n - ")).m_7220_((Component)Component.m_237115_((String)Main.debugChatMessageKey("generic.disable")).m_130938_(style -> style.m_131155_(Boolean.valueOf(true)).m_131162_(Boolean.valueOf(true)).m_131140_(ChatFormatting.GRAY).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/betterclouds:config gpuIncompatibleMessage false")))));
    }

    static {
        isInitialized = false;
    }
}

