/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.qendolin.betterclouds.Config;
import com.qendolin.betterclouds.Main;
import java.io.BufferedReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;

public class ShaderPresetLoader
implements IdentifiableResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setLenient().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).registerTypeAdapter(Config.ShaderConfigPreset.class, Config.ShaderConfigPreset.INSTANCE_CREATOR).create();
    public static final ResourceLocation ID = ResourceLocation.m_214293_((String)"betterclouds", (String)"shader_presets");
    public static final ResourceLocation RESOURCE_ID = ResourceLocation.m_214293_((String)"betterclouds", (String)"betterclouds/shader_presets.json");
    public static final ShaderPresetLoader INSTANCE = new ShaderPresetLoader();
    private Map<String, Config.ShaderConfigPreset> presets = null;

    public Map<String, Config.ShaderConfigPreset> presets() {
        if (this.presets == null) {
            return Map.of();
        }
        return ImmutableMap.copyOf(this.presets);
    }

    public ResourceLocation getFabricId() {
        return ID;
    }

    public CompletableFuture<Void> m_5540_(PreparableReloadListener.PreparationBarrier helper, ResourceManager manager, ProfilerFiller loadProfiler, ProfilerFiller applyProfiler, Executor loadExecutor, Executor applyExecutor) {
        return ((CompletableFuture)this.load(manager, loadProfiler, loadExecutor).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)helper).m_6769_(arg_0))).thenCompose(o -> this.apply((Map<String, Config.ShaderConfigPreset>)o, manager, applyProfiler, applyExecutor));
    }

    public CompletableFuture<Map<String, Config.ShaderConfigPreset>> load(ResourceManager manager, ProfilerFiller profiler, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            HashMap mergedPresets = new HashMap();
            Type mapType = new TypeToken<Map<String, Config.ShaderConfigPreset>>(){}.getType();
            for (Resource resource : manager.m_213829_(RESOURCE_ID)) {
                try {
                    BufferedReader reader = resource.m_215508_();
                    try {
                        Map presets = (Map)GSON.fromJson((Reader)reader, mapType);
                        if (presets == null) continue;
                        mergedPresets.putAll(presets);
                    }
                    finally {
                        if (reader == null) continue;
                        reader.close();
                    }
                }
                catch (Exception exception) {
                    Main.LOGGER.warn("Failed to parse shader presets {} in pack '{}'", RESOURCE_ID, resource.m_247173_().m_5542_(), exception);
                }
            }
            mergedPresets.values().removeAll(Collections.singleton(null));
            for (Map.Entry entry : mergedPresets.entrySet()) {
                ((Config.ShaderConfigPreset)entry.getValue()).editable = false;
                ((Config.ShaderConfigPreset)entry.getValue()).key = (String)entry.getKey();
            }
            return mergedPresets;
        });
    }

    public CompletableFuture<Void> apply(Map<String, Config.ShaderConfigPreset> data, ResourceManager manager, ProfilerFiller profiler, Executor executor) {
        this.presets = data;
        if (Main.getConfig() != null) {
            Main.getConfig().loadDefaultPresets();
        }
        return CompletableFuture.completedFuture(null);
    }
}

