/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.clouds;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import com.qendolin.betterclouds.Config;
import com.qendolin.betterclouds.Main;
import com.qendolin.betterclouds.clouds.ChunkedGenerator;
import com.qendolin.betterclouds.clouds.Debug;
import com.qendolin.betterclouds.clouds.Mesh;
import com.qendolin.betterclouds.clouds.Resources;
import com.qendolin.betterclouds.clouds.shaders.ShaderParameters;
import com.qendolin.betterclouds.compat.DistantHorizonsCompat;
import com.qendolin.betterclouds.compat.HeadInTheCloudsCompat;
import com.qendolin.betterclouds.compat.IrisCompat;
import com.qendolin.betterclouds.compat.WorldDuck;
import com.qendolin.betterclouds.renderdoc.RenderDoc;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.CloudStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Mth;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4d;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector4d;
import org.lwjgl.opengl.GL32;

public class Renderer
implements AutoCloseable {
    private final Minecraft client;
    private ClientLevel world = null;
    private float cloudsHeight;
    private final Matrix4f mvpMatrix = new Matrix4f();
    private final Matrix4f mvMatrix = new Matrix4f();
    private final Matrix4f pMatrix = new Matrix4f();
    private final Matrix4d pInverseMatrix = new Matrix4d();
    private final Matrix4f rotationProjectionMatrix = new Matrix4f();
    private final Matrix4f tempMatrix = new Matrix4f();
    private final Vector3f tempVector = new Vector3f();
    private final Frustum tempFrustum = new Frustum(new Matrix4f().identity(), new Matrix4f().identity());
    private ShaderParameters shaderParameters = null;
    private final Resources res = new Resources();

    public Renderer(Minecraft client) {
        this.client = client;
    }

    public void setWorld(ClientLevel world) {
        this.world = world;
    }

    public void reload(ResourceManager manager) {
        Main.LOGGER.info("Reloading cloud renderer...");
        Main.LOGGER.debug("[1/6] Reloading shaders");
        this.shaderParameters = this.createShaderParameters(Main.getConfig());
        this.res.reloadShaders(manager, this.shaderParameters);
        Main.LOGGER.debug("[2/6] Reloading generator");
        this.res.reloadGenerator(this.isFancyMode());
        Main.LOGGER.debug("[3/6] Reloading textures");
        this.res.reloadTextures(this.client);
        Main.LOGGER.debug("[4/6] Reloading primitive meshes");
        this.res.reloadMeshPrimitives();
        Main.LOGGER.debug("[5/6] Reloading framebuffer");
        this.res.reloadFramebuffer(this.scaledFramebufferWidth(), this.scaledFramebufferHeight());
        Main.LOGGER.debug("[6/6] Reloading timers");
        this.res.reloadTimer();
        Main.LOGGER.info("Cloud renderer initialized");
    }

    private boolean isFancyMode() {
        return this.client.f_91066_.m_92174_() == CloudStatus.FANCY;
    }

    private int scaledFramebufferWidth() {
        return (int)(Main.getConfig().preset().upscaleResolutionFactor * (float)this.client.m_91385_().f_83915_);
    }

    private int scaledFramebufferHeight() {
        return (int)(Main.getConfig().preset().upscaleResolutionFactor * (float)this.client.m_91385_().f_83916_);
    }

    private ShaderParameters createShaderParameters(Config config) {
        return new ShaderParameters(this.client.f_91066_.m_92174_(), config.blockDistance(), config.fadeEdge, config.sizeXZ, config.sizeY, config.celestialBodyHalo, Main.glCompat.useDepthWriteFallback(), Main.glCompat.useStencilTextureFallback(), DistantHorizonsCompat.instance().isReady() && DistantHorizonsCompat.instance().isEnabled(), config.preset().worldCurvatureSize);
    }

    public PrepareResult prepare(Matrix4f viewMat, Matrix4f projMat, int ticks, float tickDelta, Vector3d cam) {
        assert (RenderSystem.isOnRenderThread());
        this.client.m_91307_().m_6182_("render_setup");
        Config config = Main.getConfig();
        if (this.res.failedToLoadCritical()) {
            if (RenderDoc.isFrameCapturing()) {
                Main.glCompat.debugMessage("prepare failed: critical resource not loaded");
            }
            return PrepareResult.FALLBACK;
        }
        if (!config.irisSupport && IrisCompat.instance().isShadersEnabled()) {
            if (RenderDoc.isFrameCapturing()) {
                Main.glCompat.debugMessage("prepare failed: iris support disabled");
            }
            return PrepareResult.FALLBACK;
        }
        if (this.client.f_91063_.m_109153_().m_167685_() != FogType.NONE) {
            return PrepareResult.NO_RENDER;
        }
        DimensionSpecialEffects effects = this.world.m_104583_();
        this.cloudsHeight = effects.m_108871_();
        this.res.generator().bind();
        ShaderParameters currentShaderParameters = this.createShaderParameters(config);
        if (!Objects.equals(currentShaderParameters, this.shaderParameters)) {
            this.shaderParameters = currentShaderParameters;
            this.res.reloadShaders(this.client.m_91098_(), this.shaderParameters);
        }
        this.res.generator().reallocateIfStale(config, this.isFancyMode());
        float raininess = Math.max(0.6f * this.getTrueRainGradient(tickDelta), this.getTrueThunderGradient(tickDelta));
        float cloudiness = raininess * 0.3f + 0.5f;
        this.res.generator().update(cam, (float)ticks + tickDelta, Main.getConfig(), cloudiness);
        if (this.res.generator().canGenerate() && !this.res.generator().generating() && !Debug.generatorPause) {
            this.client.m_91307_().m_6182_("generate_clouds");
            this.res.generator().generate();
            this.client.m_91307_().m_6182_("render_setup");
        }
        if (this.res.generator().canSwap()) {
            this.client.m_91307_().m_6182_("swap");
            this.res.generator().swap();
            this.client.m_91307_().m_6182_("render_setup");
        }
        this.tempMatrix.set((Matrix4fc)viewMat);
        this.rotationProjectionMatrix.set((Matrix4fc)projMat);
        this.tempMatrix.m30(0.0f);
        this.tempMatrix.m31(0.0f);
        this.tempMatrix.m32(0.0f);
        this.tempMatrix.m33(0.0f);
        this.tempMatrix.m23(0.0f);
        this.tempMatrix.m13(0.0f);
        this.tempMatrix.m03(0.0f);
        this.rotationProjectionMatrix.mul((Matrix4fc)this.tempMatrix);
        this.tempMatrix.translate((float)this.res.generator().renderOriginX(cam.x), (float)((double)this.cloudsHeight - cam.y), (float)this.res.generator().renderOriginZ(cam.z));
        this.tempMatrix.m33(1.0f);
        this.pMatrix.set((Matrix4fc)projMat);
        this.pInverseMatrix.set((Matrix4fc)projMat);
        this.pInverseMatrix.invert();
        this.mvMatrix.set((Matrix4fc)this.tempMatrix);
        this.mvpMatrix.set((Matrix4fc)projMat);
        this.mvpMatrix.mul((Matrix4fc)this.mvMatrix);
        return PrepareResult.RENDER;
    }

    public void render(int ticks, float tickDelta, Vector3d cam, Vector3d frustumPos, Frustum frustum) {
        this.client.m_91307_().m_6182_("render_setup");
        if (Main.isProfilingEnabled()) {
            if (this.res.timer() == null) {
                this.res.reloadTimer();
            }
            this.res.timer().start();
        }
        Config config = Main.getConfig();
        if (this.isFramebufferStale()) {
            this.res.reloadFramebuffer(this.scaledFramebufferWidth(), this.scaledFramebufferHeight());
        }
        RenderSystem.viewport((int)0, (int)0, (int)this.res.fboWidth(), (int)this.res.fboHeight());
        GlStateManager._glBindFramebuffer((int)36009, (int)this.res.oitFbo());
        RenderSystem.clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        RenderSystem.clearDepth((double)1.0);
        this.client.m_91307_().m_6182_("draw_coverage");
        this.drawCoverage((float)ticks + tickDelta, cam, frustumPos, frustum);
        this.client.m_91307_().m_6182_("draw_shading");
        RenderStateShard.OutputStateShard renderPhase = null;
        if (IrisCompat.instance().isShadersEnabled() && config.useIrisFBO) {
            IrisCompat.instance().bindFramebuffer();
        } else {
            this.client.m_91385_().m_83947_(false);
            renderPhase = RenderStateShard.f_110128_;
            renderPhase.m_110185_();
        }
        this.drawShading(cam, tickDelta);
        this.client.m_91307_().m_6182_("render_cleanup");
        this.res.generator().unbind();
        Resources.unbindShader();
        RenderSystem.disableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.depthFunc((int)515);
        RenderSystem.activeTexture((int)33984);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        if (renderPhase != null) {
            renderPhase.m_110188_();
        }
        if (!Main.glCompat.useStencilTextureFallback()) {
            GL32.glDisable((int)2960);
            GL32.glStencilFunc((int)519, (int)0, (int)255);
            GL32.glStencilOp((int)7680, (int)7680, (int)7680);
        }
        if (Debug.frustumCulling) {
            Main.glCompat.pushDebugGroupDev("Frustum Culling Debug Draw");
            Debug.drawFrustumCulledBoxes(cam);
            Main.glCompat.popDebugGroupDev();
        }
        if (Main.isProfilingEnabled() && this.res.timer() != null) {
            this.res.timer().stop();
            if (this.res.timer().frames() >= Debug.profileInterval) {
                List<Double> times = this.res.timer().get();
                times.sort(Double::compare);
                double median = times.get(times.size() / 2);
                double p25 = times.get((int)Math.ceil((double)times.size() * 0.25));
                double p75 = times.get((int)Math.ceil((double)times.size() * 0.75));
                double min = times.get(0);
                double max = times.get(times.size() - 1);
                double average = times.stream().mapToDouble(d -> d).average().orElse(0.0);
                Main.debugChatMessage("profiling.gpuTimes", min, average, max, p25, median, p75);
                this.res.timer().reset();
            }
        }
    }

    private boolean isFramebufferStale() {
        return this.res.fboWidth() != this.scaledFramebufferWidth() || this.res.fboHeight() != this.scaledFramebufferHeight();
    }

    private void drawCoverage(float ticks, Vector3d cam, Vector3d frustumPos, Frustum frustum) {
        RenderSystem.enableDepthTest();
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.depthMask((boolean)true);
        GL32.glEnable((int)34383);
        if (Main.glCompat.useStencilTextureFallback()) {
            RenderSystem.depthFunc((int)519);
            RenderSystem.enableBlend();
            RenderSystem.blendEquation((int)32774);
            Main.glCompat.blendFunci(0, 1, 0);
            Main.glCompat.blendFunci(1, 1, 1);
            GL32.glDisable((int)2960);
        } else {
            RenderSystem.depthFunc((int)515);
            RenderSystem.disableBlend();
            GL32.glEnable((int)2960);
            GL32.glStencilMask((int)255);
            GL32.glClearStencil((int)0);
            GL32.glStencilOp((int)7680, (int)7682, (int)7682);
            GL32.glStencilFunc((int)519, (int)255, (int)255);
        }
        if (this.isFancyMode()) {
            RenderSystem.enableCull();
        } else {
            RenderSystem.disableCull();
        }
        GL32.glClear((int)17664);
        Config generatorConfig = this.getGeneratorConfig();
        Config config = Main.getConfig();
        this.res.coverageShader().bind();
        this.res.coverageShader().uMVPMatrix.setMat4(this.mvpMatrix);
        this.res.coverageShader().uOriginOffset.setVec3((float)(-this.res.generator().renderOriginX(cam.x)), (float)cam.y - this.cloudsHeight, (float)(-this.res.generator().renderOriginZ(cam.z)));
        this.res.coverageShader().uBoundingBox.setVec4((float)cam.x, (float)cam.z, (float)generatorConfig.blockDistance() - (float)generatorConfig.chunkSize / 2.0f, generatorConfig.yRange + config.sizeY);
        this.res.coverageShader().uTime.setFloat(ticks / 20.0f);
        this.res.coverageShader().uMiscellaneous.setVec3(config.scaleFalloffMin, config.windEffectFactor, config.windSpeedFactor);
        FogShape shape = RenderSystem.getShaderFogShape();
        if (shape == FogShape.CYLINDER) {
            this.res.coverageShader().uFogRange.setVec2(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY);
        } else {
            this.res.coverageShader().uFogRange.setVec2(RenderSystem.getShaderFogStart(), RenderSystem.getShaderFogEnd());
        }
        Vector4d farPlane = new Vector4d(0.0, 0.0, 1.0, 1.0);
        Vector4d nearPlane = new Vector4d(0.0, 0.0, -1.0, 1.0);
        this.pInverseMatrix.transform(farPlane);
        this.pInverseMatrix.transform(nearPlane);
        this.res.coverageShader().uDepthRange.setVec3((float)(-nearPlane.z / nearPlane.w), (float)(-farPlane.z / farPlane.w), config.blockDistance());
        RenderSystem.activeTexture((int)33984);
        RenderSystem.bindTexture((int)this.client.m_91385_().m_83980_());
        if (DistantHorizonsCompat.instance().isReady() && DistantHorizonsCompat.instance().isEnabled()) {
            this.res.coverageShader().uMVMatrix.setMat4(this.mvMatrix);
            this.res.coverageShader().uMcPMatrix.setMat4(this.pMatrix);
            Optional<Integer> depthId = DistantHorizonsCompat.instance().getDepthTextureId();
            RenderSystem.activeTexture((int)33990);
            if (depthId.isPresent()) {
                Matrix4f dhProjectionMatrix = DistantHorizonsCompat.instance().getProjectionMatrix();
                RenderSystem.bindTexture((int)depthId.get());
                this.res.coverageShader().uDhPMatrix.setMat4(dhProjectionMatrix);
            } else {
                RenderSystem.bindTexture((int)0);
                this.res.coverageShader().uDhPMatrix.setMat4(DistantHorizonsCompat.NOOP_MATRIX);
            }
        }
        RenderSystem.activeTexture((int)33989);
        this.client.m_91097_().m_118506_(Resources.NOISE_TEXTURE).m_117966_();
        this.res.generator().bind();
        if (Main.glCompat.useBaseInstanceFallback()) {
            this.res.generator().buffer().bindDrawBuffer();
        }
        this.setFrustumTo(this.tempFrustum, frustum);
        Frustum frustumAtOrigin = this.tempFrustum;
        frustumAtOrigin.m_113002_(frustumPos.x - this.res.generator().originX(), frustumPos.y, frustumPos.z - this.res.generator().originZ());
        Debug.clearFrustumCulledBoxed();
        if (!this.res.generator().canRender()) {
            RenderSystem.enableCull();
            return;
        }
        boolean frustumCulling = config.useFrustumCulling;
        if (IrisCompat.instance().isFrustumCullingDisabled() || config.preset().worldCurvatureSize != 0) {
            frustumCulling = false;
        }
        if (frustumCulling) {
            this.drawCloudsWithFrustumCulling(frustumAtOrigin, config);
        } else {
            this.drawCloudsWithoutFrustumCulling();
        }
        GL32.glDisable((int)34383);
        RenderSystem.enableCull();
    }

    private void drawCloudsWithFrustumCulling(Frustum frustumAtOrigin, Config config) {
        int runStart = -1;
        int runCount = 0;
        for (ChunkedGenerator.ChunkIndex chunk : this.res.generator().chunks()) {
            AABB bounds = chunk.bounds(this.cloudsHeight, config.sizeXZ, config.sizeY);
            if (!frustumAtOrigin.m_113029_(bounds)) {
                Debug.addFrustumCulledBox(bounds, false);
                if (runCount != 0) {
                    if (Main.glCompat.useBaseInstanceFallback()) {
                        this.res.generator().buffer().setVAPointerToInstance(runStart);
                    }
                    Main.glCompat.drawArraysInstancedBaseInstanceFallback(5, 0, this.res.generator().instanceVertexCount(), runCount, runStart);
                }
                runStart = -1;
                runCount = 0;
                continue;
            }
            Debug.addFrustumCulledBox(bounds, true);
            if (runStart == -1) {
                runStart = chunk.start();
            }
            runCount += chunk.count();
        }
        if (runCount != 0) {
            if (Main.glCompat.useBaseInstanceFallback()) {
                this.res.generator().buffer().setVAPointerToInstance(runStart);
            }
            Main.glCompat.drawArraysInstancedBaseInstanceFallback(5, 0, this.res.generator().instanceVertexCount(), runCount, runStart);
        }
    }

    private void drawCloudsWithoutFrustumCulling() {
        List<ChunkedGenerator.ChunkIndex> chunks = this.res.generator().chunks();
        if (chunks.isEmpty()) {
            return;
        }
        ChunkedGenerator.ChunkIndex first = chunks.get(0);
        ChunkedGenerator.ChunkIndex last = chunks.get(chunks.size() - 1);
        int start = first.start();
        int count = last.start() + last.count();
        if (Main.glCompat.useBaseInstanceFallback()) {
            this.res.generator().buffer().setVAPointerToInstance(start);
        }
        Main.glCompat.drawArraysInstancedBaseInstanceFallback(5, 0, this.res.generator().instanceVertexCount(), count, start);
    }

    private void drawShading(Vector3d cam, float tickDelta) {
        Config config = Main.getConfig();
        RenderSystem.depthFunc((int)515);
        if (!Main.glCompat.useDepthWriteFallback()) {
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
        } else {
            RenderSystem.disableDepthTest();
        }
        RenderSystem.enableBlend();
        RenderSystem.blendEquation((int)32774);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        GL32.glColorMaski((int)0, (boolean)true, (boolean)true, (boolean)true, (boolean)true);
        if (!Main.glCompat.useStencilTextureFallback()) {
            GL32.glDisable((int)2960);
        }
        RenderSystem.activeTexture((int)33985);
        if (Main.glCompat.useDepthWriteFallback()) {
            RenderSystem.bindTexture((int)0);
        } else {
            RenderSystem.bindTexture((int)this.res.oitCoverageDepthTexture());
        }
        RenderSystem.activeTexture((int)33986);
        RenderSystem.bindTexture((int)this.res.oitDataTexture());
        RenderSystem.activeTexture((int)33987);
        RenderSystem.bindTexture((int)this.res.oitCoverageTexture());
        RenderSystem.activeTexture((int)33988);
        this.client.m_91097_().m_118506_(Resources.LIGHTING_TEXTURE).m_117966_();
        float effectLuma = this.getEffectLuminance(cam, tickDelta);
        long skyTime = this.world.m_8044_() % 24000L;
        float skyAngleRad = this.world.m_46490_(tickDelta);
        float sunPathAngleRad = (float)Math.toRadians(config.preset().sunPathAngle);
        float dayNightFactor = this.interpolateDayNightFactor(skyTime, config.preset().sunriseStartTime, config.preset().sunriseEndTime, config.preset().sunsetStartTime, config.preset().sunsetEndTime);
        float brightness = (1.0f - dayNightFactor) * config.preset().nightBrightness + dayNightFactor * config.preset().dayBrightness;
        float sunAxisY = Mth.m_14031_((float)sunPathAngleRad);
        float sunAxisZ = Mth.m_14089_((float)sunPathAngleRad);
        Vector3f sunDir = this.tempVector.set(1.0f, 0.0f, 0.0f).rotateAxis(skyAngleRad + 1.5707964f, 0.0f, sunAxisY, sunAxisZ);
        float dayTime = this.world.m_46468_() % 24000L;
        float mappedTime = this.mapTimeOfDay(dayTime, config.preset().sunriseStartTime, config.preset().sunriseEndTime, config.preset().sunsetStartTime, config.preset().sunsetEndTime);
        this.res.shadingShader().bind();
        this.res.shadingShader().uVPMatrix.setMat4(this.rotationProjectionMatrix);
        this.res.shadingShader().uSunDirection.setVec4(sunDir.x, sunDir.y, sunDir.z, mappedTime / 24000.0f);
        this.res.shadingShader().uSunAxis.setVec3(0.0f, sunAxisY, sunAxisZ);
        this.res.shadingShader().uOpacity.setVec3(config.preset().opacity, config.preset().opacityFactor, config.preset().opacityExponent);
        this.res.shadingShader().uColorGrading.setVec4(brightness, 1.0f / config.preset().gamma(), effectLuma, config.preset().saturation);
        this.res.shadingShader().uTint.setVec3(config.preset().tintRed, config.preset().tintGreen, config.preset().tintBlue);
        this.res.shadingShader().uNoiseFactor.setFloat(config.colorVariationFactor);
        GL32.glBindVertexArray((int)this.res.cubeVao());
        GL32.glDrawArrays((int)4, (int)0, (int)Mesh.CUBE_MESH_VERTEX_COUNT);
        if (Main.glCompat.useDepthWriteFallback()) {
            RenderSystem.activeTexture((int)33990);
            RenderSystem.bindTexture((int)this.res.oitCoverageDepthTexture());
            GL32.glTexParameteri((int)3553, (int)Main.glCompat.GL_DEPTH_STENCIL_TEXTURE_MODE, (int)6402);
            this.res.depthShader().bind();
            GL32.glDrawArrays((int)4, (int)0, (int)6);
            GL32.glTexParameteri((int)3553, (int)Main.glCompat.GL_DEPTH_STENCIL_TEXTURE_MODE, (int)6401);
        }
    }

    private Config getGeneratorConfig() {
        Config config = this.res.generator().config();
        if (config != null) {
            return config;
        }
        return Main.getConfig();
    }

    private void setFrustumTo(Frustum dst, Frustum src) {
        dst.f_252531_ = src.f_252531_;
        dst.f_252406_.set((Matrix4fc)src.f_252406_);
        dst.f_112996_ = src.f_112996_;
        dst.f_112997_ = src.f_112997_;
        dst.f_112998_ = src.f_112998_;
        dst.f_194438_ = src.f_194438_;
    }

    private float getEffectLuminance(Vector3d cam, float tickDelta) {
        FogRenderer.m_109036_();
        float[] fogRgb = RenderSystem.getShaderFogColor();
        Vec3 fogColor = new Vec3((double)fogRgb[0], (double)fogRgb[1], (double)fogRgb[2]);
        Vec3 skyColor = this.world.m_171660_(new Vec3(cam.x, cam.y, cam.z), tickDelta);
        Vec3 cloudsColor = this.world.m_104808_(tickDelta);
        Vec3 color = new Vec3((cloudsColor.f_82479_ * 2.0 + skyColor.f_82479_ * 1.5786 + fogColor.f_82479_ * 1.2458) / 4.0, (cloudsColor.f_82480_ * 2.0 + skyColor.f_82480_ * 1.5786 + fogColor.f_82480_ * 1.2458) / 4.0, (cloudsColor.f_82481_ * 2.0 + skyColor.f_82481_ * 1.5786 + fogColor.f_82481_ * 1.2458) / 4.0);
        double luma = color.f_82479_ * 0.299 + color.f_82480_ * 0.587 + color.f_82481_ * 0.114;
        return (float)Mth.m_14008_((double)(luma * 0.95 + 0.05), (double)0.0, (double)1.0);
    }

    private float getTrueRainGradient(float tickDelta) {
        if (HeadInTheCloudsCompat.IS_LOADED) {
            return ((WorldDuck)this.world).betterclouds$getOriginalRainGradient(tickDelta);
        }
        return this.world.m_46722_(tickDelta);
    }

    private float getTrueThunderGradient(float tickDelta) {
        if (HeadInTheCloudsCompat.IS_LOADED) {
            return ((WorldDuck)this.world).betterclouds$getOriginalThunderGradient(tickDelta);
        }
        return this.world.m_46661_(tickDelta);
    }

    private float interpolateDayNightFactor(float time, float riseStart, float riseEnd, float setStart, float setEnd) {
        if (time <= 6000.0f || time > 18000.0f) {
            if (time > 18000.0f) {
                time -= 24000.0f;
            }
            return Renderer.smoothstep(time, riseStart, riseEnd);
        }
        return 1.0f - Renderer.smoothstep(time, setStart, setEnd);
    }

    private float mapTimeOfDay(float time, float riseStart, float riseEnd, float setStart, float setEnd) {
        if (time <= 6000.0f || time > 18000.0f) {
            if (time > 18000.0f) {
                time -= 24000.0f;
            }
            time = time < riseStart ? Renderer.map(time, -6000.0f, riseStart, -6000.0f, -785.0f) : (time > riseEnd ? Renderer.map(time, riseEnd, 6000.0f, 1163.0f, 6000.0f) : Renderer.map(time, riseStart, riseEnd, -785.0f, 1163.0f));
        } else {
            time = time < setStart ? Renderer.map(time, 6000.0f, setStart, 6000.0f, 10837.0f) : (time > setEnd ? Renderer.map(time, setEnd, 18000.0f, 12785.0f, 18000.0f) : Renderer.map(time, setStart, setEnd, 10837.0f, 12785.0f));
        }
        return time;
    }

    private static float map(float x, float fromMin, float fromMax, float toMin, float toMax) {
        float f = (x - fromMin) / (fromMax - fromMin);
        return f * (toMax - toMin) + toMin;
    }

    private static float smoothstep(float x, float e0, float e1) {
        x = Mth.m_14036_((float)((x - e0) / (e1 - e0)), (float)0.0f, (float)1.0f);
        return x * x * (3.0f - 2.0f * x);
    }

    @Override
    public void close() {
        this.res.close();
    }

    public static enum PrepareResult {
        RENDER,
        NO_RENDER,
        FALLBACK;

    }
}

