/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.gui;

import com.google.common.collect.ImmutableSet;
import com.qendolin.betterclouds.gui.CustomActionController;
import dev.isxander.yacl3.api.Binding;
import dev.isxander.yacl3.api.ButtonOption;
import dev.isxander.yacl3.api.Controller;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionFlag;
import dev.isxander.yacl3.gui.YACLScreen;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;

public class CustomButtonOption
implements ButtonOption {
    private final Supplier<Component> name;
    private final OptionDescription description;
    private final BiConsumer<YACLScreen, ButtonOption> action;
    private boolean available;
    private final Controller<BiConsumer<YACLScreen, ButtonOption>> controller;
    private final Binding<BiConsumer<YACLScreen, ButtonOption>> binding;

    public CustomButtonOption(@NotNull Supplier<Component> name, @NotNull OptionDescription description, @NotNull BiConsumer<YACLScreen, ButtonOption> action, boolean available) {
        this.name = name;
        this.description = description;
        this.action = action;
        this.available = available;
        this.controller = new CustomActionController(this);
        this.binding = new EmptyBinderImpl();
    }

    public static Builder createBuilder() {
        return new Builder();
    }

    @NotNull
    public Component name() {
        return this.name.get();
    }

    @NotNull
    public Component tooltip() {
        return this.description().text();
    }

    @NotNull
    public OptionDescription description() {
        return this.description;
    }

    public BiConsumer<YACLScreen, ButtonOption> action() {
        return this.action;
    }

    public boolean available() {
        return this.available;
    }

    public void setAvailable(boolean available) {
        this.available = available;
    }

    @NotNull
    public Controller<BiConsumer<YACLScreen, ButtonOption>> controller() {
        return this.controller;
    }

    @NotNull
    public Binding<BiConsumer<YACLScreen, ButtonOption>> binding() {
        return this.binding;
    }

    @NotNull
    public ImmutableSet<OptionFlag> flags() {
        return ImmutableSet.of();
    }

    public boolean changed() {
        return false;
    }

    @NotNull
    public BiConsumer<YACLScreen, ButtonOption> pendingValue() {
        throw new UnsupportedOperationException();
    }

    public void requestSet(BiConsumer<YACLScreen, ButtonOption> value) {
        throw new UnsupportedOperationException();
    }

    public boolean applyValue() {
        return false;
    }

    public void forgetPendingValue() {
    }

    public void requestSetDefault() {
    }

    public boolean isPendingValueDefault() {
        throw new UnsupportedOperationException();
    }

    public void addListener(BiConsumer<Option<BiConsumer<YACLScreen, ButtonOption>>, BiConsumer<YACLScreen, ButtonOption>> changedListener) {
    }

    protected static class EmptyBinderImpl
    implements Binding<BiConsumer<YACLScreen, ButtonOption>> {
        protected EmptyBinderImpl() {
        }

        public BiConsumer<YACLScreen, ButtonOption> getValue() {
            throw new UnsupportedOperationException();
        }

        public void setValue(BiConsumer<YACLScreen, ButtonOption> value) {
        }

        public BiConsumer<YACLScreen, ButtonOption> defaultValue() {
            throw new UnsupportedOperationException();
        }
    }

    public static final class Builder {
        private Supplier<Component> name;
        private OptionDescription description = OptionDescription.EMPTY;
        private boolean available = true;
        private BiConsumer<YACLScreen, ButtonOption> action;

        public Builder name(@NotNull Supplier<Component> name) {
            Validate.notNull(name, (String)"`name` cannot be null", (Object[])new Object[0]);
            this.name = name;
            return this;
        }

        public Builder description(@NotNull OptionDescription description) {
            Validate.notNull((Object)description, (String)"`description` cannot be null", (Object[])new Object[0]);
            this.description = description;
            return this;
        }

        public Builder action(@NotNull BiConsumer<YACLScreen, ButtonOption> action) {
            Validate.notNull(action, (String)"`action` cannot be null", (Object[])new Object[0]);
            this.action = action;
            return this;
        }

        public Builder available(boolean available) {
            this.available = available;
            return this;
        }

        public ButtonOption build() {
            Validate.notNull(this.name, (String)"`name` must not be null when building `Option`", (Object[])new Object[0]);
            Validate.notNull(this.action, (String)"`action` must not be null when building `Option`", (Object[])new Object[0]);
            return new CustomButtonOption(this.name, this.description, this.action, this.available);
        }
    }
}

