/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.qendolin.betterclouds.Main;
import com.qendolin.betterclouds.clouds.Debug;
import com.qendolin.betterclouds.clouds.Renderer;
import com.qendolin.betterclouds.compat.Telemetry;
import com.qendolin.betterclouds.renderdoc.RenderDoc;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3d;
import org.lwjgl.opengl.GL32;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public abstract class WorldRendererMixin {
    @Unique
    private final Vector3d tempVector = new Vector3d();
    @Unique
    private Renderer cloudRenderer;
    @Shadow
    private Frustum f_172938_;
    @Unique
    private double profTimeAcc;
    @Unique
    private int profFrames;
    @Shadow
    @Nullable
    private Frustum f_109442_;
    @Shadow
    @Final
    private Vector3d f_109444_;
    @Shadow
    @Final
    private Minecraft f_109461_;
    @Shadow
    @Nullable
    private ClientLevel f_109465_;
    @Shadow
    private int f_109477_;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void init(Minecraft client, EntityRenderDispatcher entityRenderDispatcher, BlockEntityRenderDispatcher blockEntityRenderDispatcher, RenderBuffers bufferBuilders, CallbackInfo ci) {
        if (Main.glCompat.isIncompatible()) {
            return;
        }
        this.cloudRenderer = new Renderer(client);
    }

    @Inject(at={@At(value="TAIL")}, method={"reload(Lnet/minecraft/resource/ResourceManager;)V"})
    private void onReload(ResourceManager manager, CallbackInfo ci) {
        if (!Main.initialized()) {
            return;
        }
        if (Main.glCompat.isIncompatible()) {
            return;
        }
        try {
            if (this.cloudRenderer != null) {
                this.cloudRenderer.reload(manager);
            }
        }
        catch (Exception e) {
            Telemetry.INSTANCE.sendUnhandledException(e);
            throw e;
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"setWorld"})
    private void onSetWorld(ClientLevel world, CallbackInfo ci) {
        if (this.cloudRenderer != null) {
            this.cloudRenderer.setWorld(world);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"renderClouds(Lnet/minecraft/client/util/math/MatrixStack;Lorg/joml/Matrix4f;FDDD)V"}, cancellable=true)
    private void renderClouds(PoseStack matrices, Matrix4f projMat, float tickDelta, double camX, double camY, double camZ, CallbackInfo ci) {
        Matrix4f viewMat = matrices.m_85850_().m_252922_();
        if (this.cloudRenderer == null) {
            return;
        }
        if (Main.glCompat.isIncompatible()) {
            return;
        }
        if (this.f_109465_ == null) {
            return;
        }
        if (!Main.getConfig().enabledDimensions.contains(this.f_109465_.m_204156_().m_203543_().orElse(null))) {
            return;
        }
        if (!Main.getConfig().enabled) {
            return;
        }
        this.f_109461_.m_91307_().m_6180_("betterclouds");
        Main.glCompat.pushDebugGroupDev("Better Clouds");
        Vector3d cam = this.tempVector.set(camX, camY, camZ);
        Frustum frustum = this.f_172938_;
        Vector3d frustumPos = cam;
        if (this.f_109442_ != null) {
            frustum = this.f_109442_;
            frustum.m_113002_(this.f_109444_.x, this.f_109444_.y, this.f_109444_.z);
            frustumPos = this.f_109444_;
        }
        if (Main.isProfilingEnabled()) {
            GL32.glFinish();
        }
        long startTime = System.nanoTime();
        int ticks = this.f_109477_;
        if (Debug.animationPause >= 0) {
            if (Debug.animationPause == 0) {
                Debug.animationPause = ticks;
            } else {
                ticks = Debug.animationPause;
            }
            tickDelta = 0.0f;
        }
        try {
            Renderer.PrepareResult prepareResult = this.cloudRenderer.prepare(viewMat, projMat, ticks, tickDelta, cam);
            if (RenderDoc.isFrameCapturing()) {
                Main.glCompat.debugMessage("renderer prepare returned " + prepareResult.name());
            }
            if (prepareResult == Renderer.PrepareResult.RENDER) {
                ci.cancel();
                this.cloudRenderer.render(ticks, tickDelta, cam, frustumPos, frustum);
            } else if (prepareResult == Renderer.PrepareResult.NO_RENDER) {
                ci.cancel();
            }
        }
        catch (Exception e) {
            Telemetry.INSTANCE.sendUnhandledException(e);
            throw e;
        }
        if (Main.isProfilingEnabled()) {
            GL32.glFinish();
            this.profTimeAcc += (double)(System.nanoTime() - startTime) / 1000000.0;
            ++this.profFrames;
            if (this.profFrames >= Debug.profileInterval) {
                Main.debugChatMessage("profiling.cpuTimes", this.profTimeAcc / (double)this.profFrames);
                this.profFrames = 0;
                this.profTimeAcc = 0.0;
            }
        }
        this.f_109461_.m_91307_().m_7238_();
        Main.glCompat.popDebugGroupDev();
    }

    @Inject(at={@At(value="HEAD")}, method={"close"})
    private void close(CallbackInfo ci) {
        if (this.cloudRenderer != null) {
            this.cloudRenderer.close();
        }
    }
}

