/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_furniture.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.valhelsia.valhelsia_core.api.common.registry.helper.block.BlockRegistryEntry;
import net.valhelsia.valhelsia_furniture.common.block.AbstractCurtainBlock;
import net.valhelsia.valhelsia_furniture.common.block.OpenCurtainBlock;
import net.valhelsia.valhelsia_furniture.common.block.properties.ClosedCurtainPart;
import net.valhelsia.valhelsia_furniture.common.block.properties.ModBlockStateProperties;
import net.valhelsia.valhelsia_furniture.common.block.properties.OpenCurtainPart;
import net.valhelsia.valhelsia_furniture.core.registry.ModBlocks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClosedCurtainBlock
extends AbstractCurtainBlock<ClosedCurtainPart> {
    public static EnumProperty<ClosedCurtainPart> PART = ModBlockStateProperties.CLOSED_CURTAIN_PART;

    public ClosedCurtainBlock(DyeColor color, BlockBehaviour.Properties properties) {
        super(color, properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue(PART, (Comparable)((Object)ClosedCurtainPart.SINGLE))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    @Override
    protected void updateOpen(BlockState state, Level level, BlockPos pos) {
        Direction base = (Direction)state.getValue((Property)FACING);
        Direction left = base.getClockWise();
        Direction right = base.getCounterClockWise();
        BlockPos topPos = this.getTopBlock((LevelAccessor)level, pos);
        int length = this.getCurtainLength((LevelAccessor)level, topPos);
        boolean leftConnected = this.isConnected((LevelAccessor)level, state, topPos, left, length);
        boolean rightConnected = this.isConnected((LevelAccessor)level, state, topPos, right, length);
        this.openRow(level, topPos, length, leftConnected, rightConnected);
        if (leftConnected) {
            this.openRows(level, state, topPos.mutable(), left, base, length);
        }
        if (rightConnected) {
            this.openRows(level, state, topPos.mutable(), right, base, length);
        }
    }

    @Override
    protected ClosedCurtainPart getPart(BlockState state) {
        return (ClosedCurtainPart)((Object)state.getValue(PART));
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        ClosedCurtainPart part = (ClosedCurtainPart)((Object)state.getValue(PART));
        return part == ClosedCurtainPart.SINGLE || part == ClosedCurtainPart.TOP ? (VoxelShape)TOP_SHAPES.get(facing) : (VoxelShape)SHAPES.get(facing);
    }

    @NotNull
    public VoxelShape getCollisionShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        ClosedCurtainPart part = (ClosedCurtainPart)((Object)state.getValue(PART));
        return part == ClosedCurtainPart.SINGLE || part == ClosedCurtainPart.TOP ? (VoxelShape)BRACKET_SHAPES.get(state.getValue((Property)FACING)) : Shapes.empty();
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockPos above = pos.above();
        BlockPos below = pos.below();
        BlockState aboveState = level.getBlockState(above);
        BlockState belowState = level.getBlockState(below);
        Direction facing = context.getHorizontalDirection().getOpposite();
        boolean powered = level.hasNeighborSignal(pos) || level.hasNeighborSignal(pos.above());
        BlockState state = powered ? (BlockState)this.getOpenBlock().defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.valueOf(true)) : this.defaultBlockState();
        state = (BlockState)((BlockState)state.setValue(PART, (Comparable)((Object)this.connect(aboveState, belowState, facing)))).setValue((Property)FACING, (Comparable)facing);
        if (!powered) {
            this.updateAboveAndBelow(level, state, above, below, facing);
        }
        return state;
    }

    @Override
    protected void openRow(Level level, BlockPos topPos, int length, boolean leftConnected, boolean rightConnected) {
        OpenCurtainBlock block = this.getOpenBlock();
        for (int i = 0; i < length; ++i) {
            BlockState state = level.getBlockState(topPos.below(i));
            ClosedCurtainPart part = (ClosedCurtainPart)((Object)state.getValue(PART));
            OpenCurtainPart newPart = OpenCurtainPart.SINGLE;
            if (length == 1) {
                if (leftConnected && rightConnected) {
                    newPart = OpenCurtainPart.TOP;
                }
                if (leftConnected && !rightConnected) {
                    newPart = OpenCurtainPart.RIGHT;
                }
                if (rightConnected && !leftConnected) {
                    newPart = OpenCurtainPart.LEFT;
                }
            } else {
                if (leftConnected && rightConnected && (part == ClosedCurtainPart.MIDDLE || part == ClosedCurtainPart.BOTTOM)) {
                    newPart = OpenCurtainPart.MIDDLE;
                }
                if (part == ClosedCurtainPart.TOP) {
                    newPart = leftConnected && rightConnected ? OpenCurtainPart.TOP : (leftConnected ? OpenCurtainPart.RIGHT_SIDE_TOP : (rightConnected ? OpenCurtainPart.LEFT_SIDE_TOP : OpenCurtainPart.SINGLE_TOP));
                } else if (part == ClosedCurtainPart.MIDDLE) {
                    if (leftConnected && !rightConnected) {
                        newPart = OpenCurtainPart.RIGHT_SIDE_MIDDLE;
                    } else if (!leftConnected && rightConnected) {
                        newPart = OpenCurtainPart.LEFT_SIDE_MIDDLE;
                    } else if (!leftConnected) {
                        newPart = OpenCurtainPart.SINGLE_MIDDLE;
                    }
                } else if (part == ClosedCurtainPart.BOTTOM) {
                    if (leftConnected && !rightConnected) {
                        newPart = OpenCurtainPart.RIGHT_SIDE_BOTTOM;
                    } else if (!leftConnected && rightConnected) {
                        newPart = OpenCurtainPart.LEFT_SIDE_BOTTOM;
                    } else if (!leftConnected) {
                        newPart = OpenCurtainPart.SINGLE_BOTTOM;
                    }
                }
            }
            level.setBlockAndUpdate(topPos.below(i), (BlockState)((BlockState)((BlockState)block.defaultBlockState().setValue(OpenCurtainBlock.PART, (Comparable)((Object)newPart))).setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)))).setValue((Property)POWERED, (Comparable)((Boolean)state.getValue((Property)POWERED))));
        }
    }

    @Override
    protected boolean isOpen() {
        return false;
    }

    @Override
    protected ClosedCurtainPart connect(BlockState aState, BlockState bState, Direction facing) {
        return ClosedCurtainPart.getTypeForConnections(aState.getBlock() instanceof ClosedCurtainBlock && aState.getValue((Property)FACING) == facing, bState.getBlock() instanceof ClosedCurtainBlock && bState.getValue((Property)FACING) == facing);
    }

    public OpenCurtainBlock getOpenBlock() {
        return (OpenCurtainBlock)((Object)((BlockRegistryEntry)ModBlocks.OPEN_CURTAINS.get((Object)this.getColor())).get());
    }

    private void updateAboveAndBelow(Level level, BlockState state, BlockPos above, BlockPos below, Direction facing) {
        BlockState aboveState = level.getBlockState(above);
        BlockState belowState = level.getBlockState(below);
        if (aboveState.is((Block)this)) {
            level.setBlockAndUpdate(above, (BlockState)aboveState.setValue(PART, (Comparable)((Object)this.connect(level.getBlockState(above.above()), state, facing))));
        }
        if (belowState.is((Block)this)) {
            level.setBlockAndUpdate(below, (BlockState)belowState.setValue(PART, (Comparable)((Object)this.connect(state, level.getBlockState(below.below()), facing))));
        }
    }

    public void onRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        if (!(newState.getBlock() instanceof AbstractCurtainBlock)) {
            this.updateAboveAndBelow(level, newState, pos.above(), pos.below(), (Direction)state.getValue((Property)FACING));
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{PART, POWERED, FACING});
    }
}

