/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_furniture.common.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.valhelsia.valhelsia_core.api.common.helper.VoxelShapeHelper;
import net.valhelsia.valhelsia_furniture.common.block.properties.ModBlockStateProperties;
import net.valhelsia.valhelsia_furniture.datagen.models.ModTextureSlots;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeskBlock
extends Block
implements SimpleWaterloggedBlock {
    private static final String TEXTURE_PATH = "block/desk/";
    public static final Map<String, List<TextureSlot>> VARIANT_TEXTURES = ImmutableMap.builder().put((Object)"single", (Object)ImmutableList.of((Object)ModTextureSlots.TOP, (Object)ModTextureSlots.TOP_MIDDLE, (Object)ModTextureSlots.FRONT, (Object)ModTextureSlots.SIDE)).put((Object)"center", (Object)ImmutableList.of((Object)ModTextureSlots.TOP_SIDE, (Object)ModTextureSlots.TOP_MIDDLE, (Object)ModTextureSlots.FRONT, (Object)ModTextureSlots.SIDE, (Object)ModTextureSlots.MIDDLE)).put((Object)"left_or_right", (Object)ImmutableList.of((Object)ModTextureSlots.TOP, (Object)ModTextureSlots.TOP_SIDE, (Object)ModTextureSlots.TOP_MIDDLE, (Object)ModTextureSlots.FRONT, (Object)ModTextureSlots.SIDE, (Object)ModTextureSlots.MIDDLE)).build();
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty LEFT = ModBlockStateProperties.LEFT;
    public static final BooleanProperty RIGHT = ModBlockStateProperties.RIGHT;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private final Map<BlockState, VoxelShape> shapesCache;
    private static final VoxelShape TOP_SHAPE = Block.box((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final Map<Direction, VoxelShape> TWO_LEGS_SHAPES = VoxelShapeHelper.getHorizontalRotatedShapes((VoxelShape)Shapes.or((VoxelShape)TOP_SHAPE, (VoxelShape[])new VoxelShape[]{Block.box((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)12.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)12.0, (double)15.0)}));
    protected static final VoxelShape SHAPE = Shapes.or((VoxelShape)TOP_SHAPE, (VoxelShape[])new VoxelShape[]{Block.box((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)12.0, (double)4.0), Block.box((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)12.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)12.0, (double)15.0), Block.box((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)12.0, (double)4.0)});
    private static final Map<Direction, VoxelShape> CONNECT_SHAPES = VoxelShapeHelper.getHorizontalRotatedShapes((VoxelShape)Block.box((double)4.0, (double)4.0, (double)1.0, (double)12.0, (double)12.0, (double)4.0));
    private static final Map<Direction, VoxelShape> FULL_CONNECT_SHAPES = VoxelShapeHelper.getHorizontalRotatedShapes((VoxelShape)Block.box((double)0.0, (double)4.0, (double)1.0, (double)16.0, (double)12.0, (double)4.0));
    private static final Map<Direction, VoxelShape> LEFT_CONNECT_SHAPES = VoxelShapeHelper.getHorizontalRotatedShapes((VoxelShape)Block.box((double)0.0, (double)4.0, (double)1.0, (double)12.0, (double)12.0, (double)4.0));
    private static final Map<Direction, VoxelShape> RIGHT_CONNECT_SHAPES = VoxelShapeHelper.getHorizontalRotatedShapes((VoxelShape)Block.box((double)4.0, (double)4.0, (double)1.0, (double)16.0, (double)12.0, (double)4.0));
    private final WoodType woodType;
    private final TagKey<Block> tag;

    public DeskBlock(WoodType woodType, TagKey<Block> tag, BlockBehaviour.Properties properties) {
        super(properties);
        this.woodType = woodType;
        this.tag = tag;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)LEFT, (Comparable)Boolean.valueOf(false))).setValue((Property)RIGHT, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.shapesCache = this.getShapeForEachState(this::calculateShape);
    }

    private VoxelShape calculateShape(BlockState state) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        boolean left = (Boolean)state.getValue((Property)LEFT);
        boolean right = (Boolean)state.getValue((Property)RIGHT);
        if (left && right) {
            return Shapes.or((VoxelShape)TOP_SHAPE, (VoxelShape)FULL_CONNECT_SHAPES.get(facing.getOpposite()));
        }
        if (left) {
            return Shapes.or((VoxelShape)TWO_LEGS_SHAPES.get(facing.getClockWise()), (VoxelShape[])new VoxelShape[]{LEFT_CONNECT_SHAPES.get(facing.getOpposite()), CONNECT_SHAPES.get(facing.getClockWise().getOpposite())});
        }
        if (right) {
            return Shapes.or((VoxelShape)TWO_LEGS_SHAPES.get(facing.getClockWise().getOpposite()), (VoxelShape[])new VoxelShape[]{RIGHT_CONNECT_SHAPES.get(facing.getOpposite()), CONNECT_SHAPES.get(facing.getClockWise())});
        }
        return Shapes.or((VoxelShape)SHAPE, (VoxelShape[])new VoxelShape[]{CONNECT_SHAPES.get(facing.getOpposite()), CONNECT_SHAPES.get(facing.getClockWise().getOpposite()), CONNECT_SHAPES.get(facing.getClockWise())});
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return this.shapesCache.get(state);
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        boolean right;
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Direction facing = context.getHorizontalDirection().getOpposite();
        boolean flag = level.getFluidState(pos).getType() == Fluids.WATER;
        BlockState leftState = level.getBlockState(pos.relative(facing.getClockWise()));
        BlockState secondLefState = level.getBlockState(pos.relative(facing.getClockWise(), 2));
        BlockState rightState = level.getBlockState(pos.relative(facing.getCounterClockWise()));
        BlockState secondRightState = level.getBlockState(pos.relative(facing.getCounterClockWise(), 2));
        boolean left = this.hasSameFacing(leftState, facing) && (!secondLefState.is(this.tag) || secondLefState.getValue((Property)FACING) != facing || !this.isCenterPart(secondLefState));
        boolean bl = right = this.hasSameFacing(rightState, facing) && (!secondRightState.is(this.tag) || secondRightState.getValue((Property)FACING) != facing || !this.isCenterPart(secondRightState));
        if (left && right) {
            if (this.hasSameFacing(secondRightState, facing) && ((Boolean)secondRightState.getValue((Property)LEFT)).booleanValue()) {
                right = false;
            } else if (this.hasSameFacing(secondLefState, facing) && ((Boolean)secondLefState.getValue((Property)RIGHT)).booleanValue()) {
                left = false;
            }
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing)).setValue((Property)LEFT, (Comparable)Boolean.valueOf(left))).setValue((Property)RIGHT, (Comparable)Boolean.valueOf(right))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public boolean isCenterPart(BlockState state) {
        return state.is(this.tag) && (Boolean)state.getValue((Property)LEFT) != false && (Boolean)state.getValue((Property)RIGHT) != false;
    }

    public boolean hasSameFacing(BlockState state, Direction facing) {
        return state.is(this.tag) && state.getValue((Property)FACING) == facing;
    }

    @NotNull
    public BlockState updateShape(@NotNull BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor level, @NotNull BlockPos currentPos, @NotNull BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        Direction facing = (Direction)state.getValue((Property)FACING);
        boolean flag = this.hasSameFacing(neighborState, facing);
        if (direction == facing.getClockWise()) {
            return (BlockState)state.setValue((Property)LEFT, (Comparable)Boolean.valueOf(flag && (Boolean)neighborState.getValue((Property)RIGHT) != false));
        }
        if (direction == facing.getCounterClockWise()) {
            return (BlockState)state.setValue((Property)RIGHT, (Comparable)Boolean.valueOf(flag && (Boolean)neighborState.getValue((Property)LEFT) != false));
        }
        return super.updateShape(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public WoodType getWoodType() {
        return this.woodType;
    }

    @NotNull
    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, LEFT, RIGHT, WATERLOGGED});
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public boolean useShapeForLightOcclusion(@NotNull BlockState state) {
        return true;
    }
}

