/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_furniture.common.block;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.valhelsia.valhelsia_core.api.common.helper.VoxelShapeHelper;
import net.valhelsia.valhelsia_furniture.common.block.FurnitureBlock;
import net.valhelsia.valhelsia_furniture.common.block.properties.ModBlockStateProperties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableBlock
extends Block
implements SimpleWaterloggedBlock,
FurnitureBlock {
    private static final int MAX_LENGTH = 5;
    public static final BooleanProperty NORTH = BlockStateProperties.NORTH;
    public static final BooleanProperty EAST = BlockStateProperties.EAST;
    public static final BooleanProperty SOUTH = BlockStateProperties.SOUTH;
    public static final BooleanProperty WEST = BlockStateProperties.WEST;
    private static final BooleanProperty ROTATED = ModBlockStateProperties.ROTATED;
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final EnumMap<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = (EnumMap)Util.make(new EnumMap(Direction.class), map -> {
        map.put(Direction.NORTH, NORTH);
        map.put(Direction.EAST, EAST);
        map.put(Direction.SOUTH, SOUTH);
        map.put(Direction.WEST, WEST);
    });
    private static final VoxelShape TOP_SHAPE = Block.box((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final Map<Direction, VoxelShape> TWO_LEGS_SHAPES = VoxelShapeHelper.getHorizontalRotatedShapes((VoxelShape)Shapes.or((VoxelShape)TOP_SHAPE, (VoxelShape[])new VoxelShape[]{Block.box((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)12.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)12.0, (double)15.0)}));
    private static final Map<Direction, VoxelShape> ONE_LEG_SHAPES = VoxelShapeHelper.getHorizontalRotatedShapes((VoxelShape)Shapes.or((VoxelShape)TOP_SHAPE, (VoxelShape)Block.box((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)12.0, (double)15.0)));
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)TOP_SHAPE, (VoxelShape[])new VoxelShape[]{Block.box((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)12.0, (double)4.0), Block.box((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)12.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)12.0, (double)15.0), Block.box((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)12.0, (double)4.0)});
    private final WoodType woodType;

    public TableBlock(WoodType woodType, BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)ROTATED, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.woodType = woodType;
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        ArrayList<Direction> connectedDirections = new ArrayList<Direction>();
        for (Direction direction : Direction.values()) {
            if (direction.getAxis() == Direction.Axis.Y || !((Boolean)state.getValue((Property)PROPERTY_BY_DIRECTION.get(direction))).booleanValue()) continue;
            connectedDirections.add(direction);
        }
        if (connectedDirections.size() >= 3 || connectedDirections.size() == 2 && connectedDirections.get(0) == ((Direction)connectedDirections.get(1)).getOpposite()) {
            return TOP_SHAPE;
        }
        if (connectedDirections.size() == 1) {
            return TWO_LEGS_SHAPES.get(connectedDirections.get(0));
        }
        if (connectedDirections.size() == 2) {
            boolean flag = ((Direction)connectedDirections.get(0)).getClockWise() == connectedDirections.get(1);
            return flag ? ONE_LEG_SHAPES.get(connectedDirections.get(0)) : ONE_LEG_SHAPES.get(connectedDirections.get(1));
        }
        return SHAPE;
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        boolean flag = context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER;
        boolean rotated = context.getHorizontalDirection().getAxis() == Direction.Axis.X;
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)ROTATED, (Comparable)Boolean.valueOf(rotated))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public boolean useShapeForLightOcclusion(@NotNull BlockState state) {
        return true;
    }

    @NotNull
    public BlockState updateShape(@NotNull BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor level, @NotNull BlockPos currentPos, @NotNull BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        if (direction.getAxis() == Direction.Axis.Y) {
            return state;
        }
        BooleanProperty property = PROPERTY_BY_DIRECTION.get(direction);
        BooleanProperty oppositeProperty = PROPERTY_BY_DIRECTION.get(direction.getOpposite());
        if (neighborState.getBlock() instanceof TableBlock) {
            if (((Boolean)neighborState.getValue((Property)oppositeProperty)).booleanValue() && !((Boolean)state.getValue((Property)property)).booleanValue()) {
                return (BlockState)state.setValue((Property)property, (Comparable)Boolean.valueOf(true));
            }
            if (!((Boolean)neighborState.getValue((Property)oppositeProperty)).booleanValue() && ((Boolean)state.getValue((Property)property)).booleanValue()) {
                return (BlockState)state.setValue((Property)property, (Comparable)Boolean.valueOf(false));
            }
        } else if (((Boolean)state.getValue((Property)property)).booleanValue()) {
            return (BlockState)state.setValue((Property)property, (Comparable)Boolean.valueOf(false));
        }
        if (this.isValidTable(neighborState) && !((Boolean)state.getValue((Property)property)).booleanValue()) {
            this.tryConnect(direction, currentPos, level);
        }
        return state;
    }

    @NotNull
    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        for (Direction direction : Direction.values()) {
            if (direction.getAxis() == Direction.Axis.Y || !((Boolean)state.getValue((Property)PROPERTY_BY_DIRECTION.get(direction))).booleanValue()) continue;
            this.trySplit(direction, pos, (LevelAccessor)level);
            break;
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    private void tryConnect(Direction direction, BlockPos pos, LevelAccessor level) {
        BlockState offsetState;
        BlockState state;
        BlockPos.MutableBlockPos mutable;
        int j;
        BlockState state2;
        BlockState state3;
        int tableLength;
        ArrayList<Object> list = new ArrayList<Object>();
        int i = 0;
        for (tableLength = 1; tableLength < 5 && (state3 = level.getBlockState(pos.relative(direction.getOpposite(), tableLength))).getBlock() instanceof TableBlock && ((Boolean)state3.getValue((Property)PROPERTY_BY_DIRECTION.get(direction))).booleanValue(); ++tableLength) {
        }
        int otherTableLength = 1;
        for (int j2 = 2; j2 < 5 && (state2 = level.getBlockState(pos.relative(direction, j2))).getBlock() instanceof TableBlock && ((Boolean)state2.getValue((Property)PROPERTY_BY_DIRECTION.get(direction.getOpposite()))).booleanValue(); ++j2) {
            ++otherTableLength;
        }
        if (tableLength + otherTableLength > 5) {
            return;
        }
        boolean flag = false;
        BlockPos offsetPos = pos.relative(direction);
        if (!this.isSameRotation(level.getBlockState(pos), level.getBlockState(offsetPos))) {
            return;
        }
        list.add(offsetPos);
        if (level.getBlockState(offsetPos).getBlock() instanceof TableBlock) {
            flag = (Boolean)level.getBlockState(offsetPos).getValue((Property)PROPERTY_BY_DIRECTION.get(direction.getClockWise()));
        }
        for (j = 1; j < 5; ++j) {
            mutable = pos.mutable().move(direction.getClockWise(), j);
            state = level.getBlockState((BlockPos)mutable);
            offsetState = level.getBlockState((BlockPos)mutable.move(direction));
            if (!this.isValidTable(state) || this.isValidTable(state) && !((Boolean)state.getValue((Property)PROPERTY_BY_DIRECTION.get(direction.getCounterClockWise()))).booleanValue() || !this.isSameRotation(level.getBlockState(pos), state)) {
                if (!this.isValidTable(offsetState) || !flag) break;
                return;
            }
            if (!this.isValidTable(offsetState) || this.isValidTable(offsetState) && !((Boolean)offsetState.getValue((Property)PROPERTY_BY_DIRECTION.get(direction.getCounterClockWise()))).booleanValue() || !this.isSameRotation(level.getBlockState(pos), offsetState)) {
                return;
            }
            flag = this.isValidTable(offsetState) ? (Boolean)offsetState.getValue((Property)PROPERTY_BY_DIRECTION.get(direction.getClockWise())) : false;
            list.add(mutable);
            ++i;
        }
        flag = level.getBlockState(offsetPos).getBlock() instanceof TableBlock ? (Boolean)level.getBlockState(offsetPos).getValue((Property)PROPERTY_BY_DIRECTION.get(direction.getCounterClockWise())) : false;
        for (j = 1; j < 5; ++j) {
            mutable = pos.mutable().move(direction.getCounterClockWise(), j);
            state = level.getBlockState((BlockPos)mutable);
            offsetState = level.getBlockState((BlockPos)mutable.move(direction));
            if (!this.isValidTable(state) || this.isValidTable(state) && !((Boolean)state.getValue((Property)PROPERTY_BY_DIRECTION.get(direction.getClockWise()))).booleanValue() || !this.isSameRotation(level.getBlockState(pos), state)) {
                if (!this.isValidTable(offsetState) || !flag) break;
                return;
            }
            if (!this.isValidTable(offsetState) || this.isValidTable(offsetState) && !((Boolean)offsetState.getValue((Property)PROPERTY_BY_DIRECTION.get(direction.getClockWise()))).booleanValue() || !this.isSameRotation(level.getBlockState(pos), offsetState)) {
                return;
            }
            flag = this.isValidTable(offsetState) ? (Boolean)offsetState.getValue((Property)PROPERTY_BY_DIRECTION.get(direction.getCounterClockWise())) : false;
            list.add(mutable);
            ++i;
        }
        if (i >= 5) {
            return;
        }
        list.forEach(tablePos -> level.setBlock(tablePos, (BlockState)level.getBlockState(tablePos).setValue((Property)PROPERTY_BY_DIRECTION.get(direction.getOpposite()), (Comparable)Boolean.valueOf(true)), 3));
    }

    private void trySplit(Direction direction, BlockPos pos, LevelAccessor level) {
        BlockPos.MutableBlockPos mutable;
        BlockState offsetState;
        int j;
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        for (j = 1; j < 5 && this.isValidTable(offsetState = level.getBlockState((BlockPos)(mutable = pos.mutable().move(direction.getClockWise(), j)))) && ((Boolean)offsetState.getValue((Property)PROPERTY_BY_DIRECTION.get(direction.getCounterClockWise()))).booleanValue(); ++j) {
            if (!((Boolean)offsetState.getValue((Property)PROPERTY_BY_DIRECTION.get(direction))).booleanValue()) continue;
            list.add(mutable.immutable());
        }
        for (j = 1; j < 5 && this.isValidTable(offsetState = level.getBlockState((BlockPos)(mutable = pos.mutable().move(direction.getCounterClockWise(), j)))) && ((Boolean)offsetState.getValue((Property)PROPERTY_BY_DIRECTION.get(direction.getClockWise()))).booleanValue(); ++j) {
            if (!((Boolean)offsetState.getValue((Property)PROPERTY_BY_DIRECTION.get(direction))).booleanValue()) continue;
            list.add(mutable.immutable());
        }
        list.forEach(tablePos -> {
            BlockState state = level.getBlockState(tablePos);
            boolean rotated = (Boolean)state.getValue((Property)ROTATED);
            level.setBlock(tablePos, Blocks.AIR.defaultBlockState(), 3);
            level.setBlock(tablePos, (BlockState)state.getBlock().defaultBlockState().setValue((Property)ROTATED, (Comparable)Boolean.valueOf(rotated)), 3);
        });
    }

    public boolean isValidTable(BlockState state) {
        TableBlock table;
        Block block = state.getBlock();
        return block instanceof TableBlock && (table = (TableBlock)block).getWoodType() == this.getWoodType();
    }

    public boolean isSameRotation(BlockState state1, BlockState state2) {
        if (!this.isValidTable(state1) || !this.isValidTable(state2)) {
            return false;
        }
        return state1.getValue((Property)ROTATED) == state2.getValue((Property)ROTATED);
    }

    public WoodType getWoodType() {
        return this.woodType;
    }

    @NotNull
    public BlockState rotate(@NotNull BlockState state, @NotNull Rotation rotation) {
        ArrayList<Direction> directions = new ArrayList<Direction>();
        for (Map.Entry<Direction, BooleanProperty> entry : PROPERTY_BY_DIRECTION.entrySet()) {
            if (((Boolean)state.getValue((Property)entry.getValue())).booleanValue()) {
                directions.add(rotation.rotate(entry.getKey()));
            }
            state = (BlockState)state.setValue((Property)entry.getValue(), (Comparable)Boolean.valueOf(false));
        }
        for (Direction direction : directions) {
            state = (BlockState)state.setValue((Property)PROPERTY_BY_DIRECTION.get(direction), (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    @NotNull
    public BlockState mirror(@NotNull BlockState state, @NotNull Mirror mirror) {
        ArrayList<Direction> directions = new ArrayList<Direction>();
        for (Map.Entry<Direction, BooleanProperty> entry : PROPERTY_BY_DIRECTION.entrySet()) {
            if (((Boolean)state.getValue((Property)entry.getValue())).booleanValue()) {
                directions.add(mirror.mirror(entry.getKey()));
            }
            state = (BlockState)state.setValue((Property)entry.getValue(), (Comparable)Boolean.valueOf(false));
        }
        for (Direction direction : directions) {
            state = (BlockState)state.setValue((Property)PROPERTY_BY_DIRECTION.get(direction), (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{NORTH, EAST, SOUTH, WEST, ROTATED, WATERLOGGED});
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @Override
    public FurnitureBlock.Type getType() {
        return FurnitureBlock.Type.TABLE;
    }
}

