/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_furniture.forge.data;

import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;
import net.valhelsia.valhelsia_core.api.common.registry.helper.block.BlockEntrySet;
import net.valhelsia.valhelsia_core.datagen.recipes.RecipeSubProvider;
import net.valhelsia.valhelsia_core.datagen.recipes.ValhelsiaRecipeProvider;
import net.valhelsia.valhelsia_furniture.common.block.ChairBlock;
import net.valhelsia.valhelsia_furniture.common.block.ClosedCurtainBlock;
import net.valhelsia.valhelsia_furniture.common.block.DeskBlock;
import net.valhelsia.valhelsia_furniture.common.block.DeskDrawerBlock;
import net.valhelsia.valhelsia_furniture.common.block.FabricDeskLampBlock;
import net.valhelsia.valhelsia_furniture.common.block.StoolBlock;
import net.valhelsia.valhelsia_furniture.common.block.TableBlock;
import net.valhelsia.valhelsia_furniture.common.block.TableclothTableBlock;
import net.valhelsia.valhelsia_furniture.common.block.UpholsteredChairBlock;
import net.valhelsia.valhelsia_furniture.core.registry.ModBlocks;

public class ModRecipeProvider
extends RecipeSubProvider {
    public ModRecipeProvider(ValhelsiaRecipeProvider provider) {
        super(provider);
    }

    protected void registerRecipes(HolderLookup.Provider lookupProvider) {
        this.table((Supplier<TableBlock>)ModBlocks.OAK_TABLE, (ItemLike)Blocks.OAK_PLANKS, ModBlocks.COLORED_OAK_TABLES);
        this.table((Supplier<TableBlock>)ModBlocks.SPRUCE_TABLE, (ItemLike)Blocks.SPRUCE_PLANKS, ModBlocks.COLORED_SPRUCE_TABLES);
        this.table((Supplier<TableBlock>)ModBlocks.BIRCH_TABLE, (ItemLike)Blocks.BIRCH_PLANKS, ModBlocks.COLORED_BIRCH_TABLES);
        this.table((Supplier<TableBlock>)ModBlocks.JUNGLE_TABLE, (ItemLike)Blocks.JUNGLE_PLANKS, ModBlocks.COLORED_JUNGLE_TABLES);
        this.table((Supplier<TableBlock>)ModBlocks.ACACIA_TABLE, (ItemLike)Blocks.ACACIA_PLANKS, ModBlocks.COLORED_ACACIA_TABLES);
        this.table((Supplier<TableBlock>)ModBlocks.CHERRY_TABLE, (ItemLike)Blocks.CHERRY_PLANKS, ModBlocks.COLORED_CHERRY_TABLES);
        this.table((Supplier<TableBlock>)ModBlocks.DARK_OAK_TABLE, (ItemLike)Blocks.DARK_OAK_PLANKS, ModBlocks.COLORED_DARK_OAK_TABLES);
        this.table((Supplier<TableBlock>)ModBlocks.MANGROVE_TABLE, (ItemLike)Blocks.MANGROVE_PLANKS, ModBlocks.COLORED_MANGROVE_TABLES);
        this.table((Supplier<TableBlock>)ModBlocks.CRIMSON_TABLE, (ItemLike)Blocks.CRIMSON_PLANKS, ModBlocks.COLORED_CRIMSON_TABLES);
        this.table((Supplier<TableBlock>)ModBlocks.WARPED_TABLE, (ItemLike)Blocks.WARPED_PLANKS, ModBlocks.COLORED_WARPED_TABLES);
        this.desk((Supplier<DeskBlock>)ModBlocks.OAK_DESK, (Supplier<DeskDrawerBlock>)ModBlocks.OAK_DESK_DRAWER, (ItemLike)Blocks.OAK_PLANKS, (ItemLike)Blocks.OAK_SLAB);
        this.desk((Supplier<DeskBlock>)ModBlocks.SPRUCE_DESK, (Supplier<DeskDrawerBlock>)ModBlocks.SPRUCE_DESK_DRAWER, (ItemLike)Blocks.SPRUCE_PLANKS, (ItemLike)Blocks.SPRUCE_SLAB);
        this.desk((Supplier<DeskBlock>)ModBlocks.BIRCH_DESK, (Supplier<DeskDrawerBlock>)ModBlocks.BIRCH_DESK_DRAWER, (ItemLike)Blocks.BIRCH_PLANKS, (ItemLike)Blocks.BIRCH_SLAB);
        this.desk((Supplier<DeskBlock>)ModBlocks.JUNGLE_DESK, (Supplier<DeskDrawerBlock>)ModBlocks.JUNGLE_DESK_DRAWER, (ItemLike)Blocks.JUNGLE_PLANKS, (ItemLike)Blocks.JUNGLE_SLAB);
        this.desk((Supplier<DeskBlock>)ModBlocks.ACACIA_DESK, (Supplier<DeskDrawerBlock>)ModBlocks.ACACIA_DESK_DRAWER, (ItemLike)Blocks.ACACIA_PLANKS, (ItemLike)Blocks.ACACIA_SLAB);
        this.desk((Supplier<DeskBlock>)ModBlocks.CHERRY_DESK, (Supplier<DeskDrawerBlock>)ModBlocks.CHERRY_DESK_DRAWER, (ItemLike)Blocks.CHERRY_PLANKS, (ItemLike)Blocks.CHERRY_SLAB);
        this.desk((Supplier<DeskBlock>)ModBlocks.DARK_OAK_DESK, (Supplier<DeskDrawerBlock>)ModBlocks.DARK_OAK_DESK_DRAWER, (ItemLike)Blocks.DARK_OAK_PLANKS, (ItemLike)Blocks.DARK_OAK_SLAB);
        this.desk((Supplier<DeskBlock>)ModBlocks.MANGROVE_DESK, (Supplier<DeskDrawerBlock>)ModBlocks.MANGROVE_DESK_DRAWER, (ItemLike)Blocks.MANGROVE_PLANKS, (ItemLike)Blocks.MANGROVE_SLAB);
        this.desk((Supplier<DeskBlock>)ModBlocks.CRIMSON_DESK, (Supplier<DeskDrawerBlock>)ModBlocks.CRIMSON_DESK_DRAWER, (ItemLike)Blocks.CRIMSON_PLANKS, (ItemLike)Blocks.CRIMSON_SLAB);
        this.desk((Supplier<DeskBlock>)ModBlocks.WARPED_DESK, (Supplier<DeskDrawerBlock>)ModBlocks.WARPED_DESK_DRAWER, (ItemLike)Blocks.WARPED_PLANKS, (ItemLike)Blocks.WARPED_SLAB);
        this.chair((Supplier<ChairBlock>)ModBlocks.OAK_CHAIR, (Supplier<ChairBlock>)ModBlocks.HAY_OAK_CHAIR, (ItemLike)Blocks.OAK_PLANKS, ModBlocks.WOOL_OAK_CHAIRS, ModBlocks.WOOL_UPHOLSTERED_OAK_CHAIRS);
        this.chair((Supplier<ChairBlock>)ModBlocks.SPRUCE_CHAIR, (Supplier<ChairBlock>)ModBlocks.HAY_SPRUCE_CHAIR, (ItemLike)Blocks.SPRUCE_PLANKS, ModBlocks.WOOL_SPRUCE_CHAIRS, ModBlocks.WOOL_UPHOLSTERED_SPRUCE_CHAIRS);
        this.chair((Supplier<ChairBlock>)ModBlocks.BIRCH_CHAIR, (Supplier<ChairBlock>)ModBlocks.HAY_BIRCH_CHAIR, (ItemLike)Blocks.BIRCH_PLANKS, ModBlocks.WOOL_BIRCH_CHAIRS, ModBlocks.WOOL_UPHOLSTERED_BIRCH_CHAIRS);
        this.chair((Supplier<ChairBlock>)ModBlocks.JUNGLE_CHAIR, (Supplier<ChairBlock>)ModBlocks.HAY_JUNGLE_CHAIR, (ItemLike)Blocks.JUNGLE_PLANKS, ModBlocks.WOOL_JUNGLE_CHAIRS, ModBlocks.WOOL_UPHOLSTERED_JUNGLE_CHAIRS);
        this.chair((Supplier<ChairBlock>)ModBlocks.ACACIA_CHAIR, (Supplier<ChairBlock>)ModBlocks.HAY_ACACIA_CHAIR, (ItemLike)Blocks.ACACIA_PLANKS, ModBlocks.WOOL_ACACIA_CHAIRS, ModBlocks.WOOL_UPHOLSTERED_ACACIA_CHAIRS);
        this.chair((Supplier<ChairBlock>)ModBlocks.CHERRY_CHAIR, (Supplier<ChairBlock>)ModBlocks.HAY_CHERRY_CHAIR, (ItemLike)Blocks.CHERRY_PLANKS, ModBlocks.WOOL_CHERRY_CHAIRS, ModBlocks.WOOL_UPHOLSTERED_CHERRY_CHAIRS);
        this.chair((Supplier<ChairBlock>)ModBlocks.DARK_OAK_CHAIR, (Supplier<ChairBlock>)ModBlocks.HAY_DARK_OAK_CHAIR, (ItemLike)Blocks.DARK_OAK_PLANKS, ModBlocks.WOOL_DARK_OAK_CHAIRS, ModBlocks.WOOL_UPHOLSTERED_DARK_OAK_CHAIRS);
        this.chair((Supplier<ChairBlock>)ModBlocks.MANGROVE_CHAIR, (Supplier<ChairBlock>)ModBlocks.HAY_MANGROVE_CHAIR, (ItemLike)Blocks.MANGROVE_PLANKS, ModBlocks.WOOL_MANGROVE_CHAIRS, ModBlocks.WOOL_UPHOLSTERED_MANGROVE_CHAIRS);
        this.chair((Supplier<ChairBlock>)ModBlocks.CRIMSON_CHAIR, (Supplier<ChairBlock>)ModBlocks.HAY_CRIMSON_CHAIR, (ItemLike)Blocks.CRIMSON_PLANKS, ModBlocks.WOOL_CRIMSON_CHAIRS, ModBlocks.WOOL_UPHOLSTERED_CRIMSON_CHAIRS);
        this.chair((Supplier<ChairBlock>)ModBlocks.WARPED_CHAIR, (Supplier<ChairBlock>)ModBlocks.HAY_WARPED_CHAIR, (ItemLike)Blocks.WARPED_PLANKS, ModBlocks.WOOL_WARPED_CHAIRS, ModBlocks.WOOL_UPHOLSTERED_WARPED_CHAIRS);
        ModBlocks.CLOSED_CURTAINS.forEach((color, pair) -> this.curtain((Supplier<ClosedCurtainBlock>)pair, (DyeColor)color));
        this.stool((Supplier<StoolBlock>)ModBlocks.OAK_STOOL, (ItemLike)Blocks.OAK_SLAB, ModBlocks.WOOL_UPHOLSTERED_OAK_STOOLS);
        this.stool((Supplier<StoolBlock>)ModBlocks.SPRUCE_STOOL, (ItemLike)Blocks.SPRUCE_SLAB, ModBlocks.WOOL_UPHOLSTERED_SPRUCE_STOOLS);
        this.stool((Supplier<StoolBlock>)ModBlocks.BIRCH_STOOL, (ItemLike)Blocks.BIRCH_SLAB, ModBlocks.WOOL_UPHOLSTERED_BIRCH_STOOLS);
        this.stool((Supplier<StoolBlock>)ModBlocks.JUNGLE_STOOL, (ItemLike)Blocks.JUNGLE_SLAB, ModBlocks.WOOL_UPHOLSTERED_JUNGLE_STOOLS);
        this.stool((Supplier<StoolBlock>)ModBlocks.ACACIA_STOOL, (ItemLike)Blocks.ACACIA_SLAB, ModBlocks.WOOL_UPHOLSTERED_ACACIA_STOOLS);
        this.stool((Supplier<StoolBlock>)ModBlocks.CHERRY_STOOL, (ItemLike)Blocks.CHERRY_SLAB, ModBlocks.WOOL_UPHOLSTERED_CHERRY_STOOLS);
        this.stool((Supplier<StoolBlock>)ModBlocks.DARK_OAK_STOOL, (ItemLike)Blocks.DARK_OAK_SLAB, ModBlocks.WOOL_UPHOLSTERED_DARK_OAK_STOOLS);
        this.stool((Supplier<StoolBlock>)ModBlocks.MANGROVE_STOOL, (ItemLike)Blocks.MANGROVE_SLAB, ModBlocks.WOOL_UPHOLSTERED_MANGROVE_STOOLS);
        this.stool((Supplier<StoolBlock>)ModBlocks.CRIMSON_STOOL, (ItemLike)Blocks.CRIMSON_SLAB, ModBlocks.WOOL_UPHOLSTERED_CRIMSON_STOOLS);
        this.stool((Supplier<StoolBlock>)ModBlocks.WARPED_STOOL, (ItemLike)Blocks.WARPED_SLAB, ModBlocks.WOOL_UPHOLSTERED_WARPED_STOOLS);
        ModBlocks.FABRIC_DESK_LAMPS.forEach((color, registryObject) -> this.fabricDeskLamp((Supplier<FabricDeskLampBlock>)registryObject, (DyeColor)color));
    }

    private void table(Supplier<TableBlock> table, ItemLike material, BlockEntrySet<TableclothTableBlock, DyeColor> coloredTables) {
        this.table(table, material);
        coloredTables.values().forEach(registryObject -> this.coloredTable((Supplier<TableclothTableBlock>)registryObject, table));
    }

    private void table(Supplier<TableBlock> block, ItemLike material) {
        this.shaped(RecipeCategory.DECORATIONS, (ItemLike)block.get(), builder -> builder.group("valhelsia_furniture:table").pattern("###").pattern("X X").pattern("X X").define(Character.valueOf('#'), material).define(Character.valueOf('X'), Tags.Items.RODS_WOODEN).unlockedBy((RecipeSubProvider)this, material));
    }

    private void coloredTable(Supplier<TableclothTableBlock> block, Supplier<TableBlock> table) {
        Block carpet = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.withDefaultNamespace((String)(Objects.requireNonNull(block.get().getColor()).getName() + "_carpet")));
        this.shaped(RecipeCategory.DECORATIONS, (ItemLike)block.get(), builder -> builder.group("valhelsia_furniture:colored_" + ((TableclothTableBlock)block.get()).getWoodType().name() + "_table").pattern("#").pattern("X").define(Character.valueOf('#'), (ItemLike)carpet).define(Character.valueOf('X'), (ItemLike)table.get()).unlockedBy((RecipeSubProvider)this, (ItemLike)table.get()).unlockedBy((RecipeSubProvider)this, (ItemLike)carpet));
    }

    private void desk(Supplier<DeskBlock> desk, Supplier<DeskDrawerBlock> deskDrawer, ItemLike material, ItemLike materialSlab) {
        this.desk(desk, material);
        this.deskDrawer(deskDrawer, material, materialSlab);
    }

    private void desk(Supplier<DeskBlock> block, ItemLike material) {
        this.shaped(RecipeCategory.DECORATIONS, (ItemLike)block.get(), builder -> builder.group("valhelsia_furniture:desk").pattern("###").pattern("# #").pattern("X X").define(Character.valueOf('#'), material).define(Character.valueOf('X'), Tags.Items.RODS_WOODEN).unlockedBy((RecipeSubProvider)this, material));
    }

    private void deskDrawer(Supplier<DeskDrawerBlock> block, ItemLike material, ItemLike materialSlab) {
        this.shaped(RecipeCategory.DECORATIONS, (ItemLike)block.get(), builder -> builder.group("valhelsia_furniture:desk_drawer").pattern("###").pattern("#S#").pattern("X X").define(Character.valueOf('#'), material).define(Character.valueOf('X'), Tags.Items.RODS_WOODEN).define(Character.valueOf('S'), materialSlab).unlockedBy((RecipeSubProvider)this, material).unlockedBy((RecipeSubProvider)this, materialSlab));
    }

    private void chair(Supplier<ChairBlock> chair, Supplier<ChairBlock> hayChair, ItemLike material, BlockEntrySet<ChairBlock, DyeColor> coloredChairs, BlockEntrySet<UpholsteredChairBlock, DyeColor> upholsteredChairs) {
        this.chair(chair, material);
        this.hayChair(hayChair, material);
        coloredChairs.values().forEach(registryObject -> this.coloredChair((Supplier<ChairBlock>)registryObject, material));
        upholsteredChairs.values().forEach(registryObject -> this.upholsteredChair((Supplier<UpholsteredChairBlock>)registryObject, material));
    }

    private void chair(Supplier<ChairBlock> block, ItemLike material) {
        this.shaped(RecipeCategory.DECORATIONS, (ItemLike)block.get(), 2, builder -> builder.group("valhelsia_furniture:chair").pattern("X  ").pattern("###").pattern("X X").define(Character.valueOf('#'), material).define(Character.valueOf('X'), Tags.Items.RODS_WOODEN).unlockedBy((RecipeSubProvider)this, material));
    }

    private void coloredChair(Supplier<ChairBlock> block, ItemLike material) {
        Block wool = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.withDefaultNamespace((String)(Objects.requireNonNull(block.get().getColor()).getName() + "_wool")));
        this.shaped(RecipeCategory.DECORATIONS, (ItemLike)block.get(), 2, builder -> builder.group("valhelsia_furniture:colored_" + ((ChairBlock)block.get()).getWoodType().name() + "_chair").pattern("X  ").pattern("#WW").pattern("X X").define(Character.valueOf('#'), material).define(Character.valueOf('X'), Tags.Items.RODS_WOODEN).define(Character.valueOf('W'), (ItemLike)wool).unlockedBy((RecipeSubProvider)this, material).unlockedBy((RecipeSubProvider)this, (ItemLike)wool));
    }

    private void hayChair(Supplier<ChairBlock> block, ItemLike material) {
        this.shaped(RecipeCategory.DECORATIONS, (ItemLike)block.get(), 2, builder -> builder.group("valhelsia_furniture:hayChair").pattern("X  ").pattern("#HH").pattern("X X").define(Character.valueOf('#'), material).define(Character.valueOf('X'), Tags.Items.RODS_WOODEN).define(Character.valueOf('H'), (ItemLike)Blocks.HAY_BLOCK).unlockedBy((RecipeSubProvider)this, material).unlockedBy((RecipeSubProvider)this, (ItemLike)Blocks.HAY_BLOCK));
    }

    private void upholsteredChair(Supplier<UpholsteredChairBlock> block, ItemLike material) {
        Block wool = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.withDefaultNamespace((String)(Objects.requireNonNull(block.get().getColor()).getName() + "_wool")));
        this.shaped(RecipeCategory.DECORATIONS, (ItemLike)block.get(), 2, builder -> builder.group("valhelsia_furniture:upholstered_" + ((UpholsteredChairBlock)block.get()).getWoodType().name() + "_chair").pattern("W  ").pattern("#WW").pattern("X X").define(Character.valueOf('#'), material).define(Character.valueOf('X'), Tags.Items.RODS_WOODEN).define(Character.valueOf('W'), (ItemLike)wool).unlockedBy((RecipeSubProvider)this, material).unlockedBy((RecipeSubProvider)this, (ItemLike)wool));
    }

    private void curtain(Supplier<ClosedCurtainBlock> block, DyeColor color) {
        Block wool = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.withDefaultNamespace((String)(color.getName() + "_wool")));
        this.shaped(RecipeCategory.DECORATIONS, (ItemLike)block.get(), 2, builder -> builder.group("valhelsia_furniture:curtain").pattern("XX").pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)wool).define(Character.valueOf('X'), Tags.Items.RODS_WOODEN).unlockedBy("has_item", ModRecipeProvider.has((ItemLike[])new ItemLike[]{wool})));
    }

    private void stool(Supplier<StoolBlock> stool, ItemLike material, BlockEntrySet<StoolBlock, DyeColor> upholsteredStools) {
        this.stool(stool, material);
        upholsteredStools.values().forEach(registryObject -> this.upholsteredStool((Supplier<StoolBlock>)registryObject, material));
    }

    private void stool(Supplier<StoolBlock> block, ItemLike material) {
        this.shaped(RecipeCategory.DECORATIONS, (ItemLike)block.get(), 2, builder -> builder.group("valhelsia_furniture:stool").pattern("###").pattern("X X").define(Character.valueOf('#'), material).define(Character.valueOf('X'), Tags.Items.RODS_WOODEN).unlockedBy((RecipeSubProvider)this, material));
    }

    private void upholsteredStool(Supplier<StoolBlock> block, ItemLike material) {
        Block wool = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.withDefaultNamespace((String)(Objects.requireNonNull(block.get().getColor()).getName() + "_wool")));
        this.shaped(RecipeCategory.DECORATIONS, (ItemLike)block.get(), 2, builder -> builder.group("valhelsia_furniture:upholstered_" + ((StoolBlock)block.get()).getWoodType().name() + "_stool").pattern("#W#").pattern("X X").define(Character.valueOf('#'), material).define(Character.valueOf('X'), Tags.Items.RODS_WOODEN).define(Character.valueOf('W'), (ItemLike)wool).unlockedBy((RecipeSubProvider)this, material).unlockedBy((RecipeSubProvider)this, (ItemLike)wool));
    }

    private void fabricDeskLamp(Supplier<FabricDeskLampBlock> block, DyeColor color) {
        Block wool = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.withDefaultNamespace((String)(color.getName() + "_wool")));
        this.shaped(RecipeCategory.DECORATIONS, (ItemLike)block.get(), builder -> builder.group("valhelsia_furniture:fabric_desk_lamp").pattern("#").pattern("G").pattern("X").define(Character.valueOf('#'), (ItemLike)wool).define(Character.valueOf('X'), Tags.Items.RODS_WOODEN).define(Character.valueOf('G'), (ItemLike)Items.GLOWSTONE_DUST).unlockedBy((RecipeSubProvider)this, (ItemLike)wool).unlockedBy((RecipeSubProvider)this, (ItemLike)Items.GLOWSTONE_DUST));
    }
}

