/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.advancementplaques.config;

import com.anthonyhilyard.iceberg.config.IcebergConfig;
import com.anthonyhilyard.iceberg.services.IIcebergConfigSpecBuilder;
import com.anthonyhilyard.iceberg.services.Services;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;

public final class AdvancementPlaquesConfig
extends IcebergConfig<AdvancementPlaquesConfig> {
    public final Supplier<Boolean> onTop;
    public final Supplier<Integer> distance;
    public final Supplier<Integer> horizontalOffset;
    public final Supplier<Boolean> hideWaila;
    public final Supplier<Boolean> tasks;
    public final Supplier<Boolean> goals;
    public final Supplier<Boolean> challenges;
    public final Supplier<Double> taskEffectFadeInTime;
    public final Supplier<Double> taskEffectFadeOutTime;
    public final Supplier<Double> taskDuration;
    public final Supplier<Double> goalEffectFadeInTime;
    public final Supplier<Double> goalEffectFadeOutTime;
    public final Supplier<Double> goalDuration;
    public final Supplier<Double> challengeEffectFadeInTime;
    public final Supplier<Double> challengeEffectFadeOutTime;
    public final Supplier<Double> challengeDuration;
    public final Supplier<List<? extends String>> whitelist;
    public final Supplier<List<? extends String>> blacklist;
    public final Supplier<Double> taskVolume;
    public final Supplier<Double> goalVolume;
    public final Supplier<Double> challengeVolume;
    private final Supplier<Supplier<?>> titleSupplier;
    private final Supplier<Supplier<?>> nameSupplier;
    private TextColor titleColor = null;
    private TextColor nameColor = null;

    public static AdvancementPlaquesConfig getInstance() {
        return (AdvancementPlaquesConfig)((Object)configInstances.get("advancementplaques"));
    }

    protected AdvancementPlaquesConfig(IIcebergConfigSpecBuilder build) {
        build.comment("Client Configuration").push("client").push("visual_options");
        this.onTop = build.comment(" If plaques should show on the top of the screen.").add("on_top", true);
        this.distance = build.comment(" The distance from the top or bottom of the screen, in pixels.").addInRange("distance", 16, 8, 256);
        this.horizontalOffset = build.comment(" The horizontal offset from the center, in pixels.").addInRange("horizontal_offset", 0, -256, 256);
        this.hideWaila = build.comment(" Hide waila/hwyla/jade popups while plaques are showing.").add("hide_waila", false);
        this.tasks = build.comment(" If plaques should show for task advancements (normal advancements).").add("tasks", true);
        this.goals = build.comment(" If plaques should show for goal advancements (medium-difficulty advancements).").add("goals", true);
        this.challenges = build.comment(" If plaques should show for challenge advancements (high-difficulty advancements).").add("challenges", true);
        Supplier titleColorValue = build.comment(" Text color to use for plaque titles (like \"Advancement made!\"). Can be entered as an 8-digit hex color code #AARRGGBB for convenience. If Prism library is installed, any Prism color definition is supported.").add("title_color", (Object)"#FF332200", v -> AdvancementPlaquesConfig.validateColor(v));
        Supplier nameColorValue = build.comment(" Text color to use for advancement names on plaques. Can be entered as an 8-digit hex color code #AARRGGBB for convenience. If Prism library is installed, any Prism color definition is supported.").add("name_color", (Object)"#FFFFFFFF", v -> AdvancementPlaquesConfig.validateColor(v));
        this.titleSupplier = () -> AdvancementPlaquesConfig.lambda$new$2((Supplier)titleColorValue);
        this.nameSupplier = () -> AdvancementPlaquesConfig.lambda$new$3((Supplier)nameColorValue);
        build.pop().push("duration_options");
        this.taskEffectFadeInTime = build.comment(" Duration of the shiny effect fade in for tasks.").addInRange("task_effect_fadein", 0.5, 0.1, 3.0);
        this.taskEffectFadeOutTime = build.comment(" Duration of the shiny effect fade out for tasks.").addInRange("task_effect_fadeout", 1.5, 0.1, 3.0);
        this.taskDuration = build.comment(" Duration of the plaques for tasks (minus the effect fade in/out durations).").addInRange("task_duration", 7.0, 2.0, 10.0);
        this.goalEffectFadeInTime = build.comment(" Duration of the shiny effect fade in for goals.").addInRange("goal_effect_fadein", 0.5, 0.1, 3.0);
        this.goalEffectFadeOutTime = build.comment(" Duration of the shiny effect fade out for goals.").addInRange("goal_effect_fadeout", 1.5, 0.1, 3.0);
        this.goalDuration = build.comment(" Duration of the plaques for goals (minus the effect fade in/out durations).").addInRange("goal_duration", 7.0, 2.0, 10.0);
        this.challengeEffectFadeInTime = build.comment(" Duration of the shiny effect fade in for challenges.").addInRange("challenge_effect_fadein", 1.25, 0.1, 3.0);
        this.challengeEffectFadeOutTime = build.comment(" Duration of the shiny effect fade out for challenges.").addInRange("challenge_effect_fadeout", 1.5, 0.1, 3.0);
        this.challengeDuration = build.comment(" Duration of the plaques for challenges (minus the effect fade in/out durations).").addInRange("challenge_duration", 7.0, 2.0, 10.0);
        build.pop().push("functionality_options");
        this.blacklist = build.comment(" Blacklist of advancements to never show plaques for.  Takes precedence over whitelist if they conflict.\n Options:\n  Advancement ID (eg. \"minecraft:adventure/adventuring_time\")\n  Mod ID (Omit the colon, eg. \"minecraft\")\n  Advancement Category (End with a /, eg. \"minecraft:story/\")").addListAllowEmpty("blacklist", (List)Lists.newArrayList(), e -> true);
        this.whitelist = build.comment(" Whitelist of advancements to show plaques for.  Leave empty to display for all.\n Same options available as blacklist.").addListAllowEmpty("whitelist", (List)Lists.newArrayList(), e -> true);
        this.taskVolume = build.comment(" Volume of task sounds.  Set to 0 to mute.").addInRange("task_volume", 1.0, 0.0, 1.0);
        this.goalVolume = build.comment(" Volume of goal sounds.  Set to 0 to mute.").addInRange("goal_volume", 1.0, 0.0, 1.0);
        this.challengeVolume = build.comment(" Volume of challenge sounds.  Set to 0 to mute.").addInRange("challenge_volume", 1.0, 0.0, 1.0);
        build.pop().pop();
    }

    private static boolean advancementEntryMatches(AdvancementHolder advancementHolder, String entry) {
        ResourceLocation advancementId = advancementHolder.id();
        if (advancementId.toString().equals(entry)) {
            return true;
        }
        if (!entry.contains(":") && advancementId.getNamespace().toString().equals(entry)) {
            return true;
        }
        return entry.endsWith("/") && advancementId.toString().startsWith(entry);
    }

    public static boolean showPlaqueForAdvancement(AdvancementHolder advancementHolder) {
        boolean bl;
        for (String string : AdvancementPlaquesConfig.getInstance().blacklist.get()) {
            if (!AdvancementPlaquesConfig.advancementEntryMatches(advancementHolder, string)) continue;
            return false;
        }
        DisplayInfo displayInfo = advancementHolder.value().display().orElse(null);
        if (displayInfo == null) {
            return false;
        }
        boolean bl2 = bl = !(displayInfo.getType() == AdvancementType.TASK && AdvancementPlaquesConfig.getInstance().tasks.get() != false || displayInfo.getType() == AdvancementType.GOAL && AdvancementPlaquesConfig.getInstance().goals.get() != false || displayInfo.getType() == AdvancementType.CHALLENGE && AdvancementPlaquesConfig.getInstance().challenges.get() != false);
        if (bl) {
            for (String string : AdvancementPlaquesConfig.getInstance().whitelist.get()) {
                if (!AdvancementPlaquesConfig.advancementEntryMatches(advancementHolder, string)) continue;
                return true;
            }
        }
        return !bl;
    }

    public TextColor getTitleColor(float alpha) {
        if (this.titleColor == null) {
            AdvancementPlaquesConfig.resolveColors();
        }
        return this.applyAlpha(this.titleColor, alpha);
    }

    public TextColor getNameColor(float alpha) {
        if (this.nameColor == null) {
            AdvancementPlaquesConfig.resolveColors();
        }
        return this.applyAlpha(this.nameColor, alpha);
    }

    private TextColor applyAlpha(TextColor color, float alpha) {
        int tempColor = color.getValue();
        int tempAlpha = (int)((float)(tempColor >> 24 & 0xFF) * alpha);
        return TextColor.fromRgb((int)(tempColor & 0xFFFFFF | tempAlpha << 24));
    }

    private static void resolveColors() {
        AdvancementPlaquesConfig.getInstance().titleColor = AdvancementPlaquesConfig.getColor(AdvancementPlaquesConfig.getInstance().titleSupplier.get().get(), TextColor.fromRgb((int)-13426176));
        AdvancementPlaquesConfig.getInstance().nameColor = AdvancementPlaquesConfig.getColor(AdvancementPlaquesConfig.getInstance().nameSupplier.get().get(), TextColor.fromRgb((int)-1));
    }

    private static boolean validateColor(Object value) {
        return AdvancementPlaquesConfig.getColor(value, null) != null;
    }

    private static TextColor getColor(Object value, TextColor defaultColor) {
        if (Services.getPlatformHelper().isModLoaded("prism")) {
            try {
                return (TextColor)Class.forName("com.anthonyhilyard.advancementplaques.compat.PrismHandler").getMethod("getColor", Object.class).invoke(null, value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (value instanceof String) {
            Object string = (String)value;
            TextColor parsedColor = TextColor.parseColor((String)string).result().orElse(null);
            if (parsedColor == null) {
                string = "#" + ((String)string).replace("0x", "").replace("#", "");
                parsedColor = TextColor.parseColor((String)string).result().orElse(null);
            }
            if (parsedColor != null) {
                return parsedColor;
            }
        } else if (value instanceof Number) {
            Number number = (Number)value;
            return TextColor.fromRgb((int)number.intValue());
        }
        return defaultColor;
    }

    protected void onReload() {
        AdvancementPlaquesConfig.resolveColors();
    }

    private static /* synthetic */ Supplier lambda$new$3(Supplier nameColorValue) {
        return nameColorValue;
    }

    private static /* synthetic */ Supplier lambda$new$2(Supplier titleColorValue) {
        return titleColorValue;
    }
}

