/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.registry;

import com.mojang.serialization.MapCodec;
import dev.shadowsoffire.placebo.Placebo;
import dev.shadowsoffire.placebo.block_entity.TickingBlockEntityType;
import dev.shadowsoffire.placebo.menu.MenuUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.StatFormatter;
import net.minecraft.stats.StatType;
import net.minecraft.stats.Stats;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.network.IContainerFactory;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.RegisterEvent;

public class DeferredHelper {
    protected final String modid;
    protected final Map<ResourceKey<? extends Registry<?>>, List<Registrar<?>>> objects;

    public static DeferredHelper create(String modid) {
        return new DeferredHelper(modid);
    }

    protected DeferredHelper(String modid) {
        this.modid = modid;
        this.objects = new IdentityHashMap();
    }

    public <T extends Block> DeferredBlock<T> block(String path, Supplier<T> factory) {
        this.register(path, Registries.BLOCK, factory);
        return DeferredBlock.createBlock((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)path));
    }

    public <T extends Block> DeferredBlock<T> block(String path, Function<BlockBehaviour.Properties, T> ctor, UnaryOperator<BlockBehaviour.Properties> properties) {
        return this.block(path, () -> (Block)ctor.apply((BlockBehaviour.Properties)properties.apply(BlockBehaviour.Properties.of())));
    }

    public <T extends Fluid> DeferredHolder<Fluid, T> fluid(String path, Supplier<T> factory) {
        return this.registerDH(path, Registries.FLUID, factory);
    }

    public <T extends Item> DeferredItem<T> item(String path, Supplier<T> factory) {
        this.register(path, Registries.ITEM, factory);
        return DeferredItem.createItem((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)path));
    }

    public <T extends Item> DeferredItem<T> item(String path, Function<Item.Properties, T> ctor, UnaryOperator<Item.Properties> properties) {
        return this.item(path, () -> (Item)ctor.apply((Item.Properties)properties.apply(new Item.Properties())));
    }

    public <T extends Item> DeferredItem<T> item(String path, Function<Item.Properties, T> ctor) {
        return this.item(path, ctor, UnaryOperator.identity());
    }

    public <T extends BlockItem> DeferredItem<T> blockItem(String path, Holder<Block> block, BiFunction<Block, Item.Properties, T> ctor, UnaryOperator<Item.Properties> properties) {
        return this.item(path, () -> (BlockItem)ctor.apply((Block)block.value(), (Item.Properties)properties.apply(new Item.Properties())));
    }

    public DeferredItem<BlockItem> blockItem(String path, Holder<Block> block, UnaryOperator<Item.Properties> properties) {
        return this.blockItem(path, block, BlockItem::new, properties);
    }

    public DeferredItem<BlockItem> blockItem(String path, Holder<Block> block) {
        return this.blockItem(path, block, UnaryOperator.identity());
    }

    public <T extends MobEffect> DeferredHolder<MobEffect, T> effect(String path, Supplier<T> factory) {
        return this.registerDH(path, Registries.MOB_EFFECT, factory);
    }

    public <T extends SoundEvent> DeferredHolder<SoundEvent, T> sound(String path, Supplier<T> factory) {
        return this.registerDH(path, Registries.SOUND_EVENT, factory);
    }

    public Holder<SoundEvent> sound(String path) {
        return this.sound(path, () -> SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)path)));
    }

    public <T extends Potion> DeferredHolder<Potion, T> potion(String path, Supplier<T> factory) {
        return this.registerDH(path, Registries.POTION, factory);
    }

    public DeferredHolder<Potion, Potion> singlePotion(String path, Supplier<MobEffectInstance> factory) {
        return this.registerDH(path, Registries.POTION, () -> {
            MobEffectInstance inst = (MobEffectInstance)factory.get();
            ResourceLocation key = inst.getEffect().getKey().location();
            return new Potion(key.toLanguageKey(), new MobEffectInstance[]{inst});
        });
    }

    public DeferredHolder<Potion, Potion> multiPotion(String path, Supplier<List<MobEffectInstance>> factory) {
        String key = ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)path).toLanguageKey("potion");
        return this.registerDH(path, Registries.POTION, () -> new Potion(key, ((List)factory.get()).toArray(new MobEffectInstance[0])));
    }

    public <U extends Entity, T extends EntityType<U>> DeferredHolder<EntityType<?>, T> entity(String path, Supplier<T> factory) {
        return this.registerDH(path, Registries.ENTITY_TYPE, factory);
    }

    public <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> entity(String path, EntityType.EntityFactory<T> factory, MobCategory category, UnaryOperator<EntityType.Builder<T>> op) {
        String key = ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)path).toLanguageKey("entity");
        return this.entity(path, () -> ((EntityType.Builder)op.apply(EntityType.Builder.of((EntityType.EntityFactory)factory, (MobCategory)category))).build(key));
    }

    public <T extends BlockEntity> DeferredHolder<BlockEntityType<?>, BlockEntityType<T>> blockEntity(String path, BlockEntityType.BlockEntitySupplier<T> factory, Supplier<Set<Block>> validBlocks) {
        return this.registerDH(path, Registries.BLOCK_ENTITY_TYPE, () -> new BlockEntityType(factory, (Set)validBlocks.get(), null));
    }

    public <T extends BlockEntity> DeferredHolder<BlockEntityType<?>, TickingBlockEntityType<T>> tickingBlockEntity(String path, BlockEntityType.BlockEntitySupplier<T> factory, Supplier<Set<Block>> validBlocks, TickingBlockEntityType.TickSide side) {
        return this.registerDH(path, Registries.BLOCK_ENTITY_TYPE, () -> new TickingBlockEntityType(factory, (Set)validBlocks.get(), side));
    }

    public <U extends ParticleOptions, T extends ParticleType<U>> DeferredHolder<ParticleType<?>, T> particle(String path, Supplier<T> factory) {
        return this.registerDH(path, Registries.PARTICLE_TYPE, factory);
    }

    public DeferredHolder<ParticleType<?>, SimpleParticleType> simpleParticle(String path, boolean overrideLimit) {
        return this.particle(path, () -> new SimpleParticleType(overrideLimit));
    }

    public <T extends ParticleOptions> DeferredHolder<ParticleType<?>, ParticleType<T>> particle(String path, boolean overrideLimit, final Function<ParticleType<T>, MapCodec<T>> codec, final Function<ParticleType<T>, StreamCodec<? super RegistryFriendlyByteBuf, T>> streamCodec) {
        return this.particle(path, () -> new ParticleType<T>(this, overrideLimit){

            public MapCodec<T> codec() {
                return (MapCodec)codec.apply(this);
            }

            public StreamCodec<? super RegistryFriendlyByteBuf, T> streamCodec() {
                return (StreamCodec)streamCodec.apply(this);
            }
        });
    }

    public <U extends AbstractContainerMenu, T extends MenuType<U>> DeferredHolder<MenuType<?>, T> menu(String path, Supplier<T> factory) {
        return this.registerDH(path, Registries.MENU, factory);
    }

    public <T extends AbstractContainerMenu> DeferredHolder<MenuType<?>, MenuType<T>> menu(String path, MenuType.MenuSupplier<T> factory) {
        return this.menu(path, () -> MenuUtil.type(factory));
    }

    public <T extends AbstractContainerMenu> DeferredHolder<MenuType<?>, MenuType<T>> menuWithPos(String path, MenuUtil.PosFactory<T> factory) {
        return this.menu(path, () -> MenuUtil.posType(factory));
    }

    public <T extends AbstractContainerMenu> DeferredHolder<MenuType<?>, MenuType<T>> menuWithData(String path, IContainerFactory<T> factory) {
        return this.menu(path, () -> MenuUtil.bufType(factory));
    }

    public <C extends RecipeInput, U extends Recipe<C>, T extends RecipeType<U>> DeferredHolder<RecipeType<?>, T> recipe(String path, Supplier<T> factory) {
        return this.registerDH(path, Registries.RECIPE_TYPE, factory);
    }

    public <C extends RecipeInput, U extends Recipe<C>> RecipeType<U> recipe(String path) {
        RecipeType type = RecipeType.simple((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)path));
        this.recipe(path, () -> type);
        return type;
    }

    public <C extends RecipeInput, U extends Recipe<C>, T extends RecipeSerializer<U>> DeferredHolder<RecipeSerializer<?>, T> recipeSerializer(String path, Supplier<T> factory) {
        return this.registerDH(path, Registries.RECIPE_SERIALIZER, factory);
    }

    public <T extends Attribute> DeferredHolder<Attribute, T> attribute(String path, Supplier<T> factory) {
        return this.registerDH(path, Registries.ATTRIBUTE, factory);
    }

    public DeferredHolder<Attribute, RangedAttribute> rangedAttribute(String path, double defaultValue, double min, double max) {
        String key = ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)path).toLanguageKey("attribute");
        return this.attribute(path, () -> new RangedAttribute(key, defaultValue, min, max));
    }

    public <S, U extends StatType<S>, T extends StatType<U>> DeferredHolder<StatType<?>, T> stat(String path, Supplier<T> factory) {
        return this.registerDH(path, Registries.STAT_TYPE, factory);
    }

    public Holder<ResourceLocation> customStat(String path, StatFormatter formatter) {
        return this.registerDH(path, Registries.CUSTOM_STAT, () -> {
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)path);
            Stats.CUSTOM.get((Object)id, formatter);
            return id;
        });
    }

    public <U extends FeatureConfiguration, T extends Feature<U>> DeferredHolder<Feature<?>, T> feature(String path, Supplier<T> factory) {
        return this.registerDH(path, Registries.FEATURE, factory);
    }

    public DeferredHolder<CreativeModeTab, CreativeModeTab> creativeTab(String path, UnaryOperator<CreativeModeTab.Builder> operator) {
        return this.registerDH(path, Registries.CREATIVE_MODE_TAB, () -> ((CreativeModeTab.Builder)operator.apply(CreativeModeTab.builder())).build());
    }

    public <T> DataComponentType<T> enchantmentEffect(String path, UnaryOperator<DataComponentType.Builder<T>> operator) {
        DataComponentType type = ((DataComponentType.Builder)operator.apply(DataComponentType.builder())).build();
        this.register(path, Registries.ENCHANTMENT_EFFECT_COMPONENT_TYPE, () -> type);
        return type;
    }

    public <T> DataComponentType<T> component(String path, UnaryOperator<DataComponentType.Builder<T>> operator) {
        DataComponentType type = ((DataComponentType.Builder)operator.apply(DataComponentType.builder())).build();
        this.register(path, Registries.DATA_COMPONENT_TYPE, () -> type);
        return type;
    }

    public <R, T extends R> DeferredHolder<R, T> custom(String path, ResourceKey<Registry<R>> registry, Supplier<T> factory) {
        return this.registerDH(path, registry, factory);
    }

    protected <R, T extends R> void register(String path, ResourceKey<Registry<R>> regKey, Supplier<T> factory) {
        List registrars = this.objects.computeIfAbsent(regKey, k -> new ArrayList());
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)path);
        registrars.add(new Registrar<T>(id, factory));
    }

    protected <R, T extends R> DeferredHolder<R, T> registerDH(String path, ResourceKey<Registry<R>> regKey, Supplier<T> factory) {
        this.register(path, regKey, factory);
        return DeferredHolder.create(regKey, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)path));
    }

    @SubscribeEvent
    public void register(RegisterEvent e) {
        Registry registry = e.getRegistry();
        for (Registrar registrar : this.objects.getOrDefault(e.getRegistryKey(), Collections.emptyList())) {
            try {
                Registry.register((Registry)registry, (ResourceLocation)registrar.id, registrar.factory.get());
            }
            catch (Throwable ex) {
                Placebo.LOGGER.error("Exception thrown during registration of {}", (Object)registrar.id);
                throw ex;
            }
        }
        this.objects.remove(e.getRegistryKey());
    }

    protected record Registrar<T>(ResourceLocation id, Supplier<T> factory) {
    }
}

