/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.systems.mixes;

import dev.shadowsoffire.placebo.Placebo;
import dev.shadowsoffire.placebo.PlaceboClient;
import dev.shadowsoffire.placebo.reload.DynamicRegistry;
import dev.shadowsoffire.placebo.systems.mixes.JsonMix;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.Nullable;

public class MixRegistry
extends DynamicRegistry<JsonMix<?>> {
    public static final MixRegistry INSTANCE = new MixRegistry();

    public MixRegistry() {
        super(Placebo.LOGGER, "brewing_mixes", true, false);
    }

    @Override
    protected void registerBuiltinCodecs() {
        this.registerDefaultCodec(Placebo.loc("mix"), JsonMix.CODEC);
    }

    @Override
    protected void beginReload() {
        for (PotionBrewing brewing : MixRegistry.resolveBrewing()) {
            this.removeAll(brewing);
        }
        super.beginReload();
    }

    @Override
    protected void onReload() {
        for (PotionBrewing brewing : MixRegistry.resolveBrewing()) {
            this.addAll(brewing);
        }
        super.onReload();
    }

    private static List<@Nullable PotionBrewing> resolveBrewing() {
        ArrayList<PotionBrewing> registries = new ArrayList<PotionBrewing>();
        if (FMLEnvironment.dist.isClient()) {
            registries.add(PlaceboClient.getBrewingRegistry());
        }
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            registries.add(ServerLifecycleHooks.getCurrentServer().potionBrewing());
        }
        return registries;
    }

    private static List<PotionBrewing.Mix<?>> getMixList(PotionBrewing brewing, JsonMix.Type type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case JsonMix.Type.POTION -> brewing.potionMixes;
            case JsonMix.Type.CONTAINER -> brewing.containerMixes;
        };
    }

    private static void makeMutable(PotionBrewing brewing) {
        brewing.containerMixes = new ArrayList(brewing.containerMixes);
        brewing.potionMixes = new ArrayList(brewing.potionMixes);
    }

    private void removeAll(@Nullable PotionBrewing brewing) {
        if (brewing != null) {
            MixRegistry.makeMutable(brewing);
            this.getValues().forEach(mix -> MixRegistry.getMixList(brewing, mix.type()).remove(mix.mix()));
        }
    }

    private void addAll(@Nullable PotionBrewing brewing) {
        if (brewing != null) {
            MixRegistry.makeMutable(brewing);
            this.getValues().forEach(mix -> MixRegistry.getMixList(brewing, mix.type()).add(mix.mix()));
        }
    }
}

