/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.api.common.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.Nullable;

public class ItemStackUtils {
    public static void shrinkStack(@Nullable Player player, ItemStack stack) {
        ItemStackUtils.shrinkStack(player, stack, 1);
    }

    public static void shrinkStack(@Nullable Player player, ItemStack stack, int count) {
        if (player == null || !player.isCreative()) {
            stack.shrink(count);
        }
    }

    public static ItemStack getFilledMap(Level level, BlockPos playerPos, TagKey<Structure> destination, Holder<MapDecorationType> decorationType, String name) {
        if (!(level instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        BlockPos pos = serverLevel.findNearestMapStructure(destination, playerPos, 100, true);
        if (pos == null) {
            return null;
        }
        ItemStack stack = MapItem.create((Level)serverLevel, (int)pos.getX(), (int)pos.getZ(), (byte)2, (boolean)true, (boolean)true);
        MapItem.renderBiomePreviewMap((ServerLevel)serverLevel, (ItemStack)stack);
        MapItemSavedData.addTargetDecoration((ItemStack)stack, (BlockPos)pos, (String)"+", decorationType);
        stack.set(DataComponents.ITEM_NAME, (Object)Component.translatable((String)name));
        return stack;
    }
}

