/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.core.mixin.neoforge;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.models.BlockModelGenerators;
import net.minecraft.data.models.ItemModelGenerators;
import net.minecraft.data.models.ModelProvider;
import net.minecraft.data.models.model.DelegatedModel;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.valhelsia.valhelsia_core.datagen.ValhelsiaModelProvider;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={ModelProvider.class})
public abstract class ModelProviderMixin {
    @Unique
    private final Set<Item> skippedAutoBlockModels = Sets.newHashSet();
    @Unique
    private static final Map<ResourceLocation, Supplier<JsonElement>> BLOCK_ITEMS = new HashMap<ResourceLocation, Supplier<JsonElement>>();

    @Shadow
    protected abstract <T> CompletableFuture<?> saveCollection(CachedOutput var1, Map<T, ? extends Supplier<JsonElement>> var2, Function<T, Path> var3);

    @Redirect(method={"run(Lnet/minecraft/data/CachedOutput;)Ljava/util/concurrent/CompletableFuture;"}, at=@At(value="INVOKE", target="Lnet/minecraft/data/models/BlockModelGenerators;run()V"))
    private void valhelsia_core_run$registerBlockStateModels(BlockModelGenerators instance) {
        if (!this.createModels(modelProvider -> {
            modelProvider.generateBlockStateModels(instance, this.skippedAutoBlockModels::add);
            modelProvider.getBlocks().forEach(entry -> {
                Item item = (Item)Item.BY_BLOCK.get(entry.get());
                if (item == null || this.skippedAutoBlockModels.contains(item)) {
                    return;
                }
                ResourceLocation resourceLocation = ModelLocationUtils.getModelLocation((Item)item);
                BLOCK_ITEMS.putIfAbsent(resourceLocation, (Supplier<JsonElement>)new DelegatedModel(ModelLocationUtils.getModelLocation((Block)((Block)entry.get()))));
            });
        })) {
            instance.run();
        }
    }

    @Redirect(method={"run(Lnet/minecraft/data/CachedOutput;)Ljava/util/concurrent/CompletableFuture;"}, at=@At(value="INVOKE", target="Lnet/minecraft/data/models/ItemModelGenerators;run()V"))
    private void valhelsia_core_run$registerItemModels(ItemModelGenerators instance) {
        if (!this.createModels(modelProvider -> modelProvider.generateItemModels(instance))) {
            instance.run();
        }
    }

    @Unique
    private boolean createModels(Consumer<ValhelsiaModelProvider> consumer) {
        ModelProviderMixin modelProviderMixin = this;
        if (modelProviderMixin instanceof ValhelsiaModelProvider) {
            ValhelsiaModelProvider modelProvider = (ValhelsiaModelProvider)((Object)modelProviderMixin);
            consumer.accept(modelProvider);
            return true;
        }
        return false;
    }

    @Redirect(method={"run(Lnet/minecraft/data/CachedOutput;)Ljava/util/concurrent/CompletableFuture;"}, at=@At(value="INVOKE", target="Ljava/util/List;isEmpty()Z"))
    private boolean valhelsia_core_run$preventException(List<Block> instance) {
        return true;
    }

    @Redirect(method={"lambda$run$4(Ljava/util/Set;Ljava/util/Map;Lnet/minecraft/world/level/block/Block;)V"}, at=@At(value="INVOKE", target="Ljava/util/Set;contains(Ljava/lang/Object;)Z"))
    private static boolean valhelsia_core_run$registerBlockStateModels(Set<Item> instance, Object o) {
        if (o instanceof Item) {
            Item item = (Item)o;
            return !BLOCK_ITEMS.containsKey(ModelLocationUtils.getModelLocation((Item)item));
        }
        return true;
    }
}

