/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.gui.ingredients;

import java.util.List;
import java.util.Optional;
import mezz.jei.api.ingredients.ITypedIngredient;
import net.minecraft.client.gui.screens.Screen;

public class CycleTimer {
    private static final int cycleTime = 1000;
    private long startTime;
    private int drawDuration = 0;
    private int pausedDuration = 0;

    public CycleTimer(int offset) {
        long time = System.currentTimeMillis();
        this.startTime = time - (long)offset * 1000L;
    }

    public Optional<ITypedIngredient<?>> getCycledItem(List<Optional<ITypedIngredient<?>>> list) {
        if (list.isEmpty()) {
            return Optional.empty();
        }
        int index = this.drawDuration / 1000 % list.size();
        return list.get(index);
    }

    public void onDraw() {
        if (!Screen.hasShiftDown()) {
            if (this.pausedDuration > 0) {
                this.startTime += (long)this.pausedDuration;
                this.pausedDuration = 0;
            }
            this.drawDuration = Math.toIntExact(System.currentTimeMillis() - this.startTime);
        } else {
            long drawTime = this.startTime + (long)this.drawDuration;
            this.pausedDuration = Math.toIntExact(System.currentTimeMillis() - drawTime);
        }
    }
}

