/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla.ingredients;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.common.Internal;
import mezz.jei.common.config.IClientConfig;
import mezz.jei.common.config.IJeiClientConfigs;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.common.util.RegistryUtil;
import mezz.jei.common.util.StackHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public final class ItemStackListFactory {
    private static final Logger LOGGER = LogManager.getLogger();

    public static List<ItemStack> create(StackHelper stackHelper) {
        IJeiClientConfigs jeiClientConfigs = Internal.getJeiClientConfigs();
        IClientConfig clientConfig = jeiClientConfigs.getClientConfig();
        boolean showHidden = clientConfig.isShowHiddenItemsEnabled();
        ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
        HashSet<Object> itemUidSet = new HashSet<Object>();
        Minecraft minecraft = Minecraft.getInstance();
        FeatureFlagSet features = Optional.ofNullable(minecraft.player).map(p -> p.connection).map(ClientPacketListener::enabledFeatures).orElse(FeatureFlagSet.of());
        boolean hasOperatorItemsTabPermissions = showHidden || (Boolean)minecraft.options.operatorItemsTab().get() != false || Optional.of(minecraft).map(m -> m.player).map(Player::canUseGameMasterBlocks).orElse(false) != false;
        ClientLevel level = minecraft.level;
        if (level == null) {
            throw new NullPointerException("minecraft.level must be set before JEI fetches ingredients");
        }
        RegistryAccess registryAccess = level.registryAccess();
        CreativeModeTab.ItemDisplayParameters displayParameters = new CreativeModeTab.ItemDisplayParameters(features, hasOperatorItemsTabPermissions, (HolderLookup.Provider)registryAccess);
        for (CreativeModeTab itemGroup : CreativeModeTabs.allTabs()) {
            Collection creativeTabItemStacks;
            if (itemGroup.getType() != CreativeModeTab.Type.CATEGORY) {
                LOGGER.debug("Skipping creative tab: '{}' because it is type: {}", (Object)itemGroup.getDisplayName().getString(), (Object)itemGroup.getType());
                continue;
            }
            try {
                itemGroup.buildContents(displayParameters);
            }
            catch (LinkageError | RuntimeException e) {
                LOGGER.error("Item Group crashed while building contents.Items from this group will be missing from the JEI ingredient list: {}", (Object)itemGroup.getDisplayName().getString(), (Object)e);
                continue;
            }
            try {
                creativeTabItemStacks = itemGroup.getSearchTabDisplayItems();
            }
            catch (LinkageError | RuntimeException e) {
                LOGGER.error("Item Group crashed while getting search tab display items.Some items from this group will be missing from the JEI ingredient list: {}", (Object)itemGroup.getDisplayName().getString(), (Object)e);
                continue;
            }
            if (creativeTabItemStacks.isEmpty()) {
                try {
                    Collection displayItems = itemGroup.getDisplayItems();
                    if (displayItems.isEmpty()) {
                        LOGGER.warn("Item Group has no display items and no search tab display items. Items from this group will be missing from the JEI ingredient list. {}", (Object)itemGroup.getDisplayName().getString());
                        continue;
                    }
                    LOGGER.warn("Item Group has no search tab display items. Falling back on getting the regular display items: {}", (Object)itemGroup.getDisplayName().getString());
                    creativeTabItemStacks = displayItems;
                }
                catch (LinkageError | RuntimeException e) {
                    LOGGER.error("Item Group has no search tab display items and crashed while getting display items. Items from this group will be missing from the JEI ingredient list. {}", (Object)itemGroup.getDisplayName().getString(), (Object)e);
                    continue;
                }
            }
            HashSet<Object> tabUidSet = new HashSet<Object>();
            int added = 0;
            HashSet<Object> duplicateInTab = new HashSet<Object>();
            int duplicateInTabCount = 0;
            for (ItemStack itemStack : creativeTabItemStacks) {
                if (itemStack.isEmpty()) {
                    LOGGER.error("Found an empty itemStack from creative tab: {}", (Object)itemGroup);
                    continue;
                }
                Object itemKey = ItemStackListFactory.getItemKey(stackHelper, itemStack);
                if (itemKey == null) continue;
                if (tabUidSet.contains(itemKey)) {
                    duplicateInTab.add(itemKey);
                    ++duplicateInTabCount;
                }
                if (!itemUidSet.add(itemKey)) continue;
                tabUidSet.add(itemKey);
                itemList.add(itemStack);
                ++added;
            }
            LOGGER.debug("Added {}/{} new items from creative tab: {}", (Object)added, (Object)creativeTabItemStacks.size(), (Object)itemGroup.getDisplayName().getString());
            if (duplicateInTabCount <= 0) continue;
            LOGGER.warn("{} duplicate items were found in creative tab: {}\nThis may indicate that these types of item need a subtype interpreter added to JEI:\n{}", (Object)duplicateInTabCount, (Object)itemGroup.getDisplayName().getString(), (Object)duplicateInTab.stream().map(Object::toString).collect(Collectors.joining(", ", "[", "]")));
        }
        if (showHidden) {
            ItemStackListFactory.addItemsFromRegistries(stackHelper, itemList, itemUidSet, features);
        }
        return itemList;
    }

    private static void addItemsFromRegistries(StackHelper stackHelper, List<ItemStack> itemList, Set<Object> itemUidSet, FeatureFlagSet features) {
        Object itemKey;
        List<ItemStack> itemStacks = RegistryUtil.getRegistry(Registries.ITEM).asLookup().filterFeatures(features).listElements().map(ItemStack::new).filter(i -> !i.isEmpty()).toList();
        int added = 0;
        for (ItemStack itemStack : itemStacks) {
            itemKey = ItemStackListFactory.getItemKey(stackHelper, itemStack);
            if (itemKey == null || !itemUidSet.add(itemKey)) continue;
            itemList.add(itemStack);
            ++added;
        }
        LOGGER.debug("Added {}/{} new items from the item registry (this is run because ShowHiddenItems is set to true in JEI's config)", (Object)added, (Object)itemStacks.size());
        itemStacks = RegistryUtil.getRegistry(Registries.BLOCK).asLookup().filterFeatures(features).listElements().map(Holder.Reference::value).map(ItemStack::new).filter(i -> !i.isEmpty()).toList();
        added = 0;
        for (ItemStack itemStack : itemStacks) {
            itemKey = ItemStackListFactory.getItemKey(stackHelper, itemStack);
            if (itemKey == null || !itemUidSet.add(itemKey)) continue;
            itemList.add(itemStack);
            ++added;
        }
        LOGGER.debug("Added {}/{} new items from the block registry (this is run because ShowHiddenItems is set to true in JEI's config)", (Object)added, (Object)itemStacks.size());
    }

    @Nullable
    private static Object getItemKey(StackHelper stackHelper, ItemStack stack) {
        if (stackHelper.hasSubtypes(stack)) {
            try {
                return stackHelper.getUniqueIdentifierForStack(stack, UidContext.Ingredient);
            }
            catch (LinkageError | RuntimeException e) {
                String stackInfo = ErrorUtil.getItemStackInfo(stack);
                LOGGER.error("Couldn't get unique name for itemStack {}", (Object)stackInfo, (Object)e);
                return null;
            }
        }
        return stack.getItem();
    }
}

