/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla.ingredients.subtypes;

import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.component.Fireworks;

public class FireworkRocketSubtypeInterpreter
implements IIngredientSubtypeInterpreter<ItemStack> {
    public static final FireworkRocketSubtypeInterpreter INSTANCE = new FireworkRocketSubtypeInterpreter();

    private FireworkRocketSubtypeInterpreter() {
    }

    @Override
    public String apply(ItemStack itemStack, UidContext context) {
        Fireworks fireworks = (Fireworks)itemStack.get(DataComponents.FIREWORKS);
        if (fireworks == null) {
            return "";
        }
        List explosions = fireworks.explosions();
        ArrayList<String> strings = new ArrayList<String>();
        for (Object e : explosions) {
            FireworkExplosion.Shape shape = e.shape();
            strings.add(shape.getSerializedName());
        }
        StringJoiner joiner = new StringJoiner(",", "[", "]");
        strings.sort(null);
        for (String s : strings) {
            joiner.add(s);
        }
        int flightDuration = fireworks.flightDuration();
        return flightDuration + ":" + String.valueOf(joiner);
    }
}

