/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.category.ui.data.options;

import java.util.function.BiFunction;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import net.minecraft.client.resources.language.I18n;
import xaero.common.category.ui.data.GuiCategoryUIEditorExpandableData;
import xaero.common.category.ui.data.options.GuiCategoryUIEditorCompactOptionsData;
import xaero.common.category.ui.data.options.GuiCategoryUIEditorOptionData;
import xaero.common.category.ui.data.options.GuiCategoryUIEditorOptionsData;
import xaero.common.category.ui.entry.CategorySettingsListMainEntryFactory;
import xaero.common.graphics.CursorBox;

public class GuiCategoryUIEditorCompactBooleanOptionsData
extends GuiCategoryUIEditorCompactOptionsData<Boolean> {
    private final GuiCategoryUIEditorOptionData<Boolean> trueOption;
    private final GuiCategoryUIEditorOptionData<Boolean> falseOption;
    private IntFunction<GuiCategoryUIEditorOptionData<Boolean>> indexReader;

    protected GuiCategoryUIEditorCompactBooleanOptionsData(String displayName, int currentIndex, int optionCount, boolean movable, CategorySettingsListMainEntryFactory listEntryFactory, BiFunction<GuiCategoryUIEditorExpandableData<?>, GuiCategoryUIEditorExpandableData<GuiCategoryUIEditorOptionData<Boolean>>, Supplier<CursorBox>> tooltipSupplier, GuiCategoryUIEditorOptionsData.IOptionsDataIsActiveSupplier isActiveSupplier, GuiCategoryUIEditorOptionData<Boolean> trueOption, GuiCategoryUIEditorOptionData<Boolean> falseOption) {
        super(displayName, currentIndex, optionCount, movable, listEntryFactory, tooltipSupplier, isActiveSupplier);
        this.trueOption = trueOption;
        this.falseOption = falseOption;
        this.currentValue = this.getIndexReader().apply(currentIndex);
    }

    @Override
    protected IntFunction<GuiCategoryUIEditorOptionData<Boolean>> getIndexReader() {
        if (this.indexReader == null) {
            this.indexReader = i -> i != 0 ? this.trueOption : this.falseOption;
        }
        return this.indexReader;
    }

    public static final class Builder
    extends GuiCategoryUIEditorCompactOptionsData.Builder<Boolean, Builder> {
        protected final GuiCategoryUIEditorOptionData.Builder<Boolean> trueOptionBuilder = GuiCategoryUIEditorOptionData.Builder.getDefault();
        protected final GuiCategoryUIEditorOptionData.Builder<Boolean> falseOptionBuilder = GuiCategoryUIEditorOptionData.Builder.getDefault();

        protected Builder() {
        }

        @Override
        public Builder setDefault() {
            super.setDefault();
            ((GuiCategoryUIEditorOptionData.Builder)this.trueOptionBuilder.setDefault()).setDisplayName(I18n.get((String)"gui.xaero_on", (Object[])new Object[0])).setValue(true);
            ((GuiCategoryUIEditorOptionData.Builder)this.falseOptionBuilder.setDefault()).setDisplayName(I18n.get((String)"gui.xaero_off", (Object[])new Object[0])).setValue(false);
            this.setCurrentValue(false);
            return (Builder)this.self;
        }

        public GuiCategoryUIEditorOptionData.Builder<Boolean> getTrueOptionBuilder() {
            return this.trueOptionBuilder;
        }

        public GuiCategoryUIEditorOptionData.Builder<Boolean> getFalseOptionBuilder() {
            return this.falseOptionBuilder;
        }

        @Override
        public GuiCategoryUIEditorCompactBooleanOptionsData build() {
            if (this.currentValue == null) {
                throw new IllegalStateException();
            }
            if (this.movable) {
                throw new IllegalStateException("toggles can't be movable!");
            }
            return (GuiCategoryUIEditorCompactBooleanOptionsData)super.build();
        }

        protected GuiCategoryUIEditorCompactBooleanOptionsData buildInternally(CategorySettingsListMainEntryFactory listEntryFactory) {
            GuiCategoryUIEditorExpandableData trueOption = this.trueOptionBuilder.build();
            GuiCategoryUIEditorExpandableData falseOption = this.falseOptionBuilder.build();
            return new GuiCategoryUIEditorCompactBooleanOptionsData(this.displayName, (Boolean)this.currentValue != false ? 1 : 0, 2, this.movable, listEntryFactory, this.tooltipSupplier, this.isActiveSupplier, (GuiCategoryUIEditorOptionData<Boolean>)trueOption, (GuiCategoryUIEditorOptionData<Boolean>)falseOption);
        }

        public static Builder getDefault() {
            return new Builder().setDefault();
        }
    }
}

