/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import xaero.common.HudMod;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.gui.ConfigSettingEntry;
import xaero.common.gui.GuiEditMode;
import xaero.common.gui.GuiEntityRadarSettings;
import xaero.common.gui.GuiMinimapBlockMapSettings;
import xaero.common.gui.GuiMinimapInfoSettings;
import xaero.common.gui.GuiMinimapMiscSettings;
import xaero.common.gui.GuiMinimapOverlaysSettings;
import xaero.common.gui.GuiMinimapSettings;
import xaero.common.gui.GuiMinimapViewSettings;
import xaero.common.gui.GuiReset;
import xaero.common.gui.GuiSettings;
import xaero.common.gui.GuiWaypointSettings;
import xaero.common.gui.GuiWaypoints;
import xaero.common.gui.ISettingEntry;
import xaero.common.gui.ScreenBase;
import xaero.common.gui.ScreenSwitchSettingEntry;
import xaero.common.settings.ModOptions;
import xaero.common.settings.ModSettings;

public class GuiMinimapMain
extends GuiMinimapSettings {
    private ISettingEntry[] mainEntries;
    private ISettingEntry[] searchableEntries;

    public GuiMinimapMain(Screen current) {
        this(HudMod.INSTANCE, current, ScreenBase.tryToGetEscape(current));
    }

    public GuiMinimapMain(IXaeroMinimap modMain, Screen par1GuiScreen, Screen escScreen) {
        super(modMain, (Component)Component.translatable((String)"gui.xaero_minimap_settings"), par1GuiScreen, escScreen);
        ScreenSwitchSettingEntry changePositionEntry = new ScreenSwitchSettingEntry("gui.xaero_change_position", (current, escape) -> par1GuiScreen instanceof GuiEditMode ? par1GuiScreen : new GuiEditMode(modMain, (Screen)current, (Screen)escape, false, (Component)Component.translatable((String)"gui.xaero_minimap_guide")), null, true);
        ScreenSwitchSettingEntry viewSettingsEntry = new ScreenSwitchSettingEntry("gui.xaero_minimap_view_settings", (current, escape) -> new GuiMinimapViewSettings(modMain, (Screen)current, (Screen)escape), null, true);
        ScreenSwitchSettingEntry entityRadarSettingsEntry = new ScreenSwitchSettingEntry("gui.xaero_entity_radar_settings", (current, escape) -> new GuiEntityRadarSettings(modMain, (Screen)current, (Screen)escape), null, true);
        ScreenSwitchSettingEntry blockMapSettingsEntry = new ScreenSwitchSettingEntry("gui.xaero_minimap_block_map_settings", (current, escape) -> new GuiMinimapBlockMapSettings(modMain, (Screen)current, (Screen)escape), null, true);
        ScreenSwitchSettingEntry overlaySettingsEntry = new ScreenSwitchSettingEntry("gui.xaero_overlay_settings", (current, escape) -> new GuiMinimapOverlaysSettings(modMain, (Screen)current, (Screen)escape), null, true);
        ScreenSwitchSettingEntry infoSettingsEntry = new ScreenSwitchSettingEntry("gui.xaero_minimap_info_settings", (current, escape) -> new GuiMinimapInfoSettings(modMain, (Screen)current, (Screen)escape), null, true);
        ScreenSwitchSettingEntry waypointSettingsEntry = new ScreenSwitchSettingEntry("gui.xaero_waypoint_settings", (current, escape) -> new GuiWaypointSettings(modMain, (Screen)current, (Screen)escape), null, true);
        ScreenSwitchSettingEntry miscSettingsEntry = new ScreenSwitchSettingEntry("gui.xaero_minimap_misc_settings", (current, escape) -> new GuiMinimapMiscSettings(modMain, (Screen)current, (Screen)escape), null, true);
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        ScreenSwitchSettingEntry waypointsEntry = new ScreenSwitchSettingEntry("gui.xaero_waypoints", (current, escape) -> {
            XaeroMinimapSession minimapSession2 = XaeroMinimapSession.getCurrentSession();
            if (minimapSession2 != null && modMain.getSettings().waypointsGUI(minimapSession2.getWaypointsManager())) {
                return new GuiWaypoints(modMain, minimapSession2, (Screen)this, (Screen)escape);
            }
            return null;
        }, null, minimapSession != null && modMain.getSettings().waypointsGUI(minimapSession.getWaypointsManager()));
        ArrayList mainEntriesBuilder = Lists.newArrayList((Object[])new ISettingEntry[]{new ConfigSettingEntry(ModOptions.MINIMAP), changePositionEntry, viewSettingsEntry, blockMapSettingsEntry, entityRadarSettingsEntry, overlaySettingsEntry, infoSettingsEntry, waypointSettingsEntry, miscSettingsEntry, waypointsEntry});
        if (modMain.isStandalone()) {
            mainEntriesBuilder.add(new ScreenSwitchSettingEntry("gui.xaero_reset_defaults", (current, escape) -> new GuiReset(this::resetConfirmResult, par1GuiScreen, (Screen)escape), null, true));
        }
        this.mainEntries = mainEntriesBuilder.toArray(new ISettingEntry[0]);
        LinkedHashSet<ISettingEntry> searchableEntriesBuilder = new LinkedHashSet<ISettingEntry>();
        for (ISettingEntry entry : this.mainEntries) {
            if (entry instanceof ScreenSwitchSettingEntry) {
                ScreenSwitchSettingEntry screenSwitchEntry = (ScreenSwitchSettingEntry)entry;
                Screen tempScreen = screenSwitchEntry.getScreenFactory().apply(this, this);
                if (tempScreen instanceof GuiSettings) {
                    GuiSettings tempSettingsScreen = (GuiSettings)tempScreen;
                    ISettingEntry[] settingsScreenEntries = tempSettingsScreen.getEntriesCopy();
                    if (settingsScreenEntries == null) continue;
                    searchableEntriesBuilder.addAll(Arrays.asList(settingsScreenEntries));
                    continue;
                }
                searchableEntriesBuilder.add(entry);
                continue;
            }
            searchableEntriesBuilder.add(entry);
        }
        this.searchableEntries = searchableEntriesBuilder.toArray(new ISettingEntry[0]);
    }

    @Override
    public void init() {
        this.entries = this.entryFilter.isEmpty() ? this.mainEntries : this.searchableEntries;
        super.init();
        if (ModSettings.serverSettings != ModSettings.defaultSettings) {
            this.screenTitle = Component.literal((String)("\u00a7e" + I18n.get((String)"gui.xaero_server_disabled", (Object[])new Object[0])));
        }
    }
}

