/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import java.io.IOException;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.gui.MySmallButton;
import xaero.common.gui.ScreenBase;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.hud.minimap.MinimapLogs;

public class GuiNewSet
extends ScreenBase {
    private EditBox nameTextField;
    private XaeroMinimapSession minimapSession;
    private WaypointsManager waypointsManager;
    private WaypointWorld waypointWorld;
    private Button confirmButton;

    public GuiNewSet(IXaeroMinimap modMain, XaeroMinimapSession minimapSession, Screen par1GuiScreen, WaypointWorld waypointWorld) {
        this(modMain, minimapSession, par1GuiScreen, null, waypointWorld);
    }

    public GuiNewSet(IXaeroMinimap modMain, XaeroMinimapSession minimapSession, Screen par1GuiScreen, Screen escapeScreen, WaypointWorld waypointWorld) {
        super(modMain, par1GuiScreen, escapeScreen, (Component)Component.translatable((String)"gui.xaero_create_set"));
        this.minimapSession = minimapSession;
        this.waypointsManager = minimapSession.getWaypointsManager();
        this.waypointWorld = waypointWorld;
        this.canSkipWorldRender = true;
    }

    @Override
    public void init() {
        super.init();
        this.nameTextField = new EditBox(this.font, this.width / 2 - 100, 60, 200, 20, (Component)Component.translatable((String)"gui.xaero_set_name"));
        this.setFocused((GuiEventListener)this.nameTextField);
        this.nameTextField.setFocused(true);
        this.addRenderableWidget((GuiEventListener)this.nameTextField);
        this.confirmButton = new MySmallButton(200, this.width / 2 - 155, this.height / 6 + 168, (Component)Component.translatable((String)"gui.xaero_confirm", (Object[])new Object[0]), b -> {
            if (this.canConfirm()) {
                String setName = this.nameTextField.getValue().replace(":", "\u00a7\u00a7");
                this.waypointWorld.setCurrent(setName);
                this.waypointWorld.addSet(setName);
                this.waypointsManager.updateWaypoints();
                try {
                    this.modMain.getSettings().saveWaypoints(this.waypointWorld);
                }
                catch (IOException e) {
                    MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
                }
                this.goBack();
            }
        });
        this.addRenderableWidget((GuiEventListener)this.confirmButton);
        this.addRenderableWidget((GuiEventListener)new MySmallButton(201, this.width / 2 + 5, this.height / 6 + 168, (Component)Component.translatable((String)"gui.xaero_cancel", (Object[])new Object[0]), b -> this.goBack()));
        this.updateConfirmButton();
    }

    protected void setInitialFocus() {
    }

    private boolean canConfirm() {
        return this.nameTextField.getValue().length() > 0 && this.waypointWorld.getSets().get(this.nameTextField.getValue()) == null;
    }

    private void updateConfirmButton() {
        this.confirmButton.active = this.canConfirm();
    }

    public boolean keyPressed(int par1, int par2, int par3) {
        boolean result = super.keyPressed(par1, par2, par3);
        if (par1 == 257 && this.canConfirm()) {
            this.confirmButton.onClick(0.0, 0.0);
            return true;
        }
        return result;
    }

    public void tick() {
        this.updateConfirmButton();
    }

    public void renderBackground(GuiGraphics guiGraphics, int par1, int par2, float par3) {
        super.renderBackground(guiGraphics, par1, par2, par3);
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 20, 0xFFFFFF);
        this.nameTextField.render(guiGraphics, par1, par2, par3);
    }

    @Override
    public void render(GuiGraphics guiGraphics, int par1, int par2, float par3) {
        this.renderEscapeScreen(guiGraphics, par1, par2, par3);
        super.render(guiGraphics, par1, par2, par3);
    }
}

