/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.radar.tracker;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import xaero.common.minimap.element.render.MinimapElementReader;
import xaero.common.minimap.radar.tracker.PlayerTrackerMinimapElement;
import xaero.common.minimap.radar.tracker.PlayerTrackerMinimapElementRenderContext;

public class PlayerTrackerMinimapElementReader
extends MinimapElementReader<PlayerTrackerMinimapElement<?>, PlayerTrackerMinimapElementRenderContext> {
    @Override
    public boolean isHidden(PlayerTrackerMinimapElement<?> element, PlayerTrackerMinimapElementRenderContext context) {
        return Minecraft.getInstance().level.dimension() != element.getDimension() && context.mapDimId != element.getDimension();
    }

    @Override
    public double getRenderX(PlayerTrackerMinimapElement<?> element, PlayerTrackerMinimapElementRenderContext context, float partialTicks) {
        if (Minecraft.getInstance().level.dimension() != element.getDimension()) {
            return element.getX() * context.mapDimDiv;
        }
        return element.getX();
    }

    @Override
    public double getRenderY(PlayerTrackerMinimapElement<?> element, PlayerTrackerMinimapElementRenderContext context, float partialTicks) {
        return element.getY();
    }

    @Override
    public double getRenderZ(PlayerTrackerMinimapElement<?> element, PlayerTrackerMinimapElementRenderContext context, float partialTicks) {
        if (Minecraft.getInstance().level.dimension() != element.getDimension()) {
            return element.getZ() * context.mapDimDiv;
        }
        return element.getZ();
    }

    @Override
    public int getInteractionBoxLeft(PlayerTrackerMinimapElement<?> element, PlayerTrackerMinimapElementRenderContext context, float partialTicks) {
        return -10;
    }

    @Override
    public int getInteractionBoxRight(PlayerTrackerMinimapElement<?> element, PlayerTrackerMinimapElementRenderContext context, float partialTicks) {
        return 10;
    }

    @Override
    public int getInteractionBoxTop(PlayerTrackerMinimapElement<?> element, PlayerTrackerMinimapElementRenderContext context, float partialTicks) {
        return -10;
    }

    @Override
    public int getInteractionBoxBottom(PlayerTrackerMinimapElement<?> element, PlayerTrackerMinimapElementRenderContext context, float partialTicks) {
        return 10;
    }

    @Override
    public int getRenderBoxLeft(PlayerTrackerMinimapElement<?> element, PlayerTrackerMinimapElementRenderContext context, float partialTicks) {
        return -20;
    }

    @Override
    public int getRenderBoxRight(PlayerTrackerMinimapElement<?> element, PlayerTrackerMinimapElementRenderContext context, float partialTicks) {
        return 20;
    }

    @Override
    public int getRenderBoxTop(PlayerTrackerMinimapElement<?> element, PlayerTrackerMinimapElementRenderContext context, float partialTicks) {
        return -20;
    }

    @Override
    public int getRenderBoxBottom(PlayerTrackerMinimapElement<?> element, PlayerTrackerMinimapElementRenderContext context, float partialTicks) {
        return 20;
    }

    @Override
    public int getLeftSideLength(PlayerTrackerMinimapElement<?> element, Minecraft mc) {
        PlayerInfo info = Minecraft.getInstance().getConnection().getPlayerInfo(element.getPlayerId());
        if (info == null) {
            return 9;
        }
        return 9 + mc.font.width(info.getProfile().getName());
    }

    @Override
    public String getMenuName(PlayerTrackerMinimapElement<?> element) {
        PlayerInfo info = Minecraft.getInstance().getConnection().getPlayerInfo(element.getPlayerId());
        if (info == null) {
            return String.valueOf(element.getPlayerId());
        }
        return info.getProfile().getName();
    }

    @Override
    public String getFilterName(PlayerTrackerMinimapElement<?> element) {
        return this.getMenuName(element);
    }

    @Override
    public int getMenuTextFillLeftPadding(PlayerTrackerMinimapElement<?> element) {
        return 0;
    }

    @Override
    public int getRightClickTitleBackgroundColor(PlayerTrackerMinimapElement<?> element) {
        return -11184641;
    }

    @Override
    public boolean shouldScaleBoxWithOptionalScale() {
        return true;
    }

    @Override
    public boolean isInteractable(int location, PlayerTrackerMinimapElement<?> element) {
        return true;
    }
}

