/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render.radar;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.FastColor;
import org.lwjgl.opengl.GL11;
import xaero.common.IXaeroMinimap;
import xaero.common.graphics.CustomRenderTypes;
import xaero.common.minimap.render.radar.ModelPartRenderDetectionInfo;
import xaero.common.minimap.render.radar.ModelRenderDetectionElement;
import xaero.common.misc.Misc;
import xaero.hud.minimap.MinimapLogs;

public class EntityIconModelPartsRenderer {
    public Method ageableModelHeadPartsMethod;
    public Method ageableModelBodyPartsMethod;
    public Method segmentedModelPartsMethod;
    private Field cubeListField;
    private Field childModelsField;
    private VertexConsumerWrapper vertexConsumerWrapper;
    private boolean testedRenderEngineWrapperCompatibility;
    private boolean renderEngineIsWrapperCompatible;
    private IXaeroMinimap modMain;

    public EntityIconModelPartsRenderer(IXaeroMinimap modMain) {
        this.modMain = modMain;
        this.ageableModelHeadPartsMethod = Misc.getMethodReflection(AgeableListModel.class, "headParts", "method_22946", "()Ljava/lang/Iterable;", "m_5607_", new Class[0]);
        this.ageableModelBodyPartsMethod = Misc.getMethodReflection(AgeableListModel.class, "bodyParts", "method_22948", "()Ljava/lang/Iterable;", "m_5608_", new Class[0]);
        this.segmentedModelPartsMethod = Misc.getMethodReflection(ListModel.class, "parts", "method_22960", "()Ljava/lang/Iterable;", "m_6195_", new Class[0]);
        this.cubeListField = Misc.getFieldReflection(ModelPart.class, "cubes", "field_3663", "Ljava/util/List;", "f_104212_");
        this.childModelsField = Misc.getFieldReflection(ModelPart.class, "children", "field_3661", "Ljava/util/Map;", "f_104213_");
        this.vertexConsumerWrapper = new VertexConsumerWrapper();
    }

    private List<ModelPart.Cube> getCubeList(ModelPart modelRenderer) {
        return (List)Misc.getReflectFieldValue(modelRenderer, this.cubeListField);
    }

    public Map<String, ModelPart> getChildModels(ModelPart modelRenderer) {
        return (Map)Misc.getReflectFieldValue(modelRenderer, this.childModelsField);
    }

    public boolean hasDirectCubes(ModelPart mr) {
        List<ModelPart.Cube> mrCubeList = this.getCubeList(mr);
        return mrCubeList != null && !mrCubeList.isEmpty();
    }

    public boolean hasCubes(ModelPart mr) {
        if (this.hasDirectCubes(mr)) {
            return true;
        }
        Map<String, ModelPart> mrChildren = this.getChildModels(mr);
        for (ModelPart child : mrChildren.values()) {
            if (!this.hasCubes(child)) continue;
            return true;
        }
        return false;
    }

    public void renderPart(PoseStack matrixStack, VertexConsumer vertexBuilder, ModelPart mr, ArrayList<ModelPart> renderedModels, ModelPart mainModelPart, boolean zeroRotation, ModelRenderDetectionElement mrde) {
        if (mr == null) {
            return;
        }
        if (renderedModels.contains(mr)) {
            return;
        }
        ModelPartRenderDetectionInfo renderInfo = mrde.getModelPartRenderInfo(mr);
        if (renderInfo == null) {
            return;
        }
        if (!this.hasCubes(mr)) {
            return;
        }
        boolean showModelBU = mr.visible;
        boolean skipDrawBU = mr.skipDraw;
        if (!this.testedRenderEngineWrapperCompatibility) {
            boolean normalWorks;
            block17: {
                normalWorks = false;
                try {
                    PoseStack testMatrix = new PoseStack();
                    testMatrix.translate(0.0f, 0.0f, -2500.0f);
                    VertexConsumer actualVertexConsumer = this.modMain.getHudRenderer().getCustomVertexConsumers().getBetterPVPRenderTypeBuffers().getBuffer(CustomRenderTypes.entityIconRenderType(mrde.renderTexture, mrde.layerPhases));
                    mr.render(testMatrix, actualVertexConsumer, 0xF000F0, OverlayTexture.NO_OVERLAY, renderInfo.color);
                    normalWorks = true;
                    testMatrix = new PoseStack();
                    testMatrix.translate(0.0f, 0.0f, -2500.0f);
                    this.vertexConsumerWrapper.prepareDetection(actualVertexConsumer, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
                    mr.visible = true;
                    mr.skipDraw = false;
                    mr.render(testMatrix, (VertexConsumer)this.vertexConsumerWrapper, 0xF000F0, OverlayTexture.NO_OVERLAY, renderInfo.color);
                    this.renderEngineIsWrapperCompatible = this.vertexConsumerWrapper.detectedVertex;
                    if (!this.renderEngineIsWrapperCompatible) {
                        throw new Exception("can't detect vertices");
                    }
                }
                catch (Throwable t) {
                    if (!normalWorks) break block17;
                    MinimapLogs.LOGGER.warn("Render engine used for entities is not fully compatible with the minimap entity icons. Using fallback. " + t.getMessage());
                }
            }
            if (normalWorks) {
                this.testedRenderEngineWrapperCompatibility = true;
            }
        }
        float centerPointX = mainModelPart.x;
        float centerPointY = mainModelPart.y;
        float centerPointZ = mainModelPart.z;
        List<ModelPart.Cube> mainCubeList = this.getCubeList(mainModelPart);
        if (mainCubeList != null && !mainCubeList.isEmpty()) {
            float biggestSize = 0.0f;
            ModelPart.Cube biggestCuboid = null;
            for (ModelPart.Cube cuboid : mainCubeList) {
                float size = Math.abs((cuboid.maxX - cuboid.minX) * (cuboid.maxY - cuboid.minY) * (cuboid.maxZ - cuboid.minZ));
                if (!(size >= biggestSize)) continue;
                biggestCuboid = cuboid;
                biggestSize = size;
            }
            centerPointY += (biggestCuboid.maxY + biggestCuboid.minY) / 2.0f;
            centerPointZ += (biggestCuboid.maxZ + biggestCuboid.minZ) / 2.0f;
        }
        float xRotBU = 0.0f;
        float yRotBU = 0.0f;
        float zRotBU = 0.0f;
        if (zeroRotation) {
            xRotBU = mr.xRot;
            yRotBU = mr.yRot;
            zRotBU = mr.zRot;
            PartPose initPose = mr.getInitialPose();
            mr.setRotation(initPose.xRot, initPose.yRot, initPose.zRot);
        }
        mr.visible = true;
        mr.skipDraw = false;
        float xBU = mr.x;
        float yBU = mr.y;
        float zBU = mr.z;
        mr.setPos(mr.x - centerPointX, mr.y - centerPointY, mr.z - centerPointZ);
        try {
            VertexConsumer vertexConsumer = !this.renderEngineIsWrapperCompatible ? vertexBuilder : this.vertexConsumerWrapper.prepareDetection(vertexBuilder, 3.0, 61.0, 3.0, 61.0, -497.0, -2.0);
            mr.render(matrixStack, vertexConsumer, 0xF000F0, OverlayTexture.NO_OVERLAY, renderInfo.color);
            if ((!this.renderEngineIsWrapperCompatible || this.vertexConsumerWrapper.hasDetectedVertex()) && FastColor.ARGB32.alpha((int)renderInfo.color) > 0) {
                renderedModels.add(mr);
            }
        }
        catch (Throwable t) {
            MinimapLogs.LOGGER.info("Exception when rendering entity part. " + String.valueOf(mr) + " " + t.getMessage());
        }
        mr.setPos(xBU, yBU, zBU);
        while (GL11.glGetError() != 0) {
        }
        if (zeroRotation) {
            mr.setRotation(xRotBU, yRotBU, zRotBU);
        }
        mr.visible = showModelBU;
        mr.skipDraw = skipDrawBU;
    }

    public ModelPart renderDeclaredMethod(PoseStack matrixStack, VertexConsumer vertexBuilder, Method m, EntityModel entityModel, ArrayList<ModelPart> renderedModels, ModelPart mainPart, boolean zeroRotation, ModelRenderDetectionElement mrde) {
        Iterable<ModelPart> renderers = this.handleDeclaredMethod(m, entityModel);
        return this.renderPartsIterable(renderers, matrixStack, vertexBuilder, renderedModels, mainPart, zeroRotation, mrde);
    }

    public Iterable<ModelPart> handleDeclaredMethod(Method m, EntityModel entityModel) {
        if (m != null) {
            return (Iterable)Misc.getReflectMethodValue(entityModel, m, new Object[0]);
        }
        return null;
    }

    public ModelPart renderPartsIterable(Iterable<ModelPart> parts, PoseStack matrixStack, VertexConsumer vertexBuilder, ArrayList<ModelPart> renderedModels, ModelPart mainPart, boolean zeroRotation, ModelRenderDetectionElement mrde) {
        if (parts == null) {
            return mainPart;
        }
        Iterator<ModelPart> partsIterator = parts.iterator();
        if (partsIterator.hasNext()) {
            if (mainPart == null) {
                mainPart = partsIterator.next();
                this.renderPart(matrixStack, vertexBuilder, mainPart, renderedModels, mainPart, zeroRotation, mrde);
            }
            while (partsIterator.hasNext()) {
                this.renderPart(matrixStack, vertexBuilder, partsIterator.next(), renderedModels, mainPart, zeroRotation, mrde);
            }
        }
        return mainPart;
    }

    public static class VertexConsumerWrapper
    implements VertexConsumer {
        private VertexConsumer consumer;
        private boolean detectedVertex;
        private double detectionMinX;
        private double detectionMaxX;
        private double detectionMinY;
        private double detectionMaxY;
        private double detectionMinZ;
        private double detectionMaxZ;

        public VertexConsumerWrapper prepareDetection(VertexConsumer consumer, double detectionMinX, double detectionMaxX, double detectionMinY, double detectionMaxY, double detectionMinZ, double detectionMaxZ) {
            this.consumer = consumer;
            this.detectionMinX = detectionMinX;
            this.detectionMaxX = detectionMaxX;
            this.detectionMinY = detectionMinY;
            this.detectionMaxY = detectionMaxY;
            this.detectionMinZ = detectionMinZ;
            this.detectionMaxZ = detectionMaxZ;
            this.detectedVertex = false;
            return this;
        }

        public VertexConsumer addVertex(float d, float e, float f) {
            if ((double)d >= this.detectionMinX && (double)d <= this.detectionMaxX && (double)e >= this.detectionMinY && (double)e <= this.detectionMaxY && (double)f >= this.detectionMinZ && (double)f <= this.detectionMaxZ) {
                this.detectedVertex = true;
            }
            return this.consumer.addVertex(d, e, f);
        }

        public VertexConsumer setColor(int i, int j, int k, int l) {
            return this.consumer.setColor(i, j, k, l);
        }

        public VertexConsumer setUv(float f, float g) {
            return this.consumer.setUv(f, g);
        }

        public VertexConsumer setUv1(int var1, int var2) {
            return this.consumer.setUv1(var1, var2);
        }

        public VertexConsumer setOverlay(int i) {
            return this.consumer.setOverlay(i);
        }

        public VertexConsumer setUv2(int i, int j) {
            return this.consumer.setUv2(i, j);
        }

        public VertexConsumer setNormal(float f, float g, float h) {
            return this.consumer.setNormal(f, g, h);
        }

        public boolean hasDetectedVertex() {
            return this.detectedVertex;
        }
    }
}

