/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render.radar;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexSorting;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SpriteCoordinateExpander;
import net.minecraft.client.renderer.entity.EnderDragonRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import org.apache.logging.log4j.Logger;
import org.joml.Matrix4f;
import org.joml.Vector3fc;
import org.lwjgl.opengl.GL11;
import xaero.common.IXaeroMinimap;
import xaero.common.core.IBufferSource;
import xaero.common.exception.OpenGLException;
import xaero.common.graphics.CustomRenderTypes;
import xaero.common.graphics.ImprovedFramebuffer;
import xaero.common.icon.XaeroIcon;
import xaero.common.icon.XaeroIconAtlas;
import xaero.common.icon.XaeroIconAtlasManager;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.minimap.render.radar.EntityIconDefinitions;
import xaero.common.minimap.render.radar.EntityIconManager;
import xaero.common.minimap.render.radar.EntityIconModelFieldResolver;
import xaero.common.minimap.render.radar.EntityIconModelPartsRenderer;
import xaero.common.minimap.render.radar.LivingEntityRotationResetter;
import xaero.common.minimap.render.radar.ModelRenderDetectionElement;
import xaero.common.minimap.render.radar.ResolvedFieldModelPartsRenderer;
import xaero.common.minimap.render.radar.ResolvedFieldModelRootPathListener;
import xaero.common.minimap.render.radar.custom.EntityIconCustomRenderer;
import xaero.common.minimap.render.radar.resource.EntityIconModelConfig;
import xaero.common.misc.Misc;
import xaero.common.misc.OptimizedMath;
import xaero.hud.minimap.MinimapLogs;

public class EntityIconPrerenderer {
    private static final int PREFERRED_ATLAS_WIDTH = 1024;
    public static final int ICON_WIDTH = 64;
    public static final int FAR_PLANE = 500;
    private static final Object[] ONE_RENDERER_ARRAY = new Object[1];
    private static final Object[] ONE_OBJECT_ARRAY = new Object[1];
    private static final boolean TEST_ALL_FIELDS = false;
    private static ArrayList<String> failedFields = new ArrayList();
    private final IXaeroMinimap modMain;
    private ImprovedFramebuffer modelRenderFramebuffer;
    private ImprovedFramebuffer iconRenderFramebuffer;
    private ImprovedFramebuffer atlasRenderFramebuffer;
    private EntityIconModelPartsRenderer entityModelPartsRenderer;
    private ResolvedFieldModelPartsRenderer modelPartsFieldResolverListener;
    private ResolvedFieldModelRootPathListener resolvedFieldModelRootPathListener;
    private LivingEntityRotationResetter livingEntityRotationResetter;
    private final XaeroIconAtlasManager iconAtlasManager;
    private MultiBufferSource.BufferSource entityIconRenderTypeBuffer = MultiBufferSource.immediate((ByteBufferBuilder)new ByteBufferBuilder(256));
    public static boolean DETECTING_MODEL_RENDERS;
    private Entity modelRenderDetectionEntity;
    private EntityRenderer modelRenderDetectionEntityRenderer;
    private Class<?> modelRenderDetectionEntityModelClass;
    private List<ModelRenderDetectionElement> modelRenderDetectionList;
    private ModelRenderDetectionElement lastModelRenderDetected;
    private MultiBufferSource.BufferSource modelRenderDetectionRenderTypeBuffer;
    private Class<?> renderTypeTypeClass;
    private Field enderDragonModelField;
    private Field renderStateField;
    private Class<?> renderPhaseTextureClass;
    private Field renderStateTextureStateField;
    private Field renderStateTextureStateTextureField;
    private Field renderStateDepthTestStateField;
    private Field renderStateWriteMaskStateField;
    private Field renderStateCullStateField;
    private Field renderStateTransparencyStateField;
    private Field renderStateShaderStateField;
    private Field vanillaEntityVertexConsumersField;
    private Field spriteCoordinateExpanderSpriteField;
    private Class<?> irisRenderLayerWrapperClass;
    private Method irisRenderLayerWrapperUnwrapMethod;

    public EntityIconPrerenderer(IXaeroMinimap modMain) {
        this.modMain = modMain;
        this.modelRenderFramebuffer = new ImprovedFramebuffer(512, 512, true);
        OpenGLException.checkGLError();
        this.iconRenderFramebuffer = new ImprovedFramebuffer(512, 512, false);
        OpenGLException.checkGLError();
        this.entityModelPartsRenderer = new EntityIconModelPartsRenderer(modMain);
        this.livingEntityRotationResetter = new LivingEntityRotationResetter();
        this.modelRenderFramebuffer.bindRead();
        OpenGLException.checkGLError();
        GL11.glTexParameteri((int)3553, (int)33085, (int)0);
        GL11.glTexParameterf((int)3553, (int)33082, (float)0.0f);
        GL11.glTexParameterf((int)3553, (int)33083, (float)0.0f);
        GL11.glTexParameterf((int)3553, (int)34049, (float)0.0f);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        GlStateManager._texImage2D((int)3553, (int)0, (int)32856, (int)this.modelRenderFramebuffer.viewWidth, (int)this.modelRenderFramebuffer.viewHeight, (int)0, (int)32993, (int)32821, (IntBuffer)null);
        OpenGLException.checkGLError();
        GlStateManager._bindTexture((int)0);
        this.iconRenderFramebuffer.bindRead();
        GL11.glTexParameteri((int)3553, (int)33085, (int)3);
        GL11.glTexParameterf((int)3553, (int)33082, (float)0.0f);
        GL11.glTexParameterf((int)3553, (int)33083, (float)3.0f);
        GL11.glTexParameterf((int)3553, (int)34049, (float)0.0f);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9984);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        GlStateManager._texImage2D((int)3553, (int)0, (int)32856, (int)this.iconRenderFramebuffer.viewWidth, (int)this.iconRenderFramebuffer.viewHeight, (int)0, (int)32993, (int)32821, (IntBuffer)null);
        OpenGLException.checkGLError();
        GlStateManager._bindTexture((int)0);
        this.modelRenderDetectionList = new ArrayList<ModelRenderDetectionElement>();
        this.enderDragonModelField = Misc.getFieldReflection(EnderDragonRenderer.class, "model", "field_21008", "Lnet/minecraft/class_895$class_625;", "f_114183_");
        try {
            this.renderTypeTypeClass = Misc.getClassForName("net.minecraft.class_1921$class_4687", "net.minecraft.client.renderer.RenderType$CompositeRenderType");
            this.renderStateField = Misc.getFieldReflection(this.renderTypeTypeClass, "state", "field_21403", "Lnet/minecraft/class_1921$class_4688;", "f_110511_");
        }
        catch (ClassNotFoundException e2) {
            throw new RuntimeException(e2);
        }
        try {
            Class<?> multiPhaseParametersClass = Misc.getClassForName("net.minecraft.class_1921$class_4688", "net.minecraft.client.renderer.RenderType$CompositeState");
            this.renderPhaseTextureClass = Misc.getClassForName("net.minecraft.class_4668$class_4683", "net.minecraft.client.renderer.RenderStateShard$TextureStateShard");
            this.renderStateTextureStateField = Misc.getFieldReflection(multiPhaseParametersClass, "textureState", "field_21406", "Lnet/minecraft/class_4668$class_5939;", "f_110576_");
            this.renderStateTextureStateTextureField = Misc.getFieldReflection(this.renderPhaseTextureClass, "texture", "field_21397", "Ljava/util/Optional;", "f_110328_");
            this.renderStateTransparencyStateField = Misc.getFieldReflection(multiPhaseParametersClass, "transparencyState", "field_21407", "Lnet/minecraft/class_4668$class_4685;", "f_110577_");
            this.renderStateDepthTestStateField = Misc.getFieldReflection(multiPhaseParametersClass, "depthTestState", "field_21411", "Lnet/minecraft/class_4668$class_4672;", "f_110581_");
            this.renderStateWriteMaskStateField = Misc.getFieldReflection(multiPhaseParametersClass, "writeMaskState", "field_21419", "Lnet/minecraft/class_4668$class_4686;", "f_110589_");
            this.renderStateCullStateField = Misc.getFieldReflection(multiPhaseParametersClass, "cullState", "field_21412", "Lnet/minecraft/class_4668$class_4671;", "f_110582_");
            this.renderStateShaderStateField = Misc.getFieldReflection(multiPhaseParametersClass, "shaderState", "field_29461", "Lnet/minecraft/class_4668$class_5942;", "f_173274_");
        }
        catch (ClassNotFoundException e2) {
            throw new RuntimeException(e2);
        }
        this.vanillaEntityVertexConsumersField = Misc.getFieldReflection(RenderBuffers.class, "bufferSource", "field_46901", "Lnet/minecraft/class_4597$class_4598;", "f_110094_");
        this.spriteCoordinateExpanderSpriteField = Misc.getFieldReflection(SpriteCoordinateExpander.class, "sprite", "field_21731", "Lnet/minecraft/class_1058;", "f_110796_");
        try {
            try {
                this.irisRenderLayerWrapperClass = Class.forName("net.coderbot.iris.layer.IrisRenderTypeWrapper");
            }
            catch (ClassNotFoundException e) {
                this.irisRenderLayerWrapperClass = Class.forName("net.coderbot.iris.layer.IrisRenderLayerWrapper");
            }
            this.irisRenderLayerWrapperUnwrapMethod = Misc.getMethodReflection(this.irisRenderLayerWrapperClass, "unwrap", "unwrap", "()Lnet/minecraft/class_1921;", "unwrap", new Class[0]);
            MinimapLogs.LOGGER.info("Old Iris!");
        }
        catch (Exception e) {
            // empty catch block
        }
        this.modelPartsFieldResolverListener = new ResolvedFieldModelPartsRenderer();
        this.resolvedFieldModelRootPathListener = new ResolvedFieldModelRootPathListener();
        int maxTextureSize = GlStateManager._getInteger((int)3379);
        int atlasTextureSize = Math.min(maxTextureSize, 1024) / 64 * 64;
        this.iconAtlasManager = new XaeroIconAtlasManager(64, atlasTextureSize, new ArrayList<XaeroIconAtlas>());
        this.atlasRenderFramebuffer = new ImprovedFramebuffer(atlasTextureSize, atlasTextureSize, false);
        OpenGLException.checkGLError();
        GlStateManager._deleteTexture((int)this.atlasRenderFramebuffer.getFramebufferTexture());
        OpenGLException.checkGLError();
    }

    void clearAtlases() {
        this.iconAtlasManager.clearAtlases();
        this.atlasRenderFramebuffer.setFramebufferTexture(0);
    }

    private XaeroIconAtlas getCurrentAtlas() throws Exception {
        return this.iconAtlasManager.getCurrentAtlas();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void testField(ImmutableList<String> fields) throws NoSuchFieldException, SecurityException {
        boolean odd = true;
        boolean pairFirstFailed = false;
        String prevS = null;
        UnmodifiableIterator unmodifiableIterator = fields.iterator();
        while (unmodifiableIterator.hasNext()) {
            String s = (String)unmodifiableIterator.next();
            try {
                boolean bl = odd = !odd;
                if (!odd) {
                    pairFirstFailed = false;
                }
                boolean failed = false;
                if (!s.isEmpty()) {
                    String[] fieldArgs = s.split(";");
                    Class<?> c = null;
                    try {
                        c = Class.forName(fieldArgs[0]);
                    }
                    catch (ClassNotFoundException cnfe) {
                        MinimapLogs.LOGGER.info("Skipping testing a class: " + fieldArgs[0]);
                        prevS = s;
                        continue;
                    }
                    try {
                        c.getDeclaredField(fieldArgs[1]);
                    }
                    catch (Exception e) {
                        failed = true;
                    }
                } else {
                    failed = true;
                }
                if (failed) {
                    if (!odd) {
                        pairFirstFailed = true;
                    } else if (pairFirstFailed) {
                        failedFields.add(prevS);
                        failedFields.add(s);
                    }
                }
                prevS = s;
            }
            catch (Throwable throwable) {
                prevS = s;
                throw throwable;
            }
        }
        return;
    }

    public XaeroIcon prerender(GuiGraphics guiGraphics, Object variant, EntityRenderer entityRenderer, Entity entity, RenderTarget defaultFramebuffer, MinimapRendererHelper helper, float scale, EntityIconModelConfig modelConfig, EntityIconModelConfig defaultModelConfig, ResourceLocation readySprite, boolean outlined, boolean flipped, boolean debug) {
        boolean renderedSomething;
        ImprovedFramebuffer modelRenderFramebuffer = this.modelRenderFramebuffer;
        ImprovedFramebuffer iconRenderFramebuffer = this.iconRenderFramebuffer;
        OpenGLException.checkGLError();
        PoseStack matrixStack = guiGraphics.pose();
        modelRenderFramebuffer.bindWrite(true);
        this.setupMatrices(matrixStack, 64, 500);
        OpenGLException.checkGLError();
        if (readySprite == null) {
            LivingEntity livingEntity;
            GlStateManager._enableCull();
            if (Minecraft.getInstance().getEntityRenderDispatcher().camera != null) {
                DETECTING_MODEL_RENDERS = true;
                this.modelRenderDetectionEntity = entity;
                this.modelRenderDetectionEntityRenderer = entityRenderer;
                this.modelRenderDetectionEntityModelClass = null;
                this.modelRenderDetectionList.clear();
                this.lastModelRenderDetected = null;
                PoseStack.Pose matrixEntryToRestore = matrixStack.last();
                matrixStack.pushPose();
                try {
                    MultiBufferSource.BufferSource renderTypeBuffer = this.modelRenderDetectionRenderTypeBuffer = (MultiBufferSource.BufferSource)Misc.getReflectFieldValue(Minecraft.getInstance().renderBuffers(), this.vanillaEntityVertexConsumersField);
                    entityRenderer.render(entity, 0.0f, 1.0f, matrixStack, (MultiBufferSource)renderTypeBuffer, 0xF000F0);
                    renderTypeBuffer.endBatch();
                    OpenGLException.checkGLError();
                }
                catch (Throwable e) {
                    this.modelRenderDetectionList.clear();
                    MinimapLogs.LOGGER.error("Exception when calling the full entity renderer before rendering the icon. " + entity.getScoreboardName(), e);
                }
                modelRenderFramebuffer.bindWrite(true);
                DETECTING_MODEL_RENDERS = false;
                this.modelRenderDetectionEntity = null;
                this.modelRenderDetectionEntityRenderer = null;
                while (matrixStack.last() != matrixEntryToRestore) {
                    matrixStack.popPose();
                }
                while (GL11.glGetError() != 0) {
                }
            } else {
                MinimapLogs.LOGGER.info("Render info was null for entity " + entity.getScoreboardName());
            }
            MultiBufferSource.BufferSource renderTypeBuffer = this.entityIconRenderTypeBuffer;
            EntityModel entityModel = this.getEntityRendererModel(entityRenderer);
            if (entityModel == null) {
                this.endModelRendering(modelRenderFramebuffer);
                this.bindDefaultFramebuffer(defaultFramebuffer);
                this.restoreMatrices(matrixStack, helper, defaultFramebuffer);
                return EntityIconManager.FAILED;
            }
            GlStateManager._disableBlend();
            GlStateManager._clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GlStateManager._clear((int)16640, (boolean)Minecraft.ON_OSX);
            GlStateManager._enableBlend();
            GlStateManager._disableDepthTest();
            GlStateManager._enableCull();
            GlStateManager._depthFunc((int)515);
            Lighting.setupForFlatItems();
            if (debug) {
                matrixStack.pushPose();
                matrixStack.translate(0.0f, 10.0f, -10.0f);
                matrixStack.scale(1.0f, -1.0f, 1.0f);
                guiGraphics.fill(0, 0, 9, 9, -65536);
                matrixStack.popPose();
                GlStateManager._enableBlend();
                RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
            }
            PoseStack.Pose matrixEntryToRestore = matrixStack.last();
            matrixStack.pushPose();
            matrixStack.translate(32.0f, 32.0f, -450.0f);
            matrixStack.translate(modelConfig.offsetX, -modelConfig.offsetY, 0.0f);
            int mainScale = 32;
            matrixStack.scale((float)mainScale, (float)(-mainScale), (float)(-mainScale));
            if (scale < 1.0f) {
                matrixStack.scale(scale, scale, scale);
            }
            matrixStack.scale(modelConfig.baseScale, modelConfig.baseScale, modelConfig.baseScale);
            OptimizedMath.rotatePose(matrixStack, modelConfig.rotationY, (Vector3fc)OptimizedMath.YP);
            OptimizedMath.rotatePose(matrixStack, modelConfig.rotationX, (Vector3fc)OptimizedMath.XP);
            OptimizedMath.rotatePose(matrixStack, modelConfig.rotationZ, (Vector3fc)OptimizedMath.ZP);
            EntityIconDefinitions.customTransformation(matrixStack, entityModel, entity, this);
            LivingEntity livingEntity2 = livingEntity = entity instanceof LivingEntity ? (LivingEntity)entity : null;
            if (livingEntity != null) {
                this.livingEntityRotationResetter.rememberAndResetValues(livingEntity);
            }
            renderedSomething = this.renderIcon(matrixStack, renderTypeBuffer, entityRenderer, entityModel, this.modelRenderDetectionList, entity, modelConfig, defaultModelConfig);
            if (livingEntity != null) {
                this.livingEntityRotationResetter.restore(livingEntity);
            }
            EntityIconDefinitions.customPostRenderTransformation(matrixStack, entityModel, entity);
            while (matrixStack.last() != matrixEntryToRestore) {
                matrixStack.popPose();
            }
            if (debug) {
                matrixStack.pushPose();
                matrixStack.translate(9.0f, 10.0f, -10.0f);
                matrixStack.scale(1.0f, -1.0f, 1.0f);
                guiGraphics.fill(0, 0, 9, 9, -16711936);
                matrixStack.popPose();
                RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
            }
        } else {
            matrixStack.pushPose();
            GlStateManager._disableBlend();
            GlStateManager._clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GlStateManager._clear((int)16640, (boolean)Minecraft.ON_OSX);
            GlStateManager._enableBlend();
            GlStateManager._disableCull();
            Lighting.setupForFlatItems();
            Minecraft.getInstance().getTextureManager().bindForSetup(readySprite);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
            GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
            matrixStack.translate(32.0f, 32.0f, 1.0f);
            if (scale < 1.0f) {
                matrixStack.scale(scale, scale, 1.0f);
            }
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)readySprite);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            helper.drawMyTexturedModalRect(matrixStack, -32.0f, -32.0f, 0, 0, 64.0f, 64.0f, 64.0f, 64.0f);
            GlStateManager._enableCull();
            matrixStack.popPose();
            renderedSomething = true;
        }
        this.endModelRendering(modelRenderFramebuffer);
        XaeroIcon icon = EntityIconManager.FAILED;
        if (renderedSomething) {
            iconRenderFramebuffer.bindWrite(true);
            GlStateManager._clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GlStateManager._clear((int)16384, (boolean)Minecraft.ON_OSX);
            GlStateManager._disableBlend();
            if (debug) {
                matrixStack.pushPose();
                matrixStack.translate(18.0f, 10.0f, -10.0f);
                matrixStack.scale(1.0f, -1.0f, 1.0f);
                guiGraphics.fill(0, 0, 9, 9, -16776961);
                matrixStack.popPose();
                RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
            }
            modelRenderFramebuffer.bindRead();
            RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager._enableBlend();
            RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)1);
            if (outlined) {
                for (int shadowOffsetX = -1; shadowOffsetX < 2; ++shadowOffsetX) {
                    for (int shadowOffsetY = -1; shadowOffsetY < 2; ++shadowOffsetY) {
                        if (shadowOffsetX == 0 && shadowOffsetY == 0) continue;
                        helper.drawIconOutline(matrixStack, shadowOffsetX, 64 + shadowOffsetY, 0, 0, 64.0f, -64.0f, 64.0f, 64.0f, 0.05f);
                    }
                }
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager._disableBlend();
            helper.drawMyTexturedModalRect(matrixStack, 0.0f, 64.0f, 0, 0, 64.0f, -64.0f, 64.0f, 64.0f, 0.05f, false);
            RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
            if (debug) {
                matrixStack.pushPose();
                matrixStack.translate(27.0f, 10.0f, -10.0f);
                matrixStack.scale(1.0f, -1.0f, 1.0f);
                guiGraphics.fill(0, 0, 9, 9, -16711681);
                matrixStack.popPose();
                RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
            }
            GlStateManager._enableBlend();
            iconRenderFramebuffer.unbindWrite();
            iconRenderFramebuffer.bindRead();
            iconRenderFramebuffer.generateMipmaps();
            GlStateManager._bindTexture((int)0);
            try {
                XaeroIconAtlas atlas = this.getCurrentAtlas();
                icon = atlas.createIcon();
                this.atlasRenderFramebuffer.bindWrite(false);
                GlStateManager._viewport((int)icon.getOffsetX(), (int)icon.getOffsetY(), (int)64, (int)64);
                this.atlasRenderFramebuffer.setFramebufferTexture(atlas.getTextureId());
                this.atlasRenderFramebuffer.checkStatus();
                iconRenderFramebuffer.bindRead();
                GlStateManager._disableBlend();
                if (flipped) {
                    helper.drawMyTexturedModalRect(matrixStack, 0.0f, 64.0f, 0, 64, 64.0f, -64.0f, -64.0f, 64.0f, -1.0f, false);
                } else {
                    helper.drawMyTexturedModalRect(matrixStack, 0.0f, 64.0f, 0, 0, 64.0f, -64.0f, 64.0f, 64.0f, -1.0f, false);
                }
                if (debug) {
                    matrixStack.pushPose();
                    matrixStack.translate(36.0f, 10.0f, -10.0f);
                    matrixStack.scale(1.0f, -1.0f, 1.0f);
                    guiGraphics.fill(0, 0, 9, 9, -256);
                    matrixStack.popPose();
                    RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
                }
            }
            catch (Throwable t) {
                MinimapLogs.LOGGER.error(String.format("Exception rendering to a entity icon atlas for %s %s!", EntityType.getKey((EntityType)entity.getType()), variant), t);
            }
            GlStateManager._enableBlend();
            GlStateManager._bindTexture((int)0);
            MinimapRendererHelper.restoreDefaultShaderBlendState();
        }
        this.restoreMatrices(matrixStack, helper, defaultFramebuffer);
        this.atlasRenderFramebuffer.unbindWrite();
        this.bindDefaultFramebuffer(defaultFramebuffer);
        return icon;
    }

    private void bindDefaultFramebuffer(RenderTarget defaultFramebuffer) {
        if (defaultFramebuffer != null) {
            defaultFramebuffer.bindWrite(true);
        } else {
            this.atlasRenderFramebuffer.bindDefaultFramebuffer(Minecraft.getInstance());
            GlStateManager._viewport((int)0, (int)0, (int)Minecraft.getInstance().getWindow().getWidth(), (int)Minecraft.getInstance().getWindow().getHeight());
        }
    }

    private void setupMatrices(PoseStack matrixStack, int finalIconSize, int farPlane) {
        matrixStack.pushPose();
        matrixStack.setIdentity();
        Matrix4f ortho = new Matrix4f().setOrtho(0.0f, (float)finalIconSize, 0.0f, (float)finalIconSize, -1.0f, (float)farPlane);
        RenderSystem.setProjectionMatrix((Matrix4f)ortho, (VertexSorting)VertexSorting.ORTHOGRAPHIC_Z);
        RenderSystem.getModelViewStack().pushMatrix();
        RenderSystem.getModelViewStack().identity();
        RenderSystem.applyModelViewMatrix();
    }

    private void restoreMatrices(PoseStack matrixStack, MinimapRendererHelper helper, RenderTarget framebuffer) {
        matrixStack.popPose();
        helper.defaultOrtho(framebuffer, false);
        RenderSystem.getModelViewStack().popMatrix();
        RenderSystem.applyModelViewMatrix();
    }

    private void endModelRendering(ImprovedFramebuffer modelRenderFramebuffer) {
        modelRenderFramebuffer.unbindWrite();
        GlStateManager._enableBlend();
        Lighting.setupFor3DItems();
        Lighting.setupForFlatItems();
    }

    private ModelPart renderModel(PoseStack matrixStack, MultiBufferSource.BufferSource renderTypeBuffer, EntityRenderer entityRenderer, EntityModel entityModel, Entity entity, EntityIconModelConfig modelConfig, EntityIconModelConfig defaultModelConfig, ModelPart mainPart, ArrayList<ModelPart> renderedModels, ResourceLocation entityTexture, TextureAtlasSprite entityAtlasSprite, boolean forceFieldCheck, boolean fullModelIcon, ModelRenderDetectionElement mrde, List<String> hardcodedMainPartAliases, List<String> hardcodedModelPartsFields) {
        boolean isChildBU = entityModel.young;
        entityModel.young = false;
        if (entityTexture != null) {
            ModelPart headPartTest;
            Iterator iterator;
            Iterable headPartsTest;
            Object modelRoot = null;
            if (modelConfig.modelRootPath != null) {
                modelRoot = this.resolveModelRoot(entityModel, modelConfig.modelRootPath, entity);
            }
            if (modelRoot == null) {
                modelRoot = EntityIconDefinitions.getModelRoot(entityRenderer, entityModel);
            }
            boolean treatAsHierarchicalRoot = false;
            if (modelConfig == defaultModelConfig && modelRoot instanceof AgeableListModel && !(modelRoot instanceof HumanoidModel) && (headPartsTest = (Iterable)Misc.getReflectMethodValue(modelRoot, this.entityModelPartsRenderer.ageableModelHeadPartsMethod, new Object[0])) != null && (iterator = headPartsTest.iterator()).hasNext() && (headPartTest = (ModelPart)iterator.next()) != null && !iterator.hasNext() && !this.entityModelPartsRenderer.hasDirectCubes(headPartTest)) {
                modelRoot = headPartTest;
                treatAsHierarchicalRoot = true;
                fullModelIcon = true;
            }
            VertexConsumer vertexBuilder = this.setupModelRenderType(renderTypeBuffer, entityTexture, entityAtlasSprite, mrde);
            if (modelConfig.modelMainPartFieldAliases != null && !modelConfig.modelMainPartFieldAliases.isEmpty()) {
                mainPart = this.searchSuperclassFields(matrixStack, vertexBuilder, modelRoot, renderedModels, mainPart, modelConfig.modelMainPartFieldAliases, true, modelConfig.modelPartsRotationReset, mrde);
            }
            if (!forceFieldCheck && modelRoot instanceof AgeableListModel) {
                if (modelRoot instanceof HumanoidModel) {
                    ModelPart headRenderer = ((HumanoidModel)modelRoot).head;
                    if (mainPart == null) {
                        mainPart = headRenderer;
                    }
                    ModelPart headWearRenderer = ((HumanoidModel)modelRoot).hat;
                    this.entityModelPartsRenderer.renderPart(matrixStack, vertexBuilder, headRenderer, renderedModels, mainPart, modelConfig.modelPartsRotationReset, mrde);
                    this.entityModelPartsRenderer.renderPart(matrixStack, vertexBuilder, headWearRenderer, renderedModels, mainPart, modelConfig.modelPartsRotationReset, mrde);
                }
                mainPart = this.entityModelPartsRenderer.renderDeclaredMethod(matrixStack, vertexBuilder, this.entityModelPartsRenderer.ageableModelHeadPartsMethod, (EntityModel)((AgeableListModel)modelRoot), renderedModels, mainPart, modelConfig.modelPartsRotationReset, mrde);
                if (fullModelIcon) {
                    mainPart = this.entityModelPartsRenderer.renderDeclaredMethod(matrixStack, vertexBuilder, this.entityModelPartsRenderer.ageableModelBodyPartsMethod, (EntityModel)((AgeableListModel)modelRoot), renderedModels, mainPart, modelConfig.modelPartsRotationReset, mrde);
                }
            } else {
                boolean singlePartSucceeded = false;
                if (!forceFieldCheck && (treatAsHierarchicalRoot || modelRoot instanceof HierarchicalModel)) {
                    ModelPart rootPart;
                    if (treatAsHierarchicalRoot) {
                        rootPart = (ModelPart)modelRoot;
                    } else {
                        HierarchicalModel singlePartModel = (HierarchicalModel)modelRoot;
                        rootPart = singlePartModel.root();
                    }
                    if (rootPart != null) {
                        ModelPart headPart;
                        try {
                            headPart = rootPart.getChild("head");
                        }
                        catch (NoSuchElementException nsee) {
                            headPart = null;
                        }
                        if (headPart != null) {
                            if (mainPart == null) {
                                mainPart = headPart;
                            }
                            this.entityModelPartsRenderer.renderPart(matrixStack, vertexBuilder, headPart, renderedModels, mainPart, modelConfig.modelPartsRotationReset, mrde);
                            singlePartSucceeded = true;
                        }
                        if (fullModelIcon) {
                            Map<String, ModelPart> rootChildren = this.entityModelPartsRenderer.getChildModels(rootPart);
                            mainPart = this.entityModelPartsRenderer.renderPartsIterable(rootChildren.values(), matrixStack, vertexBuilder, renderedModels, mainPart, modelConfig.modelPartsRotationReset, mrde);
                            singlePartSucceeded = true;
                        }
                    }
                }
                if (!singlePartSucceeded) {
                    if (!forceFieldCheck && modelRoot instanceof ListModel && fullModelIcon) {
                        mainPart = this.entityModelPartsRenderer.renderDeclaredMethod(matrixStack, vertexBuilder, this.entityModelPartsRenderer.segmentedModelPartsMethod, (EntityModel)((ListModel)modelRoot), renderedModels, mainPart, modelConfig.modelPartsRotationReset, mrde);
                    } else {
                        if (!forceFieldCheck && modelRoot instanceof HeadedModel) {
                            ModelPart headPart = ((HeadedModel)modelRoot).getHead();
                            if (mainPart == null) {
                                mainPart = headPart;
                            }
                            this.entityModelPartsRenderer.renderPart(matrixStack, vertexBuilder, headPart, renderedModels, mainPart, modelConfig.modelPartsRotationReset, mrde);
                        }
                        if (modelConfig.modelPartsFields == null) {
                            mainPart = this.searchSuperclassFields(matrixStack, vertexBuilder, modelRoot, renderedModels, mainPart, hardcodedMainPartAliases, true, modelConfig.modelPartsRotationReset, mrde);
                        }
                        List<String> headPartsFields = hardcodedModelPartsFields;
                        if (fullModelIcon) {
                            headPartsFields = null;
                        } else if (modelConfig.modelPartsFields != null) {
                            headPartsFields = modelConfig.modelPartsFields;
                        }
                        mainPart = this.searchSuperclassFields(matrixStack, vertexBuilder, modelRoot, renderedModels, mainPart, headPartsFields, false, modelConfig.modelPartsRotationReset, mrde);
                    }
                }
            }
            renderTypeBuffer.endBatch();
        }
        entityModel.young = isChildBU;
        return mainPart;
    }

    private VertexConsumer setupModelRenderType(MultiBufferSource.BufferSource renderTypeBuffer, ResourceLocation entityTexture, TextureAtlasSprite entityAtlasSprite, ModelRenderDetectionElement mrde) {
        VertexConsumer regularConsumer = renderTypeBuffer.getBuffer(CustomRenderTypes.entityIconRenderType(entityTexture, mrde.layerPhases));
        if (entityAtlasSprite != null) {
            return entityAtlasSprite.wrap(regularConsumer);
        }
        return regularConsumer;
    }

    public ModelPart searchSuperclassFields(PoseStack matrixStack, VertexConsumer vertexBuilder, Object modelRoot, ArrayList<ModelPart> renderedModels, ModelPart mainPart, List<String> filter, boolean justOne, boolean zeroRotation, ModelRenderDetectionElement mrde) {
        this.modelPartsFieldResolverListener.prepare(matrixStack, vertexBuilder, justOne, renderedModels, mainPart, zeroRotation, mrde, this.entityModelPartsRenderer);
        EntityIconModelFieldResolver.searchSuperclassFields(modelRoot, filter, this.modelPartsFieldResolverListener, ONE_RENDERER_ARRAY);
        return this.modelPartsFieldResolverListener.getMainPart();
    }

    public ModelPart handleFields(PoseStack matrixStack, VertexConsumer vertexBuilder, Object modelRoot, Field[] declaredModelFields, ArrayList<ModelPart> renderedModels, ModelPart mainPart, List<String> filter, boolean justOne, boolean zeroRotation, ModelRenderDetectionElement mrde) {
        this.modelPartsFieldResolverListener.prepare(matrixStack, vertexBuilder, justOne, renderedModels, mainPart, zeroRotation, mrde, this.entityModelPartsRenderer);
        EntityIconModelFieldResolver.handleFields(modelRoot, declaredModelFields, filter, this.modelPartsFieldResolverListener, ONE_RENDERER_ARRAY);
        return this.modelPartsFieldResolverListener.getMainPart();
    }

    public void generateMipmaps() {
        this.modelRenderFramebuffer.generateMipmaps();
    }

    public void onModelRenderDetection(EntityModel<?> model, VertexConsumer vertexConsumer, int color) {
        Object renderState;
        if (this.modelRenderDetectionEntityModelClass == null) {
            EntityModel currentMainModel = this.getEntityRendererModel(this.modelRenderDetectionEntityRenderer);
            Class<?> clazz = this.modelRenderDetectionEntityModelClass = currentMainModel == null ? null : currentMainModel.getClass();
        }
        if (!model.getClass().isAssignableFrom(this.modelRenderDetectionEntityModelClass) && !this.modelRenderDetectionEntityModelClass.isAssignableFrom(model.getClass())) {
            return;
        }
        RenderType lastRenderType = this.getLastRenderType((MultiBufferSource)this.modelRenderDetectionRenderTypeBuffer);
        if (lastRenderType == null && this.modelRenderDetectionList.isEmpty()) {
            ResourceLocation textureLocation = null;
            try {
                ResourceLocation textureLocationUnchecked;
                textureLocation = textureLocationUnchecked = this.modelRenderDetectionEntityRenderer.getTextureLocation(this.modelRenderDetectionEntity);
            }
            catch (Throwable t) {
                MinimapLogs.LOGGER.error("Couldn't fetch main entity texture when trying to use an alternative render type for an icon!", t);
            }
            if (textureLocation != null) {
                lastRenderType = model.renderType(textureLocation);
            }
        }
        if (lastRenderType != null && (renderState = this.getRenderState(lastRenderType)) != null) {
            int blendSrcFactor;
            Object renderTextureState = Misc.getReflectFieldValue(renderState, this.renderStateTextureStateField);
            ResourceLocation texture = this.renderPhaseTextureClass.isAssignableFrom(renderTextureState.getClass()) ? this.getRenderStateTextureStateTexture(renderTextureState) : null;
            Object renderTransparencyState = Misc.getReflectFieldValue(renderState, this.renderStateTransparencyStateField);
            ((RenderStateShard)renderTransparencyState).setupRenderState();
            int blendDestFactor = GL11.glGetInteger((int)32968);
            if (blendDestFactor == 1 && (blendSrcFactor = GL11.glGetInteger((int)32969)) != 0) {
                renderTransparencyState = CustomRenderTypes.getTransparencyPhase(blendSrcFactor, blendDestFactor, 0, 1);
            }
            ((RenderStateShard)renderTransparencyState).clearRenderState();
            Object renderDepthTestState = Misc.getReflectFieldValue(renderState, this.renderStateDepthTestStateField);
            Object renderWriteMaskState = Misc.getReflectFieldValue(renderState, this.renderStateWriteMaskStateField);
            Object renderCullState = Misc.getReflectFieldValue(renderState, this.renderStateCullStateField);
            Object renderShaderState = Misc.getReflectFieldValue(renderState, this.renderStateShaderStateField);
            CustomRenderTypes.EntityIconLayerPhases layerPhases = new CustomRenderTypes.EntityIconLayerPhases(renderTextureState, renderTransparencyState, renderDepthTestState, renderWriteMaskState, renderCullState, renderShaderState);
            TextureAtlasSprite renderAtlasSprite = null;
            if (vertexConsumer instanceof SpriteCoordinateExpander) {
                renderAtlasSprite = (TextureAtlasSprite)Misc.getReflectFieldValue(vertexConsumer, this.spriteCoordinateExpanderSpriteField);
            }
            this.lastModelRenderDetected = new ModelRenderDetectionElement(model, texture, renderAtlasSprite, layerPhases, color);
            this.modelRenderDetectionList.add(this.lastModelRenderDetected);
        }
    }

    public void onModelPartRenderDetection(ModelPart modelRenderer, int color) {
        if (this.lastModelRenderDetected != null) {
            this.lastModelRenderDetected.addVisibleModelPart(modelRenderer, color);
        }
    }

    private RenderType getLastRenderType(MultiBufferSource renderTypeBuffer) {
        if (renderTypeBuffer instanceof IBufferSource) {
            IBufferSource xaeroBufferSource = (IBufferSource)renderTypeBuffer;
            return xaeroBufferSource.getXaero_lastRenderType();
        }
        return null;
    }

    private Object getRenderState(RenderType renderType) {
        while (renderType.getClass() == this.irisRenderLayerWrapperClass && this.irisRenderLayerWrapperUnwrapMethod != null) {
            renderType = (RenderType)Misc.getReflectMethodValue(renderType, this.irisRenderLayerWrapperUnwrapMethod, new Object[0]);
        }
        if (renderType.getClass() == this.renderTypeTypeClass) {
            Object renderState = Misc.getReflectFieldValue(renderType, this.renderStateField);
            return renderState;
        }
        return null;
    }

    private ResourceLocation getRenderStateTextureStateTexture(Object renderTextureState) {
        Optional optional;
        Object renderStateTextureObject = Misc.getReflectFieldValue(renderTextureState, this.renderStateTextureStateTextureField);
        Object renderStateTexture = null;
        renderStateTexture = renderStateTextureObject instanceof Optional ? (!(optional = (Optional)renderStateTextureObject).isPresent() ? null : (ResourceLocation)optional.get()) : (ResourceLocation)renderStateTextureObject;
        return renderStateTexture;
    }

    private boolean renderIcon(PoseStack matrixStack, MultiBufferSource.BufferSource renderTypeBuffer, EntityRenderer entityRenderer, EntityModel mainEntityModel, List<ModelRenderDetectionElement> detectedModels, Entity entity, EntityIconModelConfig modelConfig, EntityIconModelConfig defaultModelConfig) {
        EntityIconCustomRenderer extraLayer;
        boolean forceFieldCheck;
        boolean bl = forceFieldCheck = !(modelConfig.renderingFullModel != null && modelConfig.renderingFullModel != false || modelConfig.modelPartsFields == null && !EntityIconDefinitions.forceFieldCheck(mainEntityModel));
        boolean fullModelIcon = modelConfig.renderingFullModel == null ? !forceFieldCheck && EntityIconDefinitions.fullModelIcon(mainEntityModel) : modelConfig.renderingFullModel;
        ModelPart mainPart = null;
        boolean renderedSomething = false;
        ArrayList<ModelPart> mainRenderedModels = new ArrayList<ModelPart>();
        if (detectedModels.isEmpty()) {
            ResourceLocation mainEntityTexture = null;
            try {
                ResourceLocation mainEntityTextureUnchecked;
                mainEntityTexture = mainEntityTextureUnchecked = entityRenderer.getTextureLocation(entity);
            }
            catch (Throwable t) {
                MinimapLogs.LOGGER.error("Couldn't fetch main entity texture when prerendering an icon with nothing detected!", t);
            }
            if (mainEntityTexture != null) {
                detectedModels.add(new ModelRenderDetectionElement(mainEntityModel, mainEntityTexture, null, CustomRenderTypes.getBasicEntityIconLayerPhases(mainEntityTexture), -1));
            }
        }
        boolean allEmpty = true;
        for (ModelRenderDetectionElement mrde : detectedModels) {
            if (mrde.isEmpty()) continue;
            allEmpty = false;
            break;
        }
        if (allEmpty) {
            for (ModelRenderDetectionElement mrde : detectedModels) {
                mrde.allVisible = true;
            }
        }
        List<String> hardcodedMainPartAliases = EntityIconDefinitions.getMainModelPartFields(entityRenderer, mainEntityModel, entity);
        List<String> hardcodedModelPartsFields = EntityIconDefinitions.getSecondaryModelPartsFields(entityRenderer, mainEntityModel, entity);
        ModelRenderDetectionElement mainMrde = null;
        for (ModelRenderDetectionElement mrde : detectedModels) {
            boolean mainPartsVisibility;
            if (mrde.isEmpty() || renderedSomething && !modelConfig.layersAllowed) continue;
            EntityModel<?> detectedModel = mrde.model;
            ResourceLocation detectedTexture = mrde.renderTexture;
            TextureAtlasSprite detectedAtlasSprite = mrde.renderAtlasSprite;
            boolean mainModel = detectedModel == mainEntityModel;
            boolean bl2 = mainPartsVisibility = mainModel && mainMrde != null && mrde.sameVisibility(mainMrde);
            if (mainModel && !mainPartsVisibility) {
                if (detectedTexture == null) continue;
                if (!this.resetModelRotations(entity, detectedModel)) break;
                mainRenderedModels.clear();
                mainPart = this.renderModel(matrixStack, renderTypeBuffer, entityRenderer, detectedModel, entity, modelConfig, defaultModelConfig, mainPart, mainRenderedModels, detectedTexture, detectedAtlasSprite, forceFieldCheck, fullModelIcon, mrde, hardcodedMainPartAliases, hardcodedModelPartsFields);
                mainMrde = mrde;
                renderedSomething = renderedSomething || !mainRenderedModels.isEmpty();
                continue;
            }
            if (!mainModel) {
                if (!this.resetModelRotations(entity, detectedModel)) break;
                ArrayList<ModelPart> renderedModels = new ArrayList<ModelPart>();
                mainPart = this.renderModel(matrixStack, renderTypeBuffer, entityRenderer, detectedModel, entity, modelConfig, defaultModelConfig, mainPart, renderedModels, detectedTexture, detectedAtlasSprite, forceFieldCheck, fullModelIcon, mrde, hardcodedMainPartAliases, hardcodedModelPartsFields);
                renderedSomething = renderedSomething || !renderedModels.isEmpty();
                continue;
            }
            if (mainRenderedModels.isEmpty()) continue;
            VertexConsumer vertexBuilder = this.setupModelRenderType(renderTypeBuffer, detectedTexture, detectedAtlasSprite, mrde);
            this.entityModelPartsRenderer.renderPartsIterable(mainRenderedModels, matrixStack, vertexBuilder, new ArrayList<ModelPart>(), mainPart, modelConfig.modelPartsRotationReset, mrde);
            renderTypeBuffer.endBatch();
        }
        if (!mainRenderedModels.isEmpty() && modelConfig.layersAllowed && (extraLayer = EntityIconDefinitions.getCustomLayer(entityRenderer, entity)) != null) {
            mainPart = extraLayer.render(matrixStack, renderTypeBuffer, entityRenderer, entity, mainEntityModel, this.entityModelPartsRenderer, mainRenderedModels, mainPart, modelConfig, mainMrde);
        }
        return renderedSomething;
    }

    private boolean resetModelRotations(Entity entity, EntityModel model) {
        try {
            model.prepareMobModel(entity, 0.0f, 0.0f, 1.0f);
            model.setupAnim(entity, 0.0f, 0.0f, (float)entity.tickCount, 0.0f, 0.0f);
            OpenGLException.checkGLError();
            return true;
        }
        catch (Throwable t) {
            MinimapLogs.LOGGER.error("suppressed exception", t);
            return false;
        }
    }

    private EntityModel getEntityRendererModel(EntityRenderer entityRenderer) {
        if (entityRenderer instanceof LivingEntityRenderer) {
            return ((LivingEntityRenderer)entityRenderer).getModel();
        }
        if (entityRenderer instanceof EnderDragonRenderer) {
            return (EntityModel)Misc.getReflectFieldValue(entityRenderer, this.enderDragonModelField);
        }
        return null;
    }

    private Object resolveModelRoot(EntityModel<?> model, ArrayList<ArrayList<String>> rootPath, Entity entity) {
        ResolvedFieldModelRootPathListener resolvedFieldModelRootPathListener = this.resolvedFieldModelRootPathListener;
        Object currentChainNode = model;
        for (ArrayList<String> pathStep : rootPath) {
            resolvedFieldModelRootPathListener.prepare();
            EntityIconModelFieldResolver.searchSuperclassFields(currentChainNode, pathStep, resolvedFieldModelRootPathListener, ONE_OBJECT_ARRAY);
            currentChainNode = resolvedFieldModelRootPathListener.getCurrentNode();
            if (currentChainNode != null && !resolvedFieldModelRootPathListener.failed()) continue;
            MinimapLogs.LOGGER.info(String.format("The following entity icon model root path step couldn't be resolved for %s:", EntityType.getKey((EntityType)entity.getType())));
            pathStep.forEach(arg_0 -> ((Logger)MinimapLogs.LOGGER).info(arg_0));
            return null;
        }
        return currentChainNode;
    }
}

