/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.waypoints;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.ChatVisiblity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelResource;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.minimap.mcworld.MinimapClientWorldData;
import xaero.common.minimap.mcworld.MinimapClientWorldDataHelper;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointSet;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.common.minimap.waypoints.WaypointWorldContainer;
import xaero.common.minimap.waypoints.WaypointWorldRootContainer;
import xaero.common.misc.OptimizedMath;
import xaero.common.settings.ModSettings;
import xaero.hud.minimap.MinimapLogs;

public class WaypointsManager {
    private IXaeroMinimap modMain;
    private XaeroMinimapSession minimapSession;
    private Minecraft mc;
    private HashMap<String, WaypointWorldContainer> waypointMap = new HashMap();
    private WaypointSet waypoints = null;
    private List<Waypoint> serverWaypoints = null;
    public static final Hashtable<String, Hashtable<Integer, Waypoint>> customWaypoints = new Hashtable();
    private String mainContainerID;
    private String containerID = null;
    private String containerIDIgnoreCaseCache;
    private String customContainerID = null;
    private String worldID = null;
    private String customWorldID = null;
    private BlockPos currentSpawn;
    public long setChanged;
    public static final String TELEPORT_ANYWAY_COMMAND = "xaero_tp_anyway";
    private Waypoint teleportAnywayWP;
    private WaypointWorld teleportAnywayWorld;

    public WaypointsManager(IXaeroMinimap modMain, XaeroMinimapSession minimapSession) {
        this.modMain = modMain;
        this.minimapSession = minimapSession;
        this.mc = Minecraft.getInstance();
    }

    public void onLoad(ClientPacketListener connection) throws IOException {
        this.mainContainerID = this.getMainContainer(false, connection);
        this.fixIPv6Folder(connection);
    }

    public double getDimensionDivision(WaypointWorld waypointWorld) {
        if (Minecraft.getInstance().level == null) {
            return 1.0;
        }
        double selectedDimDiv = this.getDimCoordinateScale(waypointWorld);
        return Minecraft.getInstance().level.dimensionType().coordinateScale() / selectedDimDiv;
    }

    public double getDimCoordinateScale(WaypointWorld waypointWorld) {
        if (waypointWorld == null) {
            return 1.0;
        }
        WaypointWorldRootContainer rootContainer = waypointWorld.getContainer().getRootContainer();
        ResourceKey<Level> dimKey = waypointWorld.getDimId();
        if (dimKey == null) {
            return 1.0;
        }
        return rootContainer.getDimensionScale(dimKey);
    }

    public String getDimensionDirectoryName(ResourceKey<Level> dimKey) {
        if (dimKey == Level.OVERWORLD) {
            return "dim%0";
        }
        if (dimKey == Level.NETHER) {
            return "dim%-1";
        }
        if (dimKey == Level.END) {
            return "dim%1";
        }
        ResourceLocation identifier = dimKey.location();
        return "dim%" + identifier.getNamespace() + "$" + identifier.getPath().replace('/', '%');
    }

    public ResourceKey<Level> findDimensionKey(String validatedName) {
        Set allDimensions = this.mc.player.connection.levels();
        for (ResourceKey dk : allDimensions) {
            if (!validatedName.equals(dk.location().getPath().replaceAll("[^a-zA-Z0-9_]+", ""))) continue;
            return dk;
        }
        return null;
    }

    public ResourceKey<Level> getDimensionKeyForDirectoryName(String dirName) {
        String dimIdPart = dirName.substring(4);
        if (dimIdPart.equals("0")) {
            return Level.OVERWORLD;
        }
        if (dimIdPart.equals("1")) {
            return Level.END;
        }
        if (dimIdPart.equals("-1")) {
            return Level.NETHER;
        }
        String[] idArgs = dimIdPart.split("\\$");
        if (idArgs.length < 2) {
            return null;
        }
        return ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)idArgs[0], (String)idArgs[1].replace('%', '/')));
    }

    private String getMainContainer(boolean preIP6Fix, ClientPacketListener connection) {
        Object potentialContainerID;
        ServerData serverData = connection.getServerData();
        if (this.mc.getSingleplayerServer() != null) {
            potentialContainerID = this.mc.getSingleplayerServer().getWorldPath(LevelResource.ROOT).getParent().getFileName().toString().replace("_", "%us%").replace("/", "%fs%").replace("\\", "%bs%");
        } else if (serverData != null && serverData.isRealm() && this.modMain.getEvents().latestRealm != null) {
            potentialContainerID = "Realms_" + String.valueOf(this.modMain.getEvents().latestRealm.ownerUUID) + "." + this.modMain.getEvents().latestRealm.id;
        } else if (serverData != null) {
            String serverIP = this.modMain.getSettings().differentiateByServerAddress ? serverData.ip : "Any Address";
            int portDivider = !preIP6Fix && serverIP.indexOf(":") != serverIP.lastIndexOf(":") ? serverIP.lastIndexOf("]:") + 1 : serverIP.indexOf(":");
            if (portDivider > 0) {
                serverIP = serverIP.substring(0, portDivider);
            }
            while (serverIP.endsWith(".")) {
                serverIP = serverIP.substring(0, serverIP.length() - 1);
            }
            potentialContainerID = "Multiplayer_" + serverIP.replace(":", "\u00a7").replace("_", "%us%").replace("/", "%fs%").replace("\\", "%bs%");
        } else {
            potentialContainerID = "Unknown";
        }
        potentialContainerID = this.ignoreContainerCase((String)potentialContainerID, null);
        return potentialContainerID;
    }

    public String ignoreContainerCase(String potentialContainerID, String current) {
        if (potentialContainerID.equalsIgnoreCase(current)) {
            return current;
        }
        Set<Map.Entry<String, WaypointWorldContainer>> entries = this.waypointMap.entrySet();
        for (Map.Entry<String, WaypointWorldContainer> e : entries) {
            String containerSearch = e.getValue().getEqualIgnoreCaseSub(potentialContainerID);
            if (containerSearch == null) continue;
            return containerSearch;
        }
        return potentialContainerID;
    }

    public String getNewAutoWorldID(ResourceKey<Level> dimId, boolean useWorldmap) {
        String worldmapMultiworldId;
        if (this.mc.getSingleplayerServer() != null) {
            return "waypoints";
        }
        WaypointWorldRootContainer rootContainer = (WaypointWorldRootContainer)this.getWorldContainer(this.mainContainerID);
        Object autoIdBase = this.getAutoIdBase(rootContainer);
        String string = worldmapMultiworldId = useWorldmap ? this.modMain.getSupportMods().worldmapSupport.tryToGetMultiworldId(dimId) : null;
        if (!(autoIdBase == null || useWorldmap && worldmapMultiworldId == null)) {
            Object actualMultiworldId;
            if (autoIdBase instanceof BlockPos) {
                BlockPos pos = (BlockPos)autoIdBase;
                actualMultiworldId = "mw" + (pos.getX() >> 6) + "," + (pos.getY() >> 6) + "," + (pos.getZ() >> 6);
                if (!rootContainer.isUsingMultiworldDetection()) {
                    String defaultMultiworldId = rootContainer.getDefaultMultiworldId();
                    if (defaultMultiworldId == null) {
                        rootContainer.setDefaultMultiworldId((String)actualMultiworldId);
                        rootContainer.saveConfig();
                    } else {
                        actualMultiworldId = defaultMultiworldId;
                    }
                }
            } else {
                actualMultiworldId = "mw$" + String.valueOf(autoIdBase);
            }
            if (useWorldmap && worldmapMultiworldId != "minimap") {
                actualMultiworldId = worldmapMultiworldId;
            }
            return actualMultiworldId;
        }
        return null;
    }

    public String getCurrentContainerAndWorldID() {
        return this.getCurrentContainerAndWorldID(this.containerID, this.worldID);
    }

    public String getCurrentContainerID() {
        return this.getCurrentContainerID(this.containerID);
    }

    public String getCurrentWorldID() {
        return this.getCurrentWorldID(this.worldID);
    }

    public WaypointWorld getCurrentWorld() {
        return this.getCurrentWorld(this.containerID, this.worldID);
    }

    public String getCurrentOriginContainerID() {
        return this.getCurrentOriginContainerID(this.containerID);
    }

    public String getCurrentContainerAndWorldID(String autoContainer, String autoWorldID) {
        return this.getCurrentContainerID(autoContainer) + "_" + this.getCurrentWorldID(autoWorldID);
    }

    public String getCurrentContainerID(String autoContainer) {
        if (this.customContainerID == null) {
            return autoContainer;
        }
        return this.customContainerID;
    }

    public String getCurrentWorldID(String autoWorldID) {
        if (this.customWorldID == null) {
            return autoWorldID;
        }
        return this.customWorldID;
    }

    public WaypointWorld getCurrentWorld(String autoContainer, String autoWorldID) {
        return this.getWorld(this.getCurrentContainerID(autoContainer), this.getCurrentWorldID(autoWorldID));
    }

    public String getCurrentOriginContainerID(String autoContainer) {
        if (this.getCurrentContainerID(autoContainer) == null) {
            return null;
        }
        return this.getCurrentContainerID(autoContainer).split("/")[0];
    }

    public WaypointWorld getAutoWorld() {
        return this.getWorld(this.getAutoContainerID(), this.getAutoWorldID());
    }

    public String getAutoRootContainerID() {
        return this.mainContainerID;
    }

    public String getAutoContainerID() {
        return this.containerID;
    }

    public String getAutoWorldID() {
        return this.worldID;
    }

    public WaypointWorld getWorld(String container, String world) {
        return this.addWorld(container, world);
    }

    public WaypointWorld addWorld(String container, String world) {
        if (container == null) {
            return null;
        }
        WaypointWorldContainer wc = this.addWorldContainer(container);
        return wc.addWorld(world);
    }

    public WaypointWorldContainer getWorldContainer(String id) {
        return this.addWorldContainer(id);
    }

    public WaypointWorldContainer addWorldContainer(String id) {
        WaypointWorldContainer container = null;
        String[] subs = id.split("/");
        for (int i = 0; i < subs.length; ++i) {
            if (i == 0) {
                container = this.waypointMap.get(subs[i]);
                if (container != null) continue;
                container = new WaypointWorldRootContainer(this.modMain, this.minimapSession, subs[i]);
                this.waypointMap.put(subs[i], container);
                WaypointWorldRootContainer rootContainer = (WaypointWorldRootContainer)container;
                if (rootContainer.configLoaded) continue;
                rootContainer.loadConfig();
                continue;
            }
            container = container.addSubContainer(subs[i]);
        }
        return container;
    }

    public WaypointWorldContainer getWorldContainerNullable(String id) {
        WaypointWorldContainer container = null;
        String[] subs = id.split("/");
        for (int i = 0; i < subs.length; ++i) {
            container = i == 0 ? this.waypointMap.get(subs[i]) : container.subContainers.get(subs[i]);
            if (container != null) continue;
            return null;
        }
        return container;
    }

    public void removeContainer(String id) {
        WaypointWorldContainer container = null;
        String[] subs = id.split("/");
        for (int i = 0; i < subs.length; ++i) {
            if (i == 0) {
                container = this.waypointMap.get(subs[i]);
                if (container == null) {
                    return;
                }
                if (i != subs.length - 1) continue;
                this.waypointMap.remove(subs[i]);
                return;
            }
            if (container.containsSub(subs[i])) {
                if (i == subs.length - 1) {
                    container.deleteSubContainer(subs[i]);
                    return;
                }
                container = container.addSubContainer(subs[i]);
                continue;
            }
            return;
        }
    }

    public boolean containerExists(String id) {
        WaypointWorldContainer container = null;
        String[] subs = id.split("/");
        for (int i = 0; i < subs.length; ++i) {
            if (i == 0) {
                container = this.waypointMap.get(subs[i]);
                if (container == null) {
                    return false;
                }
                if (i != subs.length - 1) continue;
                return true;
            }
            if (container.containsSub(subs[i])) {
                if (i == subs.length - 1) {
                    return true;
                }
                container = container.addSubContainer(subs[i]);
                continue;
            }
            return false;
        }
        return false;
    }

    public void updateWorldIds() {
        String oldContainerID = this.containerID;
        String oldWorldID = this.worldID;
        this.containerIDIgnoreCaseCache = this.containerID = this.getPotentialContainerID();
        String potentialWorldID = this.getNewAutoWorldID((ResourceKey<Level>)this.mc.level.dimension(), this.modMain.getSupportMods().worldmap());
        if (potentialWorldID == null) {
            this.containerID = oldContainerID;
            this.worldID = oldWorldID;
        } else {
            this.worldID = potentialWorldID;
            if (this.containerID != null && !this.containerID.equals(oldContainerID)) {
                if (oldWorldID != null && oldWorldID.startsWith("plugin")) {
                    WaypointWorldContainer oldContainer = this.getWorldContainer(oldContainerID);
                    ArrayList<WaypointWorld> worlds = new ArrayList<WaypointWorld>(oldContainer.worlds.values());
                    for (int i = 0; i < worlds.size(); ++i) {
                        worlds.get(i).getServerWaypoints().clear();
                    }
                }
                WaypointWorldContainer rootContainer = this.getWorldContainer(this.mainContainerID);
                rootContainer.renameOldContainer(this.containerID);
                ((WaypointWorldRootContainer)rootContainer).updateDimensionType(this.mc.level);
            }
        }
    }

    private String getPotentialContainerID() {
        return this.ignoreContainerCase(this.mainContainerID + "/" + this.getDimensionDirectoryName((ResourceKey<Level>)this.mc.level.dimension()), this.containerIDIgnoreCaseCache);
    }

    public void updateWaypoints() {
        if (this.containerID != null && this.worldID != null) {
            this.addWorld(this.containerID, this.worldID);
            WaypointWorld world = this.getCurrentWorld();
            this.waypoints = world.getCurrentSet();
            this.serverWaypoints = !world.getServerWaypoints().isEmpty() ? new ArrayList<Waypoint>(world.getServerWaypoints().values()) : null;
        }
    }

    public void createDeathpoint(Player p) {
        WaypointWorld autoWorld;
        boolean shouldAddToAuto;
        this.updateWorldIds();
        if (this.modMain.getSettings().switchToAutoOnDeath) {
            this.setCustomContainerID(null);
            this.setCustomWorldID(null);
        }
        boolean bl = shouldAddToAuto = (autoWorld = this.getAutoWorld()) != null;
        if (this.modMain.getSupportMods().worldmap()) {
            String realCurrentDimContainerKey = this.getPotentialContainerID();
            boolean containerIsSynced = realCurrentDimContainerKey.equals(this.containerID);
            List<String> allPotentialMWIds = this.modMain.getSupportMods().worldmapSupport.getPotentialMultiworldIds((ResourceKey<Level>)this.mc.level.dimension());
            if (allPotentialMWIds != null && !allPotentialMWIds.isEmpty()) {
                for (String mwId : allPotentialMWIds) {
                    WaypointWorld potentialWorld = this.getWorld(realCurrentDimContainerKey, mwId);
                    if (containerIsSynced && potentialWorld == autoWorld) continue;
                    this.createDeathpoint(p, potentialWorld, false);
                }
                boolean bl2 = shouldAddToAuto = shouldAddToAuto && containerIsSynced;
            }
        }
        if (shouldAddToAuto) {
            this.createDeathpoint(p, autoWorld, false);
        }
    }

    private void createDeathpoint(Player p, WaypointWorld wpw, boolean temp) {
        boolean disabled = false;
        WaypointSet waypoints = wpw.getCurrentSet();
        if (waypoints == null) {
            return;
        }
        block2: for (WaypointSet set : wpw.getSets().values()) {
            for (int i = 0; i < set.getList().size(); ++i) {
                Waypoint w = set.getList().get(i);
                if (w.getWaypointType() != 1) continue;
                if (set == waypoints) {
                    disabled = w.isDisabled();
                }
                if (!this.modMain.getSettings().getOldDeathpoints()) {
                    set.getList().remove(i);
                    --i;
                    continue block2;
                }
                w.setType(2);
                w.setName("gui.xaero_deathpoint_old");
                continue block2;
            }
        }
        ArrayList<Waypoint> list = waypoints.getList();
        double dimDiv = this.getDimensionDivision(wpw);
        if (this.modMain.getSettings().getDeathpoints()) {
            Waypoint deathpoint = new Waypoint(OptimizedMath.myFloor((double)OptimizedMath.myFloor(p.getX()) * dimDiv), OptimizedMath.myFloor(p.getY()), OptimizedMath.myFloor((double)OptimizedMath.myFloor(p.getZ()) * dimDiv), "gui.xaero_deathpoint", "D", 0, 1);
            deathpoint.setDisabled(disabled);
            deathpoint.setTemporary(temp);
            list.add(0, deathpoint);
        }
        try {
            this.modMain.getSettings().saveWaypoints(wpw);
        }
        catch (IOException e) {
            MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
        }
    }

    public void createTemporaryWaypoints(WaypointWorld waypointWorld, int x, int y, int z) {
        this.createTemporaryWaypoints(waypointWorld, x, y, z, true);
    }

    public void createTemporaryWaypoints(WaypointWorld waypointWorld, int x, int y, int z, boolean yIncluded, double dimScale) {
        if (this.modMain.getSettings().waypointsGUI(this) && waypointWorld != null) {
            double waypointDestDimScale = this.getDimCoordinateScale(waypointWorld);
            double dimDiv = dimScale / waypointDestDimScale;
            x = OptimizedMath.myFloor((double)x * dimDiv);
            z = OptimizedMath.myFloor((double)z * dimDiv);
            Waypoint instant = new Waypoint(x, y, z, "Waypoint", "X", (int)(Math.random() * (double)ModSettings.ENCHANT_COLORS.length), 0, true, yIncluded);
            if (!this.modMain.getSettings().waypointsBottom) {
                waypointWorld.getCurrentSet().getList().add(0, instant);
            } else {
                waypointWorld.getCurrentSet().getList().add(instant);
            }
        }
    }

    public void createTemporaryWaypoints(WaypointWorld waypointWorld, int x, int y, int z, boolean yIncluded) {
        this.createTemporaryWaypoints(waypointWorld, x, y, z, yIncluded, Minecraft.getInstance().level.dimensionType().coordinateScale());
    }

    public boolean canTeleport(boolean displayingTeleportableWorld, WaypointWorld displayedWorld) {
        return (this.modMain.getSettings().allowWrongWorldTeleportation || displayingTeleportableWorld) && displayedWorld.getContainer().getRootContainer().isTeleportationEnabled();
    }

    public void teleportAnyway() {
        if (this.teleportAnywayWP != null) {
            Screen dummyScreen = new Screen(this, (Component)Component.literal((String)"")){};
            Minecraft minecraft = Minecraft.getInstance();
            dummyScreen.init(minecraft, minecraft.getWindow().getGuiScaledWidth(), minecraft.getWindow().getGuiScaledHeight());
            this.teleportToWaypoint(this.teleportAnywayWP, this.teleportAnywayWorld, dummyScreen, false);
        }
    }

    public void teleportToWaypoint(Waypoint selected, WaypointWorld displayedWorld, Screen screen) {
        this.teleportToWaypoint(selected, displayedWorld, screen, true);
    }

    public void teleportToWaypoint(Waypoint selected, WaypointWorld displayedWorld, Screen screen, boolean respectHiddenCoords) {
        this.updateWorldIds();
        boolean displayingTeleportableWorld = this.isWorldTeleportable(displayedWorld);
        if (selected != null && this.canTeleport(displayingTeleportableWorld, displayedWorld)) {
            this.mc.setScreen(null);
            if (!selected.isYIncluded() && this.mc.gameMode.canHurtPlayer()) {
                MutableComponent messageComponent = Component.literal((String)I18n.get((String)"gui.xaero_teleport_y_unknown", (Object[])new Object[0]));
                messageComponent.setStyle(messageComponent.getStyle().withColor(ChatFormatting.RED));
                this.mc.gui.getChat().addMessage((Component)messageComponent);
                return;
            }
            Object tpCommand = "";
            boolean reachableDimension = true;
            boolean crossDimension = false;
            WaypointWorldRootContainer rootContainer = displayedWorld.getContainer().getRootContainer();
            WaypointWorld autoWorld = this.getAutoWorld();
            if (displayingTeleportableWorld && displayedWorld != autoWorld) {
                if (!this.isTeleportationSafe(displayedWorld)) {
                    MutableComponent messageComponent = Component.literal((String)I18n.get((String)"gui.xaero_teleport_not_connected", (Object[])new Object[0]));
                    messageComponent.setStyle(messageComponent.getStyle().withColor(ChatFormatting.RED));
                    this.mc.gui.getChat().addMessage((Component)messageComponent);
                    return;
                }
                if (autoWorld == null || autoWorld.getContainer() != displayedWorld.getContainer()) {
                    crossDimension = true;
                    String[] containerKeySplit = displayedWorld.getContainer().getKey().split("/");
                    if (containerKeySplit.length > 1) {
                        String dimensionKey = containerKeySplit[1];
                        if (!dimensionKey.startsWith("dim%")) {
                            this.mc.gui.getChat().addMessage((Component)Component.translatable((String)"gui.xaero_visit_needed"));
                            return;
                        }
                        ResourceKey<Level> dimensionId = this.getDimensionKeyForDirectoryName(dimensionKey);
                        if (dimensionId != null) {
                            this.setCustomContainerID(null);
                            this.setCustomWorldID(null);
                            this.updateWaypoints();
                            tpCommand = "/execute in " + dimensionId.location().toString() + " run ";
                        } else {
                            reachableDimension = false;
                        }
                    } else {
                        reachableDimension = false;
                    }
                }
            }
            if (reachableDimension) {
                if (respectHiddenCoords && this.modMain.getSettings().hideWaypointCoordinates && this.mc.options.chatVisibility().get() != ChatVisiblity.HIDDEN) {
                    MutableComponent messageComponent = Component.literal((String)I18n.get((String)"gui.xaero_teleport_coordinates_hidden", (Object[])new Object[0]));
                    messageComponent.setStyle(messageComponent.getStyle().withColor(ChatFormatting.AQUA));
                    this.mc.gui.getChat().addMessage((Component)messageComponent);
                    MutableComponent clickableQuestion = Component.literal((String)("\u00a7e[" + I18n.get((String)"gui.xaero_teleport_anyway", (Object[])new Object[0]) + "]"));
                    clickableQuestion.setStyle(clickableQuestion.getStyle().withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/xaero_tp_anyway")).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)I18n.get((String)"gui.xaero_teleport_shows_coordinates", (Object[])new Object[0])).withStyle(ChatFormatting.RED))));
                    this.teleportAnywayWP = selected;
                    this.teleportAnywayWorld = displayedWorld;
                    this.mc.gui.getChat().addMessage((Component)clickableQuestion);
                } else {
                    String tpCommandPrefix;
                    int x = selected.getX();
                    int z = selected.getZ();
                    double dimDiv = this.getDimensionDivision(displayedWorld);
                    if (!crossDimension && dimDiv != 1.0) {
                        x = (int)Math.floor((double)x / dimDiv);
                        z = (int)Math.floor((double)z / dimDiv);
                    }
                    String serverTpCommand = selected.isRotation() ? rootContainer.getServerTeleportCommandRotationFormat() : rootContainer.getServerTeleportCommandFormat();
                    String defaultTpCommand = selected.isRotation() ? this.modMain.getSettings().defaultWaypointTPCommandRotationFormat : this.modMain.getSettings().defaultWaypointTPCommandFormat;
                    String string = tpCommandPrefix = rootContainer.isUsingDefaultTeleportCommand() || serverTpCommand == null ? defaultTpCommand : serverTpCommand;
                    if (((String)tpCommand).length() > 0) {
                        if (tpCommandPrefix.startsWith("/")) {
                            tpCommandPrefix = tpCommandPrefix.substring(1);
                        }
                        if (tpCommandPrefix.startsWith("minecraft:")) {
                            tpCommandPrefix = tpCommandPrefix.substring(10);
                        }
                    }
                    String yString = !selected.isYIncluded() ? "~" : (this.modMain.getSettings().getPartialYTeleportation() ? "" + ((double)selected.getY() + 0.5) : "" + selected.getY());
                    tpCommandPrefix = tpCommandPrefix.replace("{x}", "" + x).replace("{y}", yString).replace("{z}", "" + z).replace("{name}", selected.getLocalizedName());
                    if (selected.isRotation()) {
                        tpCommandPrefix = tpCommandPrefix.replace("{yaw}", "" + selected.getYaw());
                    }
                    if (((String)(tpCommand = (String)tpCommand + tpCommandPrefix)).startsWith("/")) {
                        if (!this.mc.player.connection.sendUnsignedCommand((String)(tpCommand = ((String)tpCommand).substring(1)))) {
                            this.mc.player.connection.sendCommand((String)tpCommand);
                        }
                    } else {
                        this.mc.player.connection.sendChat((String)tpCommand);
                    }
                }
            } else {
                this.mc.gui.getChat().addMessage((Component)Component.literal((String)I18n.get((String)"gui.xaero_unreachable_dimension", (Object[])new Object[0])).withStyle(ChatFormatting.RED));
            }
        }
    }

    public boolean isWorldTeleportable(WaypointWorld displayedWorld) {
        WaypointWorld autoWorld = this.getAutoWorld();
        WaypointWorldRootContainer rootContainer = displayedWorld.getContainer().getRootContainer();
        return rootContainer.getKey().equals(this.getAutoRootContainerID()) && (autoWorld == displayedWorld || autoWorld != null && (autoWorld.getContainer() == displayedWorld.getContainer() || this.modMain.getSettings().crossDimensionalTp && autoWorld.getContainer() != displayedWorld.getContainer()));
    }

    public boolean isTeleportationSafe(WaypointWorld displayedWorld) {
        if (!Minecraft.getInstance().gameMode.canHurtPlayer()) {
            return true;
        }
        WaypointWorld autoWorld = this.getAutoWorld();
        WaypointWorldRootContainer rootContainer = displayedWorld.getContainer().getRootContainer();
        return rootContainer.getSubWorldConnections().isConnected(autoWorld, displayedWorld);
    }

    public WaypointSet getWaypoints() {
        return this.waypoints;
    }

    public void setWaypoints(WaypointSet waypoints) {
        this.waypoints = waypoints;
    }

    public List<Waypoint> getServerWaypoints() {
        return this.serverWaypoints;
    }

    public HashMap<String, WaypointWorldContainer> getWaypointMap() {
        return this.waypointMap;
    }

    public void setCurrentSpawn(BlockPos currentSpawn, ClientLevel clientWorld) {
        this.currentSpawn = currentSpawn;
    }

    public String getCustomContainerID() {
        return this.customContainerID;
    }

    public void setCustomContainerID(String customContainerID) {
        this.customContainerID = customContainerID;
    }

    public String getCustomWorldID() {
        return this.customWorldID;
    }

    public void setCustomWorldID(String customWorldID) {
        this.customWorldID = customWorldID;
    }

    public static Hashtable<Integer, Waypoint> getCustomWaypoints(String modName) {
        Hashtable<Integer, Waypoint> wps = customWaypoints.get(modName);
        if (wps == null) {
            wps = new Hashtable();
            customWaypoints.put(modName, wps);
        }
        return wps;
    }

    public boolean isMultiplayer(String containerId) {
        return containerId.startsWith("Multiplayer_") || containerId.startsWith("Realms_");
    }

    private boolean hasServerLevelId(WaypointWorldRootContainer rootContainer) {
        MinimapClientWorldData worldData = MinimapClientWorldDataHelper.getCurrentWorldData();
        return worldData.serverLevelId != null && !rootContainer.isIgnoreServerLevelId();
    }

    private Object getAutoIdBase(WaypointWorldRootContainer rootContainer) {
        MinimapClientWorldData worldData = MinimapClientWorldDataHelper.getCurrentWorldData();
        return this.hasServerLevelId(rootContainer) ? worldData.serverLevelId : this.currentSpawn;
    }

    public void onServerLevelId(int id) {
        MinimapClientWorldData worldData = MinimapClientWorldDataHelper.getCurrentWorldData();
        worldData.serverLevelId = id;
        MinimapLogs.LOGGER.info("Minimap updated server level id: " + id + " for world " + String.valueOf(Minecraft.getInstance().level.dimension()));
    }

    private void fixIPv6Folder(ClientPacketListener connection) throws IOException {
        Path fixedFolder;
        Path preFixFolder;
        String preIP6FixMainContainerID;
        if (this.mainContainerID.startsWith("Multiplayer_") && !this.mainContainerID.equals(preIP6FixMainContainerID = this.getMainContainer(true, connection)) && Files.exists(preFixFolder = new File(this.modMain.getWaypointsFolder(), preIP6FixMainContainerID).toPath(), new LinkOption[0]) && !Files.exists(fixedFolder = new File(this.modMain.getWaypointsFolder(), this.mainContainerID).toPath(), new LinkOption[0])) {
            Files.move(preFixFolder, fixedFolder, new CopyOption[0]);
        }
    }
}

