/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.waypoints.render;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.effect.Effects;
import xaero.common.graphics.CustomRenderTypes;
import xaero.common.gui.GuiMisc;
import xaero.common.minimap.MinimapProcessor;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointSet;
import xaero.common.minimap.waypoints.WaypointUtil;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.minimap.waypoints.render.WaypointDeleter;
import xaero.common.minimap.waypoints.render.WaypointFilterParams;
import xaero.common.misc.Misc;
import xaero.common.settings.ModSettings;

public class WaypointsIngameRenderer {
    private IXaeroMinimap modMain;
    private PoseStack identityMatrixStack;
    private PoseStack identityMatrixStackOverlay;
    private Vector4f origin4f;
    private List<Waypoint> sortingList;
    private WaypointFilterParams filterParams;
    private Predicate<Waypoint> filter;
    private Waypoint previousClosest;
    private Waypoint workingClosest;
    private double workingClosestCos;
    private final WaypointDeleter waypointReachDeleter;

    public WaypointsIngameRenderer(IXaeroMinimap modMain, WaypointDeleter waypointReachDeleter, Minecraft mc) {
        this.modMain = modMain;
        this.identityMatrixStack = new PoseStack();
        this.identityMatrixStackOverlay = new PoseStack();
        this.origin4f = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        this.sortingList = new ArrayList<Waypoint>();
        this.filterParams = new WaypointFilterParams();
        this.filter = w -> {
            WaypointFilterParams filterParams = this.filterParams;
            boolean deathpoints = filterParams.deathpoints;
            if (w.isDisabled() || w.getVisibilityType() == 2 || w.getVisibilityType() == 3 || (w.getWaypointType() == 1 || w.getWaypointType() == 2) && !deathpoints) {
                return false;
            }
            double offX = (double)w.getX(filterParams.dimDiv) - filterParams.cameraX + 0.5;
            double offY = (double)w.getY() - filterParams.cameraY + 1.0;
            if (!w.isYIncluded()) {
                offY = filterParams.playerY - filterParams.cameraY + 1.0;
            }
            double offZ = (double)w.getZ(filterParams.dimDiv) - filterParams.cameraZ + 0.5;
            double depth = offX * (double)filterParams.lookVector.x() + offY * (double)filterParams.lookVector.y() + offZ * (double)filterParams.lookVector.z();
            if (depth <= 0.1) {
                return false;
            }
            double distanceScale = filterParams.dimensionScaleDistance ? Minecraft.getInstance().level.dimensionType().coordinateScale() : 1.0;
            double unscaledDistance2D = Math.sqrt(offX * offX + offZ * offZ);
            double distance2D = unscaledDistance2D * distanceScale;
            double waypointsDistance = filterParams.waypointsDistance;
            double waypointsDistanceMin = filterParams.waypointsDistanceMin;
            return w.isOneoffDestination() || (w.getWaypointType() == 1 || w.isGlobal() || w.isTemporary() && filterParams.temporaryWaypointsGlobal || waypointsDistance == 0.0 || !(distance2D > waypointsDistance)) && (waypointsDistanceMin == 0.0 || !(unscaledDistance2D < waypointsDistanceMin));
        };
        this.waypointReachDeleter = waypointReachDeleter;
    }

    public void render(XaeroMinimapSession minimapSession, float partial, MinimapProcessor minimap, Matrix4f waypointsProjection, Matrix4f worldModelView) {
        if (this.modMain.getSettings().getShowIngameWaypoints()) {
            Hashtable<String, Hashtable<Integer, Waypoint>> customWaypoints;
            Minecraft mc = Minecraft.getInstance();
            if (mc.player == null || Misc.hasEffect((Player)mc.player, Effects.NO_WAYPOINTS) || Misc.hasEffect((Player)mc.player, Effects.NO_WAYPOINTS_HARMFUL)) {
                return;
            }
            if (this.modMain.getSupportMods().vivecraft) {
                return;
            }
            Font fontrenderer = mc.font;
            if (fontrenderer == null) {
                return;
            }
            PoseStack matrixStack = this.identityMatrixStack;
            PoseStack matrixStackOverlay = this.identityMatrixStackOverlay;
            MinimapRendererHelper helper = this.modMain.getInterfaces().getMinimapInterface().getMinimapFBORenderer().getHelper();
            WaypointsManager waypointsManager = minimapSession.getWaypointsManager();
            String subworldName = null;
            if (waypointsManager.getCurrentWorld() != null && waypointsManager.getAutoWorld() != waypointsManager.getCurrentWorld()) {
                subworldName = "(" + waypointsManager.getCurrentWorld().getContainer().getSubName() + ")";
            }
            Entity entity = mc.getCameraEntity();
            Camera activeRender = mc.gameRenderer.getMainCamera();
            double actualEntityX = entity.getX();
            double actualEntityY = entity.getY();
            double actualEntityZ = entity.getZ();
            double smoothEntityY = minimap.getEntityRadar().getEntityY(entity, partial);
            Vec3 cameraPos = activeRender.getPosition();
            double dimDiv = waypointsManager.getDimensionDivision(waypointsManager.getCurrentWorld());
            Waypoint.RENDER_SORTING_POS = new Vec3(cameraPos.x * dimDiv, cameraPos.y, cameraPos.z * dimDiv);
            double d3 = cameraPos.x();
            double d4 = cameraPos.y();
            double d5 = cameraPos.z();
            Tesselator tessellator = Tesselator.getInstance();
            RenderSystem.disableCull();
            matrixStack.pushPose();
            matrixStack.last().pose().mul((Matrix4fc)worldModelView);
            Lighting.setupForFlatItems();
            double fov = ((Integer)mc.options.fov().get()).doubleValue();
            int screenWidth = Minecraft.getInstance().getWindow().getWidth();
            int screenHeight = Minecraft.getInstance().getWindow().getHeight();
            float cameraAngleYaw = activeRender.getYRot();
            float cameraAnglePitch = activeRender.getXRot();
            Vector3f lookVector = activeRender.getLookVector().get(new Vector3f());
            double clampDepth = this.modMain.getSettings().getWaypointsClampDepth(fov, screenHeight);
            List<Waypoint> sortingList = this.sortingList;
            sortingList.clear();
            if (waypointsManager.getWaypoints() != null) {
                if (this.modMain.getSettings().renderAllSets) {
                    HashMap<String, WaypointSet> sets = waypointsManager.getCurrentWorld().getSets();
                    for (Map.Entry<String, WaypointSet> setEntry : sets.entrySet()) {
                        sortingList.addAll(setEntry.getValue().getList());
                    }
                } else {
                    sortingList.addAll(waypointsManager.getWaypoints().getList());
                }
            }
            if (!(customWaypoints = WaypointsManager.customWaypoints).isEmpty()) {
                for (Hashtable<Integer, Waypoint> modCustomWaypoints : customWaypoints.values()) {
                    sortingList.addAll(modCustomWaypoints.values());
                }
            }
            matrixStackOverlay.pushPose();
            matrixStackOverlay.translate(0.0f, 0.0f, -2980.0f);
            if (!sortingList.isEmpty()) {
                this.waypointReachDeleter.begin();
                ModSettings settings = this.modMain.getSettings();
                this.filterParams.setParams(d3, d4, d5, lookVector, dimDiv, settings.getDeathpoints(), settings.temporaryWaypointsGlobal, settings.getMaxWaypointsDistance(), settings.waypointsDistanceMin, smoothEntityY, settings.dimensionScaledMaxWaypointDistance);
                Stream<Waypoint> waypointStream = sortingList.stream().filter(this.filter).sorted();
                MultiBufferSource.BufferSource cvcRenderTypeBuffer = this.modMain.getHudRenderer().getCustomVertexConsumers().getBetterPVPRenderTypeBuffers();
                VertexConsumer waypointBackgroundConsumer = cvcRenderTypeBuffer.getBuffer(CustomRenderTypes.COLORED_WAYPOINTS_BGS);
                double minDistance = settings.waypointsDistanceMin;
                this.renderWaypointsIterator(matrixStack, matrixStackOverlay, helper, waypointStream.iterator(), d3, d4, d5, entity, tessellator, dimDiv, actualEntityX, actualEntityY, actualEntityZ, smoothEntityY, fov, screenHeight, cameraAngleYaw, cameraAnglePitch, lookVector, clampDepth, cvcRenderTypeBuffer, waypointBackgroundConsumer, fontrenderer, waypointsProjection, screenWidth, false, minDistance, subworldName);
                this.waypointReachDeleter.deleteCollected(waypointsManager.getCurrentWorld(), settings.renderAllSets);
            }
            matrixStackOverlay.popPose();
            RenderSystem.enableDepthTest();
            RenderSystem.enableCull();
            RenderSystem.depthMask((boolean)true);
            Lighting.setupFor3DItems();
            matrixStack.popPose();
        }
    }

    private void renderWaypointsIterator(PoseStack matrixStack, PoseStack matrixStackOverlay, MinimapRendererHelper helper, Iterator<Waypoint> iter, double d3, double d4, double d5, Entity entity, Tesselator tessellator, double dimDiv, double actualEntityX, double actualEntityY, double actualEntityZ, double smoothEntityY, double fov, int screenHeight, float cameraAngleYaw, float cameraAnglePitch, Vector3f lookVector, double clampDepth, MultiBufferSource.BufferSource renderTypeBuffer, VertexConsumer waypointBackgroundConsumer, Font fontrenderer, Matrix4f waypointsProjection, int screenWidth, boolean detailedDisplayAllowed, double minDistance, String subworldName) {
        boolean onlyMainInfo;
        int count = 0;
        this.workingClosest = null;
        int displayMultipleWaypointInfo = this.modMain.getSettings().displayMultipleWaypointInfo;
        boolean deleteReachedDeathpoints = this.modMain.getSettings().deleteReachedDeathpoints;
        boolean bl = onlyMainInfo = displayMultipleWaypointInfo == 0 || displayMultipleWaypointInfo == 1 && !entity.isShiftKeyDown();
        while (iter.hasNext()) {
            Waypoint w = iter.next();
            this.renderWaypointIngame(matrixStack, matrixStackOverlay, helper, cameraAngleYaw, cameraAnglePitch, lookVector, w, this.modMain, clampDepth, d3, d4, d5, entity, tessellator, dimDiv, actualEntityX, actualEntityY, actualEntityZ, smoothEntityY, renderTypeBuffer, waypointBackgroundConsumer, fontrenderer, waypointsProjection, screenWidth, screenHeight, false, onlyMainInfo, minDistance, deleteReachedDeathpoints, subworldName);
            if (++count >= 19500) continue;
            matrixStackOverlay.translate(0.0f, 0.0f, 0.1f);
        }
        if (onlyMainInfo && this.previousClosest != null) {
            this.renderWaypointIngame(matrixStack, matrixStackOverlay, helper, cameraAngleYaw, cameraAnglePitch, lookVector, this.previousClosest, this.modMain, clampDepth, d3, d4, d5, entity, tessellator, dimDiv, actualEntityX, actualEntityY, actualEntityZ, smoothEntityY, renderTypeBuffer, waypointBackgroundConsumer, fontrenderer, waypointsProjection, screenWidth, screenHeight, true, onlyMainInfo, minDistance, false, subworldName);
        }
        this.previousClosest = this.workingClosest;
        renderTypeBuffer.endBatch();
        RenderSystem.clear((int)256, (boolean)Minecraft.ON_OSX);
    }

    private void renderWaypointIngame(PoseStack matrixStack, PoseStack matrixStackOverlay, MinimapRendererHelper helper, float cameraAngleYaw, float cameraAnglePitch, Vector3f lookVector, Waypoint w, IXaeroMinimap modMain, double depthClamp, double d3, double d4, double d5, Entity entity, Tesselator tessellator, double dimDiv, double actualEntityX, double actualEntityY, double actualEntityZ, double smoothEntityY, MultiBufferSource.BufferSource textRenderTypeBuffer, VertexConsumer waypointBackgroundConsumer, Font fontrenderer, Matrix4f waypointsProjection, int screenWidth, int screenHeight, boolean isTheMain, boolean onlyMainInfo, double minDistance, boolean deleteReachedDeathpoints, String subworldName) {
        int wX = w.getX(dimDiv);
        int wZ = w.getZ(dimDiv);
        double offX = (double)wX - d3 + 0.5;
        double offY = (double)w.getY() - d4 + 1.0;
        if (!w.isYIncluded()) {
            offY = smoothEntityY - d4 + 1.0;
        }
        double offZ = (double)wZ - d5 + 0.5;
        double depth = offX * (double)lookVector.x() + offY * (double)lookVector.y() + offZ * (double)lookVector.z();
        double correctOffX = actualEntityX - (double)wX - 0.5;
        double correctOffY = actualEntityY - (double)w.getY();
        if (!w.isYIncluded()) {
            correctOffY = 0.0;
        }
        double correctOffZ = actualEntityZ - (double)wZ - 0.5;
        double correctDistance = Math.sqrt(correctOffX * correctOffX + correctOffY * correctOffY + correctOffZ * correctOffZ);
        double distance2D = Math.sqrt(offX * offX + offZ * offZ);
        double distance = Math.sqrt(offX * offX + offY * offY + offZ * offZ);
        if ((deleteReachedDeathpoints || w.getWaypointType() != 1 && w.getWaypointType() != 2) && w.isOneoffDestination() && System.currentTimeMillis() - w.getCreatedAt() > 5000L && correctDistance < 4.0) {
            this.waypointReachDeleter.add(w);
        }
        if (minDistance != 0.0 && distance2D < minDistance) {
            return;
        }
        double originalOffY = offY;
        float textSize = 1.0f;
        String name = w.getLocalizedName();
        Object distanceText = "";
        boolean couldShowDistance = false;
        boolean showDistance = false;
        if (correctDistance > 20.0 || modMain.getSettings().alwaysShowDistance) {
            if (modMain.getSettings().distance == 1) {
                float offset;
                float Z = (float)(offZ == 0.0 ? 0.001 : offZ);
                float angle = (float)Math.toDegrees(Math.atan(-offX / (double)Z));
                if (offZ < 0.0) {
                    angle = offX < 0.0 ? (angle += 180.0f) : (angle -= 180.0f);
                }
                boolean bl = couldShowDistance = Math.abs(offset = Mth.wrapDegrees((float)(angle - cameraAngleYaw))) < (float)modMain.getSettings().lookingAtAngle;
                if (modMain.getSettings().lookingAtAngleVertical != 180) {
                    float verticalAngle = (float)Math.toDegrees(Math.atan(-originalOffY / (distance2D == 0.0 ? 1.0E-5 : distance2D)));
                    couldShowDistance = couldShowDistance && Math.abs(verticalAngle - cameraAnglePitch) < (float)modMain.getSettings().lookingAtAngleVertical;
                }
            } else if (modMain.getSettings().distance == 2) {
                couldShowDistance = true;
            }
            if (couldShowDistance) {
                if (!isTheMain) {
                    double cos = depth / distance;
                    if (this.workingClosest == null || cos > this.workingClosestCos) {
                        this.workingClosest = w;
                        this.workingClosestCos = cos;
                    }
                    if (!onlyMainInfo) {
                        showDistance = true;
                    }
                } else {
                    showDistance = true;
                }
            }
            if (showDistance) {
                int autoConvertWaypointDistanceToKmThreshold = modMain.getSettings().autoConvertWaypointDistanceToKmThreshold;
                distanceText = autoConvertWaypointDistanceToKmThreshold != -1 && correctDistance >= (double)autoConvertWaypointDistanceToKmThreshold ? GuiMisc.getFormat(modMain.getSettings().waypointDistancePrecision).format(correctDistance / 1000.0) + "km" : GuiMisc.getFormat(modMain.getSettings().waypointDistancePrecision).format(correctDistance) + "m";
                if (!modMain.getSettings().keepWaypointNames) {
                    name = "";
                }
            } else {
                name = "";
            }
        }
        if (onlyMainInfo && this.previousClosest == w && !isTheMain) {
            return;
        }
        matrixStack.pushPose();
        matrixStackOverlay.pushPose();
        if (distance > 250000.0) {
            double offScaler = 250000.0 / distance;
            offX *= offScaler;
            offY *= offScaler;
            offZ *= offScaler;
        }
        matrixStack.translate(offX, offY, offZ);
        this.drawAsOverlay(matrixStack, matrixStackOverlay, helper, w, modMain.getSettings(), tessellator, fontrenderer, name, (String)distanceText, textSize, showDistance, textRenderTypeBuffer, waypointBackgroundConsumer, waypointsProjection, screenWidth, screenHeight, depthClamp, depth, isTheMain, subworldName);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStack.popPose();
        matrixStackOverlay.popPose();
    }

    public void drawAsOverlay(PoseStack matrixStack, PoseStack matrixStackOverlay, MinimapRendererHelper helper, Waypoint w, ModSettings settings, Tesselator tessellator, Font fontrenderer, String name, String distance, float textSize, boolean showDistance, MultiBufferSource.BufferSource renderTypeBuffer, VertexConsumer waypointBackgroundConsumer, Matrix4f waypointsProjection, int screenWidth, int screenHeight, double depthClamp, double depth, boolean isTheMain, String subworldName) {
        this.origin4f.mul((Matrix4fc)matrixStack.last().pose());
        this.origin4f.mul((Matrix4fc)waypointsProjection);
        int overlayPosX = (int)((1.0f + this.origin4f.x() / this.origin4f.w()) / 2.0f * (float)screenWidth);
        int overlayPosY = (int)((1.0f - this.origin4f.y() / this.origin4f.w()) / 2.0f * (float)screenHeight);
        this.origin4f.set(0.0f, 0.0f, 0.0f, 1.0f);
        matrixStackOverlay.translate((float)overlayPosX, (float)overlayPosY, 0.0f);
        if (depth < depthClamp) {
            float scale = (float)(depthClamp / depth);
            matrixStackOverlay.scale(scale, scale, scale);
        }
        this.drawIconInWorld(matrixStackOverlay, helper, w, settings, tessellator, fontrenderer, name, distance, textSize, showDistance, renderTypeBuffer, waypointBackgroundConsumer, isTheMain, subworldName);
    }

    public void drawIconInWorld(PoseStack matrixStack, MinimapRendererHelper helper, Waypoint w, ModSettings settings, Tesselator tessellator, Font fontrenderer, String name, String distance, float textSize, boolean showDistance, MultiBufferSource.BufferSource renderTypeBuffer, VertexConsumer waypointBackgroundConsumer, boolean isTheMain, String subworldName) {
        double iconScale = settings.getWaypointsIngameIconScale();
        double distanceScale = settings.getWaypointsIngameDistanceScale();
        double nameScale = settings.getWaypointsIngameNameScale();
        int ingameOpacity = settings.waypointOpacityIngame;
        int addedFrame = 0;
        if (Minecraft.getInstance().isEnforceUnicode()) {
            iconScale = (int)((iconScale + 1.0) / 2.0) * 2;
            distanceScale = (int)((distanceScale + 1.0) / 2.0) * 2;
            nameScale = (int)((nameScale + 1.0) / 2.0) * 2;
        }
        int c = ModSettings.COLORS[w.getColor()];
        float red = (float)(c >> 16 & 0xFF) / 255.0f;
        float green = (float)(c >> 8 & 0xFF) / 255.0f;
        float blue = (float)(c & 0xFF) / 255.0f;
        float alpha = 133.3f * ((float)ingameOpacity / 100.0f) / 255.0f;
        if (isTheMain) {
            alpha = Math.min(1.0f, alpha * 1.5f);
        }
        int halfIconPixel = (int)iconScale / 2;
        matrixStack.translate((float)halfIconPixel, 0.0f, 0.0f);
        matrixStack.scale((float)iconScale, (float)iconScale, 1.0f);
        if (w.getWaypointType() != 1) {
            int initialsWidth = fontrenderer.width(w.getSymbol());
            addedFrame = WaypointUtil.getAddedMinimapIconFrame(addedFrame, initialsWidth);
            this.renderColorBackground(matrixStack, addedFrame, red, green, blue, alpha, waypointBackgroundConsumer);
            Misc.drawNormalText(matrixStack, w.getSymbol(), (float)(-initialsWidth / 2), -8.0f, -1, false, renderTypeBuffer);
        } else {
            addedFrame = WaypointUtil.getAddedMinimapIconFrame(addedFrame, 7);
            this.renderColorBackground(matrixStack, addedFrame, red, green, blue, alpha, waypointBackgroundConsumer);
            VertexConsumer guiNearestConsumer = renderTypeBuffer.getBuffer(CustomRenderTypes.GUI_NEAREST);
            this.renderTexturedIcon(matrixStack, addedFrame, 0, 78, 0.9882f, 0.9882f, 0.9882f, 1.0f, guiNearestConsumer);
            if (!showDistance) {
                name = w.getLocalizedName();
            }
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        boolean showingName = name.length() > 0;
        matrixStack.scale((float)(1.0 / iconScale), (float)(1.0 / iconScale), 1.0f);
        matrixStack.translate((float)(-halfIconPixel), 0.0f, 0.0f);
        matrixStack.translate(0.0f, 2.0f, 0.0f);
        float labelAlpha = 0.3529412f;
        if ((showDistance || showingName) && subworldName != null) {
            this.renderWaypointLabel(matrixStack, helper, fontrenderer, subworldName, nameScale, labelAlpha, renderTypeBuffer, waypointBackgroundConsumer);
            matrixStack.translate(0.0f, 2.0f, 0.0f);
        }
        if (showingName) {
            this.renderWaypointLabel(matrixStack, helper, fontrenderer, name, nameScale, labelAlpha, renderTypeBuffer, waypointBackgroundConsumer);
        }
        matrixStack.translate(0.0f, 2.0f, 0.0f);
        if (distance.length() > 0) {
            this.renderWaypointLabel(matrixStack, helper, fontrenderer, distance, distanceScale, labelAlpha, renderTypeBuffer, waypointBackgroundConsumer);
        }
    }

    private void renderWaypointLabel(PoseStack matrixStack, MinimapRendererHelper helper, Font fontrenderer, String label, double labelScale, float bgAlpha, MultiBufferSource.BufferSource renderTypeBuffer, VertexConsumer waypointBackgroundConsumer) {
        int nameW = fontrenderer.width(label);
        int bgW = nameW + 3;
        int halfBgW = bgW / 2;
        int halfNamePixel = 0;
        if ((bgW & 1) != 0) {
            halfNamePixel = (int)labelScale - (int)labelScale / 2;
            matrixStack.translate((float)(-halfNamePixel), 0.0f, 0.0f);
        }
        matrixStack.scale((float)labelScale, (float)labelScale, 1.0f);
        helper.addColoredRectToExistingBuffer(matrixStack.last().pose(), waypointBackgroundConsumer, -halfBgW, 0.0f, bgW, 9, 0.0f, 0.0f, 0.0f, bgAlpha);
        Misc.drawNormalText(matrixStack, label, (float)(-halfBgW + 2), 1.0f, -1, false, renderTypeBuffer);
        matrixStack.translate(0.0f, 9.0f, 0.0f);
        matrixStack.scale((float)(1.0 / labelScale), (float)(1.0 / labelScale), 1.0f);
        if ((bgW & 1) != 0) {
            matrixStack.translate((float)halfNamePixel, 0.0f, 0.0f);
        }
        RenderSystem.enableBlend();
    }

    private void renderColorBackground(PoseStack matrixStack, int addedFrame, float r, float g, float b, float a, VertexConsumer waypointBackgroundConsumer) {
        Matrix4f matrix = matrixStack.last().pose();
        waypointBackgroundConsumer.addVertex(matrix, (float)(-5 - addedFrame), -9.0f, 0.0f).setColor(r, g, b, a);
        waypointBackgroundConsumer.addVertex(matrix, (float)(-5 - addedFrame), 0.0f, 0.0f).setColor(r, g, b, a);
        waypointBackgroundConsumer.addVertex(matrix, (float)(4 + addedFrame), 0.0f, 0.0f).setColor(r, g, b, a);
        waypointBackgroundConsumer.addVertex(matrix, (float)(4 + addedFrame), -9.0f, 0.0f).setColor(r, g, b, a);
    }

    private void renderTexturedIcon(PoseStack matrixStack, int addedFrame, int textureX, int textureY, float r, float g, float b, float a, VertexConsumer vertexBuffer) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Matrix4f matrix = matrixStack.last().pose();
        vertexBuffer.addVertex(matrix, (float)(-5 - addedFrame), (float)(-9 - addedFrame), 0.0f).setColor(r, g, b, a).setUv((float)textureX * f, (float)textureY * f1);
        vertexBuffer.addVertex(matrix, (float)(-5 - addedFrame), (float)addedFrame, 0.0f).setColor(r, g, b, a).setUv((float)textureX * f, (float)(textureY + 9 + addedFrame * 2) * f1);
        vertexBuffer.addVertex(matrix, (float)(4 + addedFrame), (float)addedFrame, 0.0f).setColor(r, g, b, a).setUv((float)(textureX + 9 + addedFrame * 2) * f, (float)(textureY + 9 + addedFrame * 2) * f1);
        vertexBuffer.addVertex(matrix, (float)(4 + addedFrame), (float)(-9 - addedFrame), 0.0f).setColor(r, g, b, a).setUv((float)(textureX + 9 + addedFrame * 2) * f, (float)textureY * f1);
    }
}

