/*
 * Decompiled with CFR 0.152.
 */
package gardensofthedead.block;

import gardensofthedead.block.SoulSporeBaseBlock;
import gardensofthedead.registry.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SoulSporeBlock
extends SoulSporeBaseBlock {
    public static final BooleanProperty TOP = BooleanProperty.create((String)"top");
    public static final BooleanProperty GROWING = BooleanProperty.create((String)"growing");
    public static final VoxelShape TOP_SHAPE_UP = SoulSporeBlock.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0);
    public static final VoxelShape TOP_SHAPE_DOWN = SoulSporeBlock.box((double)1.0, (double)8.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    public static final int MAX_LENGTH_LONG = 8;
    public static final int MAX_LENGTH_SHORT = 3;

    public SoulSporeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)TOP, (Comparable)Boolean.valueOf(true))).setValue((Property)GROWING, (Comparable)Boolean.valueOf(true)));
    }

    public static int getMaxLength(BlockState supportingBlock) {
        if (supportingBlock.is(Blocks.SOUL_SAND)) {
            return 8;
        }
        return 3;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{TOP, GROWING});
    }

    @Override
    public BlockState updateShape(BlockState state, Direction direction, BlockState newState, LevelAccessor level, BlockPos pos, BlockPos updatedPos) {
        if (direction == state.getValue((Property)DIRECTION) && (newState.is((Block)this) || newState.is((Block)ModBlocks.GLOWING_SOUL_SPORE.get())) && ((Boolean)state.getValue((Property)TOP)).booleanValue() && newState.getValue((Property)DIRECTION) == state.getValue((Property)DIRECTION)) {
            return (BlockState)((BlockState)state.setValue((Property)TOP, (Comparable)Boolean.valueOf(false))).setValue((Property)GROWING, (Comparable)Boolean.valueOf(true));
        }
        return super.updateShape(state, direction, newState, level, pos, updatedPos);
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (!state.hasProperty((Property)TOP) || !((Boolean)state.getValue((Property)TOP)).booleanValue()) {
            return super.getShape(state, level, pos, context);
        }
        if (state.hasProperty((Property)DIRECTION) && state.getValue((Property)DIRECTION) == Direction.UP) {
            return TOP_SHAPE_UP;
        }
        return TOP_SHAPE_DOWN;
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource randomSource) {
        Direction direction = (Direction)state.getValue((Property)DIRECTION);
        if (randomSource.nextFloat() < 0.1f && level.isEmptyBlock(pos.relative(direction))) {
            int length = 1;
            while (level.getBlockState(pos.relative(direction.getOpposite(), length)).is((Block)this)) {
                ++length;
            }
            BlockState supportingBlock = level.getBlockState(pos.relative(direction.getOpposite(), length));
            int maxLength = SoulSporeBlock.getMaxLength(supportingBlock);
            if (((Boolean)state.getValue((Property)TOP)).booleanValue() && (length >= maxLength || randomSource.nextInt(maxLength - length + 1) == 0)) {
                if (length > 1 && randomSource.nextInt(8) == 0) {
                    BlockState glowingSoulSpore = (BlockState)((SoulSporeBaseBlock)((Object)ModBlocks.GLOWING_SOUL_SPORE.get())).defaultBlockState().setValue((Property)DIRECTION, (Comparable)direction);
                    level.setBlockAndUpdate(pos, glowingSoulSpore);
                } else {
                    level.setBlock(pos, (BlockState)state.setValue((Property)GROWING, (Comparable)Boolean.valueOf(false)), 4);
                }
            } else {
                BlockState grownState = (BlockState)this.defaultBlockState().setValue((Property)DIRECTION, (Comparable)direction);
                level.setBlockAndUpdate(pos.relative(direction), grownState);
                level.setBlock(pos, (BlockState)state.setValue((Property)TOP, (Comparable)Boolean.valueOf(false)), 4);
            }
        }
    }

    public boolean isRandomlyTicking(BlockState state) {
        return (Boolean)state.getValue((Property)GROWING);
    }
}

