/*
 * Decompiled with CFR 0.152.
 */
package gardensofthedead.feature;

import com.mojang.serialization.Codec;
import gardensofthedead.feature.SoulSporeColumnFeature;
import gardensofthedead.feature.configuration.HugeFlatFungusConfiguration;
import gardensofthedead.registry.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class HugeFlatFungusFeature
extends Feature<HugeFlatFungusConfiguration> {
    public HugeFlatFungusFeature(Codec<HugeFlatFungusConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<HugeFlatFungusConfiguration> context) {
        WorldGenLevel level = context.level();
        BlockPos pos = context.origin();
        RandomSource randomsource = context.random();
        ChunkGenerator chunkgenerator = context.chunkGenerator();
        HugeFlatFungusConfiguration configuration = (HugeFlatFungusConfiguration)context.config();
        Block validBaseBlock = configuration.validBaseState().getBlock();
        BlockState supportingBlock = level.getBlockState(pos.below());
        if (!supportingBlock.is(validBaseBlock)) {
            return false;
        }
        int height = Mth.nextInt((RandomSource)randomsource, (int)4, (int)9);
        if (!configuration.planted()) {
            int maxHeight = chunkgenerator.getGenDepth();
            if (pos.getY() + height + 1 >= maxHeight) {
                return false;
            }
        }
        level.setBlock(pos, Blocks.AIR.defaultBlockState(), 4);
        this.placeStem(level, randomsource, configuration, pos, height);
        this.placeHat(level, randomsource, configuration, pos, height);
        return true;
    }

    private static boolean isReplaceable(WorldGenLevel level, BlockPos pos, HugeFlatFungusConfiguration configuration, boolean isTrunk) {
        if (level.isStateAtPosition(pos, BlockBehaviour.BlockStateBase::canBeReplaced)) {
            return true;
        }
        return isTrunk && configuration.replaceableBlocks().test((Object)level, (Object)pos);
    }

    private void placeStem(WorldGenLevel level, RandomSource randomSource, HugeFlatFungusConfiguration configuration, BlockPos origin, int height) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        BlockState stemState = configuration.stemState();
        for (int y = 0; y < height; ++y) {
            pos.setWithOffset((Vec3i)origin, 0, y, 0);
            if (!HugeFlatFungusFeature.isReplaceable(level, (BlockPos)pos, configuration, true)) continue;
            level.setBlock((BlockPos)pos, stemState, 3);
        }
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                boolean placed;
                boolean isCorner;
                if (x == 0 && z == 0) continue;
                boolean bl = isCorner = x != 0 && z != 0;
                if (!isCorner && randomSource.nextFloat() <= 0.75f || isCorner && randomSource.nextFloat() < 0.25f) {
                    pos.setWithOffset((Vec3i)origin, x, -1, z);
                    if (!level.isEmptyBlock((BlockPos)pos)) {
                        pos.move(Direction.UP);
                        placed = this.tryPlaceStem(level, pos, configuration);
                        if (!isCorner && placed && randomSource.nextFloat() < 0.25f) {
                            pos.setWithOffset((Vec3i)origin, x, 1, z);
                            this.tryPlaceStem(level, pos, configuration);
                        }
                    }
                }
                if (!(!isCorner && randomSource.nextFloat() <= 0.75f) && (!isCorner || !(randomSource.nextFloat() < 0.25f))) continue;
                pos.setWithOffset((Vec3i)origin, x, height - 1, z);
                placed = this.tryPlaceStem(level, pos, configuration);
                if (height <= 4 || isCorner || !placed || !(randomSource.nextFloat() < 0.25f)) continue;
                pos.setWithOffset((Vec3i)origin, x, height - 2, z);
                this.tryPlaceStem(level, pos, configuration);
            }
        }
    }

    private boolean tryPlaceStem(WorldGenLevel level, BlockPos.MutableBlockPos pos, HugeFlatFungusConfiguration configuration) {
        if (HugeFlatFungusFeature.isReplaceable(level, (BlockPos)pos, configuration, true)) {
            if (configuration.planted() && !level.getBlockState(pos.below()).isAir()) {
                level.destroyBlock((BlockPos)pos, true);
            }
            level.setBlock((BlockPos)pos, configuration.stemState(), 3);
            return true;
        }
        return false;
    }

    private void placeHat(WorldGenLevel level, RandomSource randomSource, HugeFlatFungusConfiguration configuration, BlockPos origin, int height) {
        float wobbliness = 0.1f + randomSource.nextFloat() * 0.15f;
        float wobbleAngle = randomSource.nextFloat() * (float)Math.PI * 2.0f;
        float size = (6.0f + randomSource.nextFloat() * 3.0f) / 2.0f;
        int maxSize = Mth.ceil((double)((double)size * 1.25));
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        boolean placeGlowingSpores = randomSource.nextFloat() < 0.4f;
        for (int x = -maxSize; x <= maxSize; ++x) {
            for (int z = -maxSize; z <= maxSize; ++z) {
                boolean isEdge;
                float angle = x == 0 && z == 0 ? 0.0f : (float)Mth.atan2((double)x, (double)z);
                float wobble = 1.0f + wobbliness * Mth.cos((float)(angle - wobbleAngle));
                float r = x * x + z * z;
                if (!(Mth.square((float)wobble) * r <= Mth.square((float)size))) continue;
                boolean bl = isEdge = (double)(Mth.square((float)wobble) * r) > Mth.square((double)((double)size - 1.5));
                if (isEdge) {
                    pos.setWithOffset((Vec3i)origin, x, height - 1, z);
                } else {
                    pos.setWithOffset((Vec3i)origin, x, height, z);
                }
                if (!HugeFlatFungusFeature.isReplaceable(level, (BlockPos)pos, configuration, false)) continue;
                if (configuration.planted() && !level.getBlockState(pos.below()).isAir()) {
                    level.destroyBlock((BlockPos)pos, true);
                }
                this.placeHatBlock(level, randomSource, configuration, pos, isEdge, placeGlowingSpores);
            }
        }
    }

    private void placeHatBlock(WorldGenLevel level, RandomSource randomSource, HugeFlatFungusConfiguration configuration, BlockPos.MutableBlockPos pos, boolean isEdge, boolean placeGlowingSpores) {
        this.setBlock((LevelWriter)level, (BlockPos)pos, configuration.hatState());
        float shroomlightChance = isEdge ? 0.0f : 0.05f;
        float hangingVineChance = isEdge ? 0.3f : 0.75f;
        float sproutChance = 0.2f;
        if (randomSource.nextFloat() < shroomlightChance) {
            if (level.isEmptyBlock(pos.below())) {
                this.setBlock((LevelWriter)level, pos.below(), Blocks.SHROOMLIGHT.defaultBlockState());
            }
        } else if (randomSource.nextFloat() < hangingVineChance) {
            HugeFlatFungusFeature.tryPlaceHangingSoulSpore((BlockPos)pos, (LevelAccessor)level, randomSource, isEdge, placeGlowingSpores);
        }
        if (randomSource.nextFloat() < sproutChance && level.isEmptyBlock(pos.above())) {
            this.setBlock((LevelWriter)level, pos.above(), ((Block)ModBlocks.SOULBLIGHT_SPROUTS.get()).defaultBlockState());
        }
    }

    private static void tryPlaceHangingSoulSpore(BlockPos pos, LevelAccessor level, RandomSource randomSource, boolean isEdge, boolean placeGlowingSpores) {
        BlockPos.MutableBlockPos below = pos.mutable().move(Direction.DOWN);
        if (level.isEmptyBlock((BlockPos)below)) {
            int length = Mth.nextInt((RandomSource)randomSource, (int)2, (int)3) + (isEdge ? 0 : 1);
            SoulSporeColumnFeature.placeSoulSporeColumn(level, randomSource, below, length, Direction.DOWN, isEdge && placeGlowingSpores ? 1.0f : 0.0f);
        }
    }
}

