/*
 * Decompiled with CFR 0.152.
 */
package gardensofthedead.neoforge;

import gardensofthedead.neoforge.datagen.BiomeProvider;
import gardensofthedead.neoforge.datagen.BiomeTagsProvider;
import gardensofthedead.neoforge.datagen.BlockStateProvider;
import gardensofthedead.neoforge.datagen.BlockTagsProvider;
import gardensofthedead.neoforge.datagen.ConfiguredFeatureProvider;
import gardensofthedead.neoforge.datagen.DataMapProvider;
import gardensofthedead.neoforge.datagen.ItemTagsProvider;
import gardensofthedead.neoforge.datagen.LootTableProvider;
import gardensofthedead.neoforge.datagen.PlacedFeatureProvider;
import gardensofthedead.neoforge.datagen.RecipeProvider;
import gardensofthedead.neoforge.datagen.SoundDefinitionsProvider;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import net.minecraft.core.Cloner;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.DataPackRegistriesHooks;

@EventBusSubscriber(modid="gardens_of_the_dead", bus=EventBusSubscriber.Bus.MOD)
public class GardensOfTheDeadData {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        PackOutput packOutput = event.getGenerator().getPackOutput();
        CompletionStage lookupProvider = event.getLookupProvider();
        BlockTagsProvider blockTagsProvider = new BlockTagsProvider(packOutput, (CompletableFuture<HolderLookup.Provider>)lookupProvider, existingFileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTagsProvider);
        generator.addProvider(event.includeClient(), (DataProvider)new BlockStateProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ItemTagsProvider(packOutput, (CompletableFuture<HolderLookup.Provider>)lookupProvider, blockTagsProvider.contentsGetter(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(packOutput, (CompletableFuture<HolderLookup.Provider>)lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new RecipeProvider(packOutput, (CompletableFuture<HolderLookup.Provider>)lookupProvider));
        generator.addProvider(event.includeClient(), (DataProvider)new SoundDefinitionsProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new DataMapProvider(packOutput, (CompletableFuture<HolderLookup.Provider>)lookupProvider));
        RegistrySetBuilder levelProvider = GardensOfTheDeadData.createLevelProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new DatapackBuiltinEntriesProvider(generator.getPackOutput(), event.getLookupProvider(), levelProvider, Set.of("gardens_of_the_dead")));
        lookupProvider = lookupProvider.thenApply(r -> GardensOfTheDeadData.constructRegistries(r, levelProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new BiomeTagsProvider(packOutput, (CompletableFuture<HolderLookup.Provider>)lookupProvider, existingFileHelper));
    }

    private static HolderLookup.Provider constructRegistries(HolderLookup.Provider original, RegistrySetBuilder datapackEntriesBuilder) {
        HashSet builderKeys = new HashSet(datapackEntriesBuilder.getEntryKeys());
        DataPackRegistriesHooks.getDataPackRegistriesWithDimensions().filter(data -> !builderKeys.contains(data.key())).forEach(data -> datapackEntriesBuilder.add(data.key(), context -> {}));
        Cloner.Factory factory = new Cloner.Factory();
        DataPackRegistriesHooks.getDataPackRegistriesWithDimensions().forEach(data -> data.runWithArguments((arg_0, arg_1) -> ((Cloner.Factory)factory).addCodec(arg_0, arg_1)));
        return datapackEntriesBuilder.buildPatch((RegistryAccess)RegistryAccess.fromRegistryOfRegistries((Registry)BuiltInRegistries.REGISTRY), original, factory).full();
    }

    public static RegistrySetBuilder createLevelProvider() {
        RegistrySetBuilder builder = new RegistrySetBuilder();
        builder.add(Registries.CONFIGURED_FEATURE, ConfiguredFeatureProvider::create);
        builder.add(Registries.PLACED_FEATURE, PlacedFeatureProvider::create);
        builder.add(Registries.BIOME, BiomeProvider::create);
        return builder;
    }
}

