/*
 * Decompiled with CFR 0.152.
 */
package gardensofthedead.neoforge.datagen;

import gardensofthedead.block.WallHangingSignBlock;
import gardensofthedead.block.WallSignBlock;
import gardensofthedead.loot.MatchShears;
import gardensofthedead.registry.ModBlocks;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class LootTableProvider
extends net.minecraft.data.loot.LootTableProvider {
    private final List<LootTableProvider.SubProviderEntry> lootTables = new ArrayList<LootTableProvider.SubProviderEntry>();
    private final Set<Block> blocksWithLootAdded = new HashSet<Block>();

    public LootTableProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> provider) {
        super(packOutput, Set.of(), List.of(), provider);
    }

    public List<LootTableProvider.SubProviderEntry> getTables() {
        this.lootTables.clear();
        this.blocksWithLootAdded.clear();
        BuiltInRegistries.BLOCK.keySet().stream().filter(k -> k.getNamespace().equals("gardens_of_the_dead")).map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.BLOCK).get(arg_0)).filter(block -> block instanceof WallSignBlock || block instanceof WallHangingSignBlock).forEach(xva$0 -> this.noLoot((Block)xva$0));
        this.addShearHarvestables((Block)ModBlocks.SOUL_SPORE.get(), (Block)ModBlocks.GLOWING_SOUL_SPORE.get(), (Block)ModBlocks.SOULBLIGHT_SPROUTS.get(), (Block)ModBlocks.BLISTERCROWN.get(), (Block)ModBlocks.TALL_BLISTERCROWN.get());
        this.addDefaultDrops((Block)ModBlocks.WHISTLECANE.get());
        block5: for (Block block2 : BuiltInRegistries.BLOCK.stream().toList()) {
            Block block3;
            if (this.blocksWithLootAdded.contains(block2) || !BuiltInRegistries.BLOCK.getKey((Object)block2).getNamespace().equals("gardens_of_the_dead")) continue;
            Objects.requireNonNull(block2);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FlowerPotBlock.class, DoorBlock.class, SlabBlock.class}, (Object)block3, n)) {
                case 0: {
                    FlowerPotBlock pottedPlant = (FlowerPotBlock)block3;
                    this.addPottedPlants(pottedPlant);
                    continue block5;
                }
                case 1: {
                    DoorBlock doorBlock = (DoorBlock)block3;
                    this.addDoor(doorBlock);
                    continue block5;
                }
                case 2: {
                    SlabBlock slabBlock = (SlabBlock)block3;
                    this.addSlab(slabBlock);
                    continue block5;
                }
            }
            this.addDefaultDrops(block2);
        }
        return this.lootTables;
    }

    private void addShearHarvestables(Block ... blocks) {
        for (Block block : blocks) {
            this.addBlockLootTable(block, LootTable.lootTable().withPool(LootPool.lootPool().add(LootItem.lootTableItem((ItemLike)block).when(MatchShears.matchShears()))));
        }
    }

    private void addPottedPlants(FlowerPotBlock ... blocks) {
        for (FlowerPotBlock block : blocks) {
            FlowerPotBlock emptyPot = block.getEmptyPot();
            Block content = block.getPotted();
            this.addBlockLootTable((Block)block, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)emptyPot)).when(ExplosionCondition.survivesExplosion())).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)content)).when(ExplosionCondition.survivesExplosion())));
        }
    }

    private void addDoor(DoorBlock block) {
        this.addBlockLootTable((Block)block, LootTable.lootTable().withPool(this.defaultDrops((ItemLike)block).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DoorBlock.HALF, (Comparable)DoubleBlockHalf.LOWER)))));
    }

    private void addSlab(SlabBlock block) {
        this.addBlockLootTable((Block)block, LootTable.lootTable().withPool(this.defaultDrops((ItemLike)block).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)2.0f)).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)SlabBlock.TYPE, (Comparable)SlabType.DOUBLE))))));
    }

    private void addDefaultDrops(Block block) {
        this.addDefaultDrops(block, (ItemLike)block);
    }

    private void addDefaultDrops(Block block, ItemLike loot) {
        this.addBlockLootTable(block, LootTable.lootTable().withPool(this.defaultDrops(loot)));
    }

    private LootPool.Builder defaultDrops(ItemLike itemProvider) {
        return LootPool.lootPool().when(ExplosionCondition.survivesExplosion()).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)itemProvider));
    }

    private void addBlockLootTable(Block block, LootTable.Builder lootTable) {
        this.blocksWithLootAdded.add(block);
        this.lootTables.add(new LootTableProvider.SubProviderEntry(provider -> lootBuilder -> lootBuilder.accept(block.getLootTable(), lootTable), LootContextParamSets.BLOCK));
    }

    private void noLoot(Block ... blocks) {
        this.blocksWithLootAdded.addAll(Set.of(blocks));
    }
}

