/*
 * Decompiled with CFR 0.152.
 */
package gardensofthedead.neoforge.datagen;

import gardensofthedead.neoforge.datagen.registry.ModBlockFamilies;
import gardensofthedead.registry.ModBlocks;
import gardensofthedead.registry.ModTags;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class RecipeProvider
extends net.minecraft.data.recipes.RecipeProvider {
    public RecipeProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(packOutput, lookupProvider);
    }

    protected void buildRecipes(RecipeOutput output) {
        this.generateForEnabledBlockFamilies(output, FeatureFlags.VANILLA_SET);
        this.addCraftingRecipes(output);
    }

    protected void generateForEnabledBlockFamilies(RecipeOutput consumer, FeatureFlagSet enabledFeatures) {
        ModBlockFamilies.getAllFamilies().filter(BlockFamily::shouldGenerateRecipe).forEach(family -> RecipeProvider.generateRecipes((RecipeOutput)consumer, (BlockFamily)family, (FeatureFlagSet)enabledFeatures));
    }

    private void addCraftingRecipes(RecipeOutput consumer) {
        RecipeProvider.woodFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)ModBlocks.SOULBLIGHT_HYPHAE.get()), (ItemLike)((ItemLike)ModBlocks.SOULBLIGHT_STEM.get()));
        RecipeProvider.woodFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)ModBlocks.STRIPPED_SOULBLIGHT_HYPHAE.get()), (ItemLike)((ItemLike)ModBlocks.STRIPPED_SOULBLIGHT_STEM.get()));
        RecipeProvider.planksFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)ModBlocks.SOULBLIGHT_PLANKS.get()), ModTags.Items.SOULBLIGHT_STEMS, (int)4);
        RecipeProvider.planksFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)ModBlocks.WHISTLECANE_PLANKS.get()), ModTags.Items.WHISTLECANE_BLOCKS, (int)2);
        this.whistlecaneBlock(consumer);
        RecipeProvider.blistercrown(consumer);
        RecipeProvider.mosaicBuilder((RecipeOutput)consumer, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModBlocks.WHISTLECANE_MOSAIC.get()), (ItemLike)((ItemLike)ModBlocks.WHISTLECANE_SLAB.get()));
        RecipeProvider.hangingSign((RecipeOutput)consumer, (ItemLike)((ItemLike)ModBlocks.SOULBLIGHT_HANGING_SIGN.get()), (ItemLike)((ItemLike)ModBlocks.STRIPPED_SOULBLIGHT_STEM.get()));
        RecipeProvider.hangingSign((RecipeOutput)consumer, (ItemLike)((ItemLike)ModBlocks.WHISTLECANE_HANGING_SIGN.get()), (ItemLike)((ItemLike)ModBlocks.WHISTLECANE_BLOCK.get()));
    }

    protected void whistlecaneBlock(RecipeOutput output) {
        Block whistlecane = (Block)ModBlocks.WHISTLECANE.get();
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.WHISTLECANE_BLOCK.get())).define(Character.valueOf('#'), (ItemLike)whistlecane).pattern("##").pattern("##").unlockedBy("has_whistlecane", RecipeProvider.has((ItemLike)whistlecane)).save(output);
    }

    protected static void blistercrown(RecipeOutput output) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModBlocks.BLISTERCROWN.get()), (int)3).requires((ItemLike)ModBlocks.TALL_BLISTERCROWN.get()).unlockedBy("has_blistercrown", RecipeProvider.has((ItemLike)((ItemLike)ModBlocks.TALL_BLISTERCROWN.get()))).save(output);
    }
}

