/*
 * Decompiled with CFR 0.152.
 */
package gardensofthedead.placementmodifier;

import com.mojang.serialization.MapCodec;
import gardensofthedead.registry.ModPlacementModifiers;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class CountOnEveryCeilingPlacement
extends PlacementModifier {
    public static final MapCodec<CountOnEveryCeilingPlacement> CODEC = IntProvider.codec((int)0, (int)256).fieldOf("count").xmap(CountOnEveryCeilingPlacement::new, placementModifier -> placementModifier.count);
    private final IntProvider count;

    private CountOnEveryCeilingPlacement(IntProvider count) {
        this.count = count;
    }

    public static CountOnEveryCeilingPlacement of(IntProvider count) {
        return new CountOnEveryCeilingPlacement(count);
    }

    public static CountOnEveryCeilingPlacement of(int count) {
        return CountOnEveryCeilingPlacement.of((IntProvider)ConstantInt.of((int)count));
    }

    public Stream<BlockPos> getPositions(PlacementContext context, RandomSource randomSource, BlockPos pos) {
        boolean flag;
        Stream.Builder<BlockPos> builder = Stream.builder();
        int layer = 0;
        do {
            flag = false;
            for (int j = 0; j < this.count.sample(randomSource); ++j) {
                int z;
                int y;
                int x = randomSource.nextInt(16) + pos.getX();
                int j1 = CountOnEveryCeilingPlacement.findOnGroundYPosition(context, x, y = context.getHeight(Heightmap.Types.MOTION_BLOCKING, x, z = randomSource.nextInt(16) + pos.getZ()), z, layer);
                if (j1 == Integer.MAX_VALUE) continue;
                builder.add(new BlockPos(x, j1, z));
                flag = true;
            }
            ++layer;
        } while (flag);
        return builder.build();
    }

    public PlacementModifierType<?> type() {
        return (PlacementModifierType)ModPlacementModifiers.COUNT_ON_EVERY_CEILING.get();
    }

    private static int findOnGroundYPosition(PlacementContext context, int xOrigin, int yOrigin, int zOrigin, int maxDepth) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(xOrigin, yOrigin, zOrigin);
        int layer = 0;
        BlockState previousState = context.getBlockState((BlockPos)pos);
        for (int y = yOrigin; y >= context.getMinBuildHeight() + 1; --y) {
            pos.setY(y - 1);
            BlockState currentState = context.getBlockState((BlockPos)pos);
            if (!CountOnEveryCeilingPlacement.isEmpty(previousState) && CountOnEveryCeilingPlacement.isEmpty(currentState) && !previousState.is(Blocks.BEDROCK)) {
                if (layer == maxDepth) {
                    return pos.getY();
                }
                ++layer;
            }
            previousState = currentState;
        }
        return Integer.MAX_VALUE;
    }

    private static boolean isEmpty(BlockState state) {
        return state.isAir() || state.is(Blocks.WATER) || state.is(Blocks.LAVA);
    }
}

