/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.charmofundying;

import com.illusivesoulworks.charmofundying.common.ITotemEffectProvider;
import com.illusivesoulworks.charmofundying.common.TotemProviders;
import com.illusivesoulworks.charmofundying.platform.Services;
import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class CharmOfUndyingCommonMod {
    public static void init() {
        TotemProviders.init();
    }

    public static Optional<Pair<ITotemEffectProvider, ItemStack>> getEffectProvider(LivingEntity livingEntity) {
        Optional<ITotemEffectProvider> totemEffectProvider;
        ItemStack stack = Services.PLATFORM.findTotem(livingEntity);
        if (!stack.isEmpty() && (totemEffectProvider = TotemProviders.getEffectProvider(stack.getItem())).isPresent()) {
            return Optional.of(Pair.of((Object)totemEffectProvider.get(), (Object)stack));
        }
        return Optional.empty();
    }

    public static boolean useTotem(Pair<ITotemEffectProvider, ItemStack> totem, DamageSource damageSource, LivingEntity livingEntity) {
        ItemStack stack = (ItemStack)totem.getSecond();
        ITotemEffectProvider effectProvider = (ITotemEffectProvider)totem.getFirst();
        if (!stack.isEmpty()) {
            ItemStack copy = stack.copy();
            effectProvider.modifyStack(stack);
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)livingEntity;
                player.awardStat(Stats.ITEM_USED.get((Object)copy.getItem()), 1);
                CriteriaTriggers.USED_TOTEM.trigger(player, copy);
            }
            if (effectProvider.applyEffects(livingEntity, damageSource, copy)) {
                Services.PLATFORM.broadcastTotemEvent(livingEntity, copy);
                return true;
            }
        }
        return false;
    }
}

