/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block;

import com.jaquadro.minecraft.storagedrawers.api.storage.INetworked;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.EnumKeyType;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityController;
import com.jaquadro.minecraft.storagedrawers.config.CommonConfig;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import com.jaquadro.minecraft.storagedrawers.util.WorldUtils;
import com.mojang.serialization.MapCodec;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class BlockController
extends HorizontalDirectionalBlock
implements INetworked,
EntityBlock {
    public static final MapCodec<BlockController> CODEC = BlockController.simpleCodec(BlockController::new);

    public BlockController(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public MapCodec<BlockController> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    @NotNull
    public InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hit) {
        Direction blockDir = (Direction)state.getValue((Property)FACING);
        BlockEntityController blockEntity = WorldUtils.getBlockEntity((BlockGetter)level, pos, BlockEntityController.class);
        if (blockEntity == null) {
            return InteractionResult.FAIL;
        }
        ItemStack item = player.getInventory().getSelected();
        if (!item.isEmpty() && this.toggle(level, pos, player, item.getItem())) {
            return InteractionResult.SUCCESS;
        }
        if (blockDir != hit.getDirection()) {
            return InteractionResult.CONSUME;
        }
        if (!level.isClientSide) {
            if (((Boolean)CommonConfig.GENERAL.debugTrace.get()).booleanValue() && item.isEmpty()) {
                blockEntity.printDebugInfo();
            }
            blockEntity.interactPutItemsIntoInventory(player);
        }
        return InteractionResult.SUCCESS;
    }

    public boolean toggle(Level world, BlockPos pos, Player player, Item item) {
        if (world.isClientSide || item == null) {
            return false;
        }
        if (item == ModItems.DRAWER_KEY.get()) {
            this.toggle(world, pos, player, EnumKeyType.DRAWER);
        } else if (item == ModItems.SHROUD_KEY.get()) {
            this.toggle(world, pos, player, EnumKeyType.CONCEALMENT);
        } else if (item == ModItems.QUANTIFY_KEY.get()) {
            this.toggle(world, pos, player, EnumKeyType.QUANTIFY);
        } else {
            return false;
        }
        return true;
    }

    public void toggle(@NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull EnumKeyType keyType) {
        if (level.isClientSide) {
            return;
        }
        BlockEntityController blockEntity = WorldUtils.getBlockEntity((BlockGetter)level, pos, BlockEntityController.class);
        if (blockEntity == null) {
            return;
        }
        switch (keyType) {
            case DRAWER: {
                blockEntity.toggleLock(EnumSet.allOf(LockAttribute.class), LockAttribute.LOCK_POPULATED, player.getGameProfile());
                break;
            }
            case CONCEALMENT: {
                blockEntity.toggleShroud(player.getGameProfile());
                break;
            }
            case QUANTIFY: {
                blockEntity.toggleQuantified(player.getGameProfile());
            }
        }
    }

    public void tick(@NotNull BlockState state, @NotNull ServerLevel world, @NotNull BlockPos pos, @NotNull RandomSource rand) {
        if (world.isClientSide) {
            return;
        }
        BlockEntityController blockEntity = WorldUtils.getBlockEntity((BlockGetter)world, pos, BlockEntityController.class);
        if (blockEntity == null) {
            return;
        }
        blockEntity.updateCache();
        world.scheduleTick(pos, (Block)this, 100);
    }

    public BlockEntityController newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new BlockEntityController(pos, state);
    }
}

