/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.storage.BlockType;
import com.jaquadro.minecraft.storagedrawers.api.storage.EmptyDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributesModifiable;
import com.jaquadro.minecraft.storagedrawers.api.storage.INetworked;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.BlockCompDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.capabilities.CapabilityDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.config.CommonConfig;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import com.jaquadro.minecraft.storagedrawers.inventory.ContainerDrawers1;
import com.jaquadro.minecraft.storagedrawers.inventory.ContainerDrawers2;
import com.jaquadro.minecraft.storagedrawers.inventory.ContainerDrawers4;
import com.jaquadro.minecraft.storagedrawers.inventory.ContainerDrawersComp;
import com.jaquadro.minecraft.storagedrawers.item.ItemKey;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgrade;
import com.jaquadro.minecraft.storagedrawers.util.WorldUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BlockDrawers
extends HorizontalDirectionalBlock
implements INetworked,
EntityBlock {
    private static final VoxelShape AABB_NORTH_FULL = Shapes.join((VoxelShape)Shapes.block(), (VoxelShape)Block.box((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)1.0), (BooleanOp)BooleanOp.ONLY_FIRST);
    private static final VoxelShape AABB_SOUTH_FULL = Shapes.join((VoxelShape)Shapes.block(), (VoxelShape)Block.box((double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0, (double)16.0), (BooleanOp)BooleanOp.ONLY_FIRST);
    private static final VoxelShape AABB_WEST_FULL = Shapes.join((VoxelShape)Shapes.block(), (VoxelShape)Block.box((double)0.0, (double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0), (BooleanOp)BooleanOp.ONLY_FIRST);
    private static final VoxelShape AABB_EAST_FULL = Shapes.join((VoxelShape)Shapes.block(), (VoxelShape)Block.box((double)15.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0, (double)15.0), (BooleanOp)BooleanOp.ONLY_FIRST);
    private static final VoxelShape AABB_NORTH_HALF = Block.box((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape AABB_SOUTH_HALF = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    private static final VoxelShape AABB_WEST_HALF = Block.box((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape AABB_EAST_HALF = Block.box((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0);
    private final int drawerCount;
    private final boolean halfDepth;
    private final int storageUnits;
    public final AABB[] slotGeometry;
    public final AABB[] countGeometry;
    public final AABB[] labelGeometry;
    public final AABB[] indGeometry;
    public final AABB[] indBaseGeometry;
    private long ignoreEventTime;

    public BlockDrawers(int drawerCount, boolean halfDepth, int storageUnits, BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
        this.drawerCount = drawerCount;
        this.halfDepth = halfDepth;
        this.storageUnits = storageUnits;
        this.slotGeometry = new AABB[drawerCount];
        this.countGeometry = new AABB[drawerCount];
        this.labelGeometry = new AABB[drawerCount];
        this.indGeometry = new AABB[drawerCount];
        this.indBaseGeometry = new AABB[drawerCount];
        for (int i = 0; i < drawerCount; ++i) {
            this.slotGeometry[i] = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            this.countGeometry[i] = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            this.labelGeometry[i] = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            this.indGeometry[i] = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            this.indBaseGeometry[i] = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public boolean retrimBlock(Level world, BlockPos pos, ItemStack prototype) {
        return false;
    }

    public BlockType retrimType() {
        return BlockType.Drawers;
    }

    public int getDrawerCount() {
        return this.drawerCount;
    }

    public boolean isHalfDepth() {
        return this.halfDepth;
    }

    public int getStorageUnits() {
        return this.storageUnits;
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        switch (direction) {
            case EAST: {
                return this.halfDepth ? AABB_EAST_HALF : AABB_EAST_FULL;
            }
            case WEST: {
                return this.halfDepth ? AABB_WEST_HALF : AABB_WEST_FULL;
            }
            case SOUTH: {
                return this.halfDepth ? AABB_SOUTH_HALF : AABB_SOUTH_FULL;
            }
        }
        return this.halfDepth ? AABB_NORTH_HALF : AABB_NORTH_FULL;
    }

    public boolean isPathfindable(@NotNull BlockState state, @NotNull PathComputationType type) {
        return false;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public void setPlacedBy(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity entity, @NotNull ItemStack stack) {
        BlockEntityDrawers blockEntity = WorldUtils.getBlockEntity((BlockGetter)world, pos, BlockEntityDrawers.class);
        if (blockEntity == null) {
            return;
        }
        CustomData customdata = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA);
        if (customdata != null) {
            blockEntity.readPortable((HolderLookup.Provider)world.registryAccess(), customdata.copyTag());
        }
        if (entity != null && entity.getOffhandItem().getItem() == ModItems.DRAWER_KEY.get()) {
            IDrawerAttributes _attrs = blockEntity.getCapability(CapabilityDrawerAttributes.DRAWER_ATTRIBUTES_CAPABILITY);
            if (_attrs == null) {
                _attrs = new EmptyDrawerAttributes();
            }
            if (_attrs instanceof IDrawerAttributesModifiable) {
                IDrawerAttributesModifiable attrs = (IDrawerAttributesModifiable)_attrs;
                attrs.setItemLocked(LockAttribute.LOCK_EMPTY, true);
                attrs.setItemLocked(LockAttribute.LOCK_POPULATED, true);
            }
        }
    }

    protected final int getDrawerSlot(@NotNull BlockState state, @NotNull BlockHitResult hit) {
        Direction side = hit.getDirection();
        if (state.getValue((Property)FACING) != side) {
            return -1;
        }
        return this.getDrawerSlot(hit.getDirection(), BlockDrawers.normalizeHitVec(hit.getLocation()));
    }

    @NotNull
    private static Vec3 normalizeHitVec(@NotNull Vec3 hit) {
        return new Vec3((hit.x < 0.0 ? hit.x - Math.floor(hit.x) : hit.x) % 1.0, (hit.y < 0.0 ? hit.y - Math.floor(hit.y) : hit.y) % 1.0, (hit.z < 0.0 ? hit.z - Math.floor(hit.z) : hit.z) % 1.0);
    }

    protected int getDrawerSlot(Direction correctSide, @NotNull Vec3 normalizedHit) {
        return -1;
    }

    protected boolean hitAny(Direction side, Vec3 normalizedHit) {
        if (side == Direction.NORTH || side == Direction.SOUTH) {
            return 0.0625 < normalizedHit.x && normalizedHit.x < 0.9375 && 0.0625 < normalizedHit.y && normalizedHit.y < 0.9375;
        }
        if (side == Direction.EAST || side == Direction.WEST) {
            return 0.0625 < normalizedHit.z && normalizedHit.z < 0.9375 && 0.0625 < normalizedHit.y && normalizedHit.y < 0.9375;
        }
        return false;
    }

    protected boolean hitTop(@NotNull Vec3 normalizedHit) {
        return normalizedHit.y > 0.5;
    }

    protected boolean hitLeft(Direction side, @NotNull Vec3 normalizedHit) {
        return switch (side) {
            case Direction.NORTH -> {
                if (normalizedHit.x > 0.5) {
                    yield true;
                }
                yield false;
            }
            case Direction.SOUTH -> {
                if (normalizedHit.x < 0.5) {
                    yield true;
                }
                yield false;
            }
            case Direction.WEST -> {
                if (normalizedHit.z < 0.5) {
                    yield true;
                }
                yield false;
            }
            case Direction.EAST -> {
                if (normalizedHit.z > 0.5) {
                    yield true;
                }
                yield false;
            }
            default -> true;
        };
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack item = player.getItemInHand(hand);
        if (hand == InteractionHand.OFF_HAND) {
            return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
        }
        if (level.isClientSide && Util.getMillis() == this.ignoreEventTime) {
            this.ignoreEventTime = 0L;
            return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
        }
        return this.insertOrApplyItem(state, level, pos, player, hit);
    }

    public void attack(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos blockPos, @NotNull Player player) {
        BlockHitResult hit = WorldUtils.rayTraceEyes(level, player, blockPos);
        if (hit.getType() != HitResult.Type.BLOCK) {
            return;
        }
        if (!hit.getBlockPos().equals((Object)blockPos)) {
            return;
        }
        this.interactTakeItems(state, level, blockPos, player, hit);
    }

    public ItemInteractionResult insertOrApplyItem(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos blockPos, @NotNull Player player, @NotNull BlockHitResult hit) {
        int slot;
        ItemStack item = player.getItemInHand(InteractionHand.MAIN_HAND);
        final BlockEntityDrawers blockEntityDrawers = WorldUtils.getBlockEntity((BlockGetter)level, blockPos, BlockEntityDrawers.class);
        if (blockEntityDrawers == null) {
            return ItemInteractionResult.FAIL;
        }
        if (((Boolean)CommonConfig.GENERAL.debugTrace.get()).booleanValue()) {
            StorageDrawers.log.info("BlockDrawers.onBlockActivated");
            StorageDrawers.log.info((String)(item.isEmpty() ? "  null item" : "  " + item.toString()));
        }
        if (!item.isEmpty()) {
            if (item.getItem() instanceof ItemKey) {
                return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
            }
            if (item.getItem() instanceof ItemUpgrade) {
                if (!blockEntityDrawers.upgrades().canAddUpgrade(item)) {
                    if (!level.isClientSide) {
                        player.displayClientMessage((Component)Component.translatable((String)"message.storagedrawers.cannot_add_upgrade"), true);
                    }
                    return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
                }
                if (!blockEntityDrawers.upgrades().addUpgrade(item)) {
                    if (!level.isClientSide) {
                        player.displayClientMessage((Component)Component.translatable((String)"message.storagedrawers.max_upgrades"), true);
                    }
                    return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
                }
                level.sendBlockUpdated(blockPos, state, state, 3);
                if (!player.isCreative()) {
                    item.shrink(1);
                    if (item.getCount() <= 0) {
                        player.getInventory().setItem(player.getInventory().selected, ItemStack.EMPTY);
                    }
                }
                return ItemInteractionResult.SUCCESS;
            }
        } else if (item.isEmpty() && player.isShiftKeyDown() && ((Boolean)CommonConfig.GENERAL.enableUI.get()).booleanValue() && !level.isClientSide) {
            player.openMenu(new MenuProvider(){

                @NotNull
                public Component getDisplayName() {
                    return Component.translatable((String)BlockDrawers.this.getDescriptionId());
                }

                @Nullable
                public AbstractContainerMenu createMenu(int windowId, @NotNull Inventory playerInv, @NotNull Player playerEntity) {
                    if (BlockDrawers.this.drawerCount == 1) {
                        return new ContainerDrawers1(windowId, playerInv, blockEntityDrawers);
                    }
                    if (BlockDrawers.this.drawerCount == 2) {
                        return new ContainerDrawers2(windowId, playerInv, blockEntityDrawers);
                    }
                    if (BlockDrawers.this.drawerCount == 4) {
                        return new ContainerDrawers4(windowId, playerInv, blockEntityDrawers);
                    }
                    if (BlockDrawers.this.drawerCount == 3 && BlockDrawers.this instanceof BlockCompDrawers) {
                        return new ContainerDrawersComp(windowId, playerInv, blockEntityDrawers);
                    }
                    return null;
                }
            }, extraData -> extraData.writeBlockPos(blockPos));
            return ItemInteractionResult.SUCCESS;
        }
        if ((slot = this.getDrawerSlot(state, hit)) < 0) {
            return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
        }
        blockEntityDrawers.interactPutItemsIntoSlot(slot, player);
        if (item.isEmpty()) {
            player.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
        }
        return ItemInteractionResult.SUCCESS;
    }

    public boolean interactTakeItems(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos blockPos, @NotNull Player player, @NotNull BlockHitResult hit) {
        if (((Boolean)CommonConfig.GENERAL.debugTrace.get()).booleanValue()) {
            StorageDrawers.log.info("onBlockClicked");
        }
        if (!(state.getBlock() instanceof BlockDrawers)) {
            return false;
        }
        BlockEntityDrawers blockEntityDrawers = WorldUtils.getBlockEntity((BlockGetter)level, blockPos, BlockEntityDrawers.class);
        if (blockEntityDrawers == null) {
            return false;
        }
        if (level.getBlockState(blockPos) != state) {
            return false;
        }
        int slot = this.getDrawerSlot(state, hit);
        if (slot < 0) {
            return false;
        }
        IDrawer drawer = blockEntityDrawers.getDrawer(slot);
        ItemStack item = player.isShiftKeyDown() ? blockEntityDrawers.takeItemsFromSlot(slot, drawer.getStoredItemStackSize()) : blockEntityDrawers.takeItemsFromSlot(slot, 1);
        if (((Boolean)CommonConfig.GENERAL.debugTrace.get()).booleanValue()) {
            StorageDrawers.log.info((String)(item.isEmpty() ? "  null item" : "  " + String.valueOf(item)));
        }
        if (!item.isEmpty()) {
            if (!player.getInventory().add(item)) {
                this.dropItemStack(level, blockPos.relative(hit.getDirection()), player, item);
                level.sendBlockUpdated(blockPos, state, state, 3);
            } else {
                level.playSound(null, blockPos, SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, ((level.random.nextFloat() - level.random.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            }
        }
        return true;
    }

    private void dropItemStack(@NotNull Level world, @NotNull BlockPos pos, @NotNull Player player, @NotNull ItemStack stack) {
        ItemEntity entity = new ItemEntity(world, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.3f), (double)((float)pos.getZ() + 0.5f), stack);
        Vec3 motion = entity.getDeltaMovement();
        entity.push(-motion.x, -motion.y, -motion.z);
        world.addFreshEntity((Entity)entity);
    }

    @NotNull
    public List<ItemStack> getDrops(@NotNull BlockState state, LootParams.Builder builder) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        items.add(this.getMainDrop(state, (BlockEntityDrawers)builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY)));
        return items;
    }

    protected ItemStack getMainDrop(BlockState state, BlockEntityDrawers tile) {
        int i;
        ItemStack drop = new ItemStack((ItemLike)this);
        if (tile == null) {
            return drop;
        }
        boolean hasContents = false;
        for (i = 0; i < tile.getGroup().getDrawerCount(); ++i) {
            IDrawer drawer = tile.getGroup().getDrawer(i);
            if (drawer.isEmpty()) continue;
            hasContents = true;
        }
        for (i = 0; i < tile.upgrades().getSlotCount(); ++i) {
            if (tile.upgrades().getUpgrade(i).isEmpty()) continue;
            hasContents = true;
        }
        if (hasContents) {
            CompoundTag tiledata = tile.saveWithId((HolderLookup.Provider)tile.getLevel().registryAccess());
            drop.set(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.of((CompoundTag)tiledata));
        }
        return drop;
    }

    public boolean isSignalSource(@NotNull BlockState state) {
        return true;
    }

    public int getSignal(@NotNull BlockState state, @NotNull BlockGetter blockAccess, @NotNull BlockPos pos, @NotNull Direction side) {
        if (!this.isSignalSource(state)) {
            return 0;
        }
        BlockEntityDrawers blockEntity = WorldUtils.getBlockEntity(blockAccess, pos, BlockEntityDrawers.class);
        if (blockEntity == null || !blockEntity.isRedstone()) {
            return 0;
        }
        return blockEntity.getRedstoneLevel();
    }

    public int getDirectSignal(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull Direction side) {
        return side == Direction.UP ? this.getSignal(state, worldIn, pos, side) : 0;
    }

    public boolean useShapeForLightOcclusion(@NotNull BlockState state) {
        return true;
    }
}

