/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block;

import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawersStandard;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockStandardDrawers
extends BlockDrawers {
    public static final MapCodec<BlockStandardDrawers> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("drawerCount").forGetter(BlockDrawers::getDrawerCount), (App)Codec.BOOL.fieldOf("halfDepth").forGetter(BlockDrawers::isHalfDepth), (App)Codec.INT.fieldOf("storageUnits").forGetter(BlockDrawers::getStorageUnits), (App)BlockStandardDrawers.propertiesCodec()).apply((Applicative)instance, BlockStandardDrawers::new));

    public BlockStandardDrawers(int drawerCount, boolean halfDepth, int storageUnits, BlockBehaviour.Properties properties) {
        super(drawerCount, halfDepth, storageUnits, properties);
    }

    public BlockStandardDrawers(int drawerCount, boolean halfDepth, BlockBehaviour.Properties properties) {
        super(drawerCount, halfDepth, BlockStandardDrawers.calcUnits(drawerCount, halfDepth), properties);
    }

    private static int calcUnits(int drawerCount, boolean halfDepth) {
        return halfDepth ? 4 / drawerCount : 8 / drawerCount;
    }

    public MapCodec<BlockStandardDrawers> codec() {
        return CODEC;
    }

    @Override
    protected int getDrawerSlot(Direction correctSide, @NotNull Vec3 normalizedHit) {
        if (!this.hitAny(correctSide, normalizedHit)) {
            return super.getDrawerSlot(correctSide, normalizedHit);
        }
        if (this.getDrawerCount() == 1) {
            return 0;
        }
        boolean hitTop = this.hitTop(normalizedHit);
        if (this.getDrawerCount() == 2) {
            return hitTop ? 0 : 1;
        }
        if (this.getDrawerCount() == 4) {
            if (this.hitLeft(correctSide, normalizedHit)) {
                return hitTop ? 0 : 2;
            }
            return hitTop ? 1 : 3;
        }
        return super.getDrawerSlot(correctSide, normalizedHit);
    }

    @Nullable
    public BlockEntityDrawers newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return BlockEntityDrawersStandard.createEntity(this.getDrawerCount(), pos, state);
    }
}

