/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.BlockEntityDataShim;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class BaseBlockEntity
extends BlockEntity {
    private CompoundTag failureSnapshot;
    private List<BlockEntityDataShim> fixedShims;
    private List<BlockEntityDataShim> portableShims;

    public BaseBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
    }

    public boolean hasDataPacket() {
        return true;
    }

    public boolean dataPacketRequiresRenderUpdate() {
        return false;
    }

    public void injectData(BlockEntityDataShim shim) {
        if (this.fixedShims == null) {
            this.fixedShims = new ArrayList<BlockEntityDataShim>();
        }
        this.fixedShims.add(shim);
    }

    public void injectPortableData(BlockEntityDataShim shim) {
        if (this.portableShims == null) {
            this.portableShims = new ArrayList<BlockEntityDataShim>();
        }
        this.portableShims.add(shim);
    }

    public final void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.readFixed(registries, tag);
        this.readPortable(registries, tag);
    }

    public final void read(CompoundTag tag, HolderLookup.Provider registries) {
        this.loadAdditional(tag, registries);
    }

    protected void saveAdditional(@NotNull CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag = this.writeFixed(registries, tag);
        this.writePortable(registries, tag);
    }

    public void readPortable(HolderLookup.Provider provider, CompoundTag tag) {
        if (this.portableShims != null) {
            for (BlockEntityDataShim shim : this.portableShims) {
                shim.read(provider, tag);
            }
        }
    }

    public CompoundTag writePortable(HolderLookup.Provider provider, CompoundTag tag) {
        if (this.portableShims != null) {
            for (BlockEntityDataShim shim : this.portableShims) {
                tag = shim.write(provider, tag);
            }
        }
        return tag;
    }

    protected void readFixed(HolderLookup.Provider provider, CompoundTag tag) {
        if (this.fixedShims != null) {
            for (BlockEntityDataShim shim : this.fixedShims) {
                shim.read(provider, tag);
            }
        }
    }

    protected CompoundTag writeFixed(HolderLookup.Provider provider, CompoundTag tag) {
        if (this.fixedShims != null) {
            for (BlockEntityDataShim shim : this.fixedShims) {
                tag = shim.write(provider, tag);
            }
        }
        return tag;
    }

    private void trapLoadFailure(Throwable t, CompoundTag tag) {
        this.failureSnapshot = tag.copy();
        StorageDrawers.log.error("Tile Load Failure.", t);
    }

    private void restoreLoadFailure(CompoundTag tag) {
        for (String key : this.failureSnapshot.getAllKeys()) {
            if (tag.contains(key)) continue;
            tag.put(key, this.failureSnapshot.get(key).copy());
        }
    }

    protected boolean loadDidFail() {
        return this.failureSnapshot != null;
    }

    @NotNull
    public final CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveCustomOnly(provider);
    }

    public final ClientboundBlockEntityDataPacket getUpdatePacket() {
        return this.hasDataPacket() ? ClientboundBlockEntityDataPacket.create((BlockEntity)this) : null;
    }

    public final void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        if (pkt != null && pkt.getTag() != null) {
            this.read(pkt.getTag(), lookupProvider);
        }
        if (this.getLevel() != null && this.getLevel().isClientSide && this.dataPacketRequiresRenderUpdate()) {
            BlockState state = this.getLevel().getBlockState(this.getBlockPos());
            this.getLevel().sendBlockUpdated(this.getBlockPos(), state, state, 3);
        }
    }

    public void markBlockForUpdate() {
        if (this.getLevel() != null && !this.getLevel().isClientSide) {
            BlockState state = this.getLevel().getBlockState(this.worldPosition);
            this.getLevel().sendBlockUpdated(this.worldPosition, state, state, 3);
        }
    }

    public void markBlockForUpdateClient() {
        if (this.getLevel() != null && this.getLevel().isClientSide) {
            BlockState state = this.getLevel().getBlockState(this.worldPosition);
            this.getLevel().sendBlockUpdated(this.worldPosition, state, state, 3);
        }
    }

    public void markBlockForRenderUpdate() {
        if (this.getLevel() == null) {
            return;
        }
        BlockState state = this.getLevel().getBlockState(this.worldPosition);
        this.getLevel().sendBlockUpdated(this.worldPosition, state, state, 2);
    }
}

