/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributesModifiable;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.BaseBlockEntity;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.UpgradeData;
import com.jaquadro.minecraft.storagedrawers.capabilities.BasicDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.config.CommonConfig;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import com.jaquadro.minecraft.storagedrawers.item.EnumUpgradeRedstone;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeStorage;
import com.jaquadro.minecraft.storagedrawers.network.CountUpdateMessage;
import java.util.EnumSet;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public abstract class BlockEntityDrawers
extends BaseBlockEntity
implements IDrawerGroup {
    public static final ModelProperty<IDrawerAttributes> ATTRIBUTES = new ModelProperty();
    private final UpgradeData upgradeData = new DrawerUpgradeData();
    private final IDrawerAttributesModifiable drawerAttributes = new DrawerAttributes();
    private long lastClickTime;
    private UUID lastClickUUID;
    private boolean loading;

    protected BlockEntityDrawers(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
        this.upgradeData.setDrawerAttributes(this.drawerAttributes);
        this.injectPortableData(this.upgradeData);
    }

    @NotNull
    public abstract IDrawerGroup getGroup();

    public static IDrawerGroup getGroup(BlockEntityDrawers be) {
        if (be == null) {
            return null;
        }
        return be.getGroup();
    }

    @NotNull
    public IDrawerAttributes getDrawerAttributes() {
        return this.drawerAttributes;
    }

    public static IDrawerAttributes getDrawerAttributes(BlockEntityDrawers be) {
        if (be == null) {
            return null;
        }
        return be.getDrawerAttributes();
    }

    public UpgradeData upgrades() {
        return this.upgradeData;
    }

    @Override
    public boolean isGroupValid() {
        return !this.isRemoved();
    }

    public int getDrawerCapacity() {
        Block block = this.getBlockState().getBlock();
        if (!(block instanceof BlockDrawers)) {
            return 0;
        }
        return ((BlockDrawers)block).getStorageUnits();
    }

    public int getEffectiveDrawerCapacity() {
        if (this.upgradeData.hasOneStackUpgrade()) {
            return 1;
        }
        return this.getDrawerCapacity() * (Integer)CommonConfig.GENERAL.baseStackStorage.get();
    }

    protected boolean emptySlotCanBeCleared(int slot) {
        IDrawer drawer = this.getGroup().getDrawer(slot);
        return !drawer.isEmpty() && drawer.getStoredItemCount() == 0;
    }

    protected void onAttributeChanged() {
        this.requestModelDataUpdate();
    }

    public boolean isRedstone() {
        return this.upgradeData.getRedstoneType() != null;
    }

    public int getRedstoneLevel() {
        EnumUpgradeRedstone type = this.upgradeData.getRedstoneType();
        if (type == null) {
            return 0;
        }
        return switch (type) {
            default -> throw new MatchException(null, null);
            case EnumUpgradeRedstone.COMBINED -> this.getCombinedRedstoneLevel();
            case EnumUpgradeRedstone.MAX -> this.getMaxRedstoneLevel();
            case EnumUpgradeRedstone.MIN -> this.getMinRedstoneLevel();
        };
    }

    protected int getCombinedRedstoneLevel() {
        int active = 0;
        float fillRatio = 0.0f;
        for (int i = 0; i < this.getDrawerCount(); ++i) {
            IDrawer drawer = this.getDrawer(i);
            if (!drawer.isEnabled()) continue;
            if (drawer.getMaxCapacity() > 0) {
                fillRatio += (float)drawer.getStoredItemCount() / (float)drawer.getMaxCapacity();
            }
            ++active;
        }
        if (active == 0) {
            return 0;
        }
        if (fillRatio == (float)active) {
            return 15;
        }
        return (int)Math.ceil(fillRatio / (float)active * 14.0f);
    }

    protected int getMinRedstoneLevel() {
        float minRatio = 2.0f;
        for (int i = 0; i < this.getDrawerCount(); ++i) {
            IDrawer drawer = this.getDrawer(i);
            if (!drawer.isEnabled()) continue;
            minRatio = drawer.getMaxCapacity() > 0 ? Math.min(minRatio, (float)drawer.getStoredItemCount() / (float)drawer.getMaxCapacity()) : 0.0f;
        }
        if (minRatio > 1.0f) {
            return 0;
        }
        if (minRatio == 1.0f) {
            return 15;
        }
        return (int)Math.ceil(minRatio * 14.0f);
    }

    protected int getMaxRedstoneLevel() {
        float maxRatio = 0.0f;
        for (int i = 0; i < this.getDrawerCount(); ++i) {
            IDrawer drawer = this.getDrawer(i);
            if (!drawer.isEnabled() || drawer.getMaxCapacity() <= 0) continue;
            maxRatio = Math.max(maxRatio, (float)drawer.getStoredItemCount() / (float)drawer.getMaxCapacity());
        }
        if (maxRatio == 1.0f) {
            return 15;
        }
        return (int)Math.ceil(maxRatio * 14.0f);
    }

    @NotNull
    public ItemStack takeItemsFromSlot(int slot, int count) {
        IDrawer drawer = this.getGroup().getDrawer(slot);
        if (!drawer.isEnabled() || drawer.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = drawer.getStoredItemPrototype().copy();
        stack.setCount(Math.min(count, drawer.getStoredItemCount()));
        drawer.setStoredItemCount(drawer.getStoredItemCount() - stack.getCount());
        if (this.isRedstone() && this.getLevel() != null) {
            this.getLevel().updateNeighborsAt(this.getBlockPos(), this.getBlockState().getBlock());
            this.getLevel().updateNeighborsAt(this.getBlockPos().below(), this.getBlockState().getBlock());
        }
        return stack;
    }

    public int putItemsIntoSlot(int slot, @NotNull ItemStack stack, int count) {
        IDrawer drawer = this.getGroup().getDrawer(slot);
        if (!drawer.isEnabled()) {
            return 0;
        }
        if (drawer.isEmpty()) {
            drawer = drawer.setStoredItem(stack);
        }
        if (!drawer.canItemBeStored(stack)) {
            return 0;
        }
        int countAdded = Math.min(count, stack.getCount());
        if (!this.drawerAttributes.isVoid()) {
            countAdded = Math.min(countAdded, drawer.getRemainingCapacity());
        }
        drawer.setStoredItemCount(drawer.getStoredItemCount() + countAdded);
        stack.shrink(countAdded);
        return countAdded;
    }

    public int interactPutCurrentItemIntoSlot(int slot, Player player) {
        IDrawer drawer = this.getDrawer(slot);
        if (!drawer.isEnabled()) {
            return 0;
        }
        int count = 0;
        ItemStack playerStack = player.getInventory().getSelected();
        if (!playerStack.isEmpty()) {
            count = this.putItemsIntoSlot(slot, playerStack, playerStack.getCount());
        }
        return count;
    }

    public int interactPutCurrentInventoryIntoSlot(int slot, Player player) {
        IDrawer drawer = this.getGroup().getDrawer(slot);
        if (!drawer.isEnabled()) {
            return 0;
        }
        int count = 0;
        if (!drawer.isEmpty()) {
            int n = player.getInventory().getContainerSize();
            for (int i = 0; i < n; ++i) {
                ItemStack subStack = player.getInventory().getItem(i);
                if (subStack.isEmpty()) continue;
                int subCount = this.putItemsIntoSlot(slot, subStack, subStack.getCount());
                if (subCount > 0 && subStack.getCount() == 0) {
                    player.getInventory().setItem(i, ItemStack.EMPTY);
                }
                count += subCount;
            }
        }
        return count;
    }

    public int interactPutItemsIntoSlot(int slot, Player player) {
        if (this.getLevel() == null) {
            return 0;
        }
        int count = this.getLevel().getGameTime() - this.lastClickTime < 10L && player.getUUID().equals(this.lastClickUUID) ? this.interactPutCurrentInventoryIntoSlot(slot, player) : this.interactPutCurrentItemIntoSlot(slot, player);
        this.lastClickTime = this.getLevel().getGameTime();
        this.lastClickUUID = player.getUUID();
        return count;
    }

    @Override
    public void readPortable(HolderLookup.Provider provider, CompoundTag tag) {
        this.loading = true;
        super.readPortable(provider, tag);
        if (tag.contains("Lock")) {
            EnumSet<LockAttribute> attrs = LockAttribute.getEnumSet(tag.getByte("Lock"));
            if (attrs != null) {
                this.drawerAttributes.setItemLocked(LockAttribute.LOCK_EMPTY, attrs.contains((Object)LockAttribute.LOCK_EMPTY));
                this.drawerAttributes.setItemLocked(LockAttribute.LOCK_POPULATED, attrs.contains((Object)LockAttribute.LOCK_POPULATED));
            }
        } else {
            this.drawerAttributes.setItemLocked(LockAttribute.LOCK_EMPTY, false);
            this.drawerAttributes.setItemLocked(LockAttribute.LOCK_POPULATED, false);
        }
        if (tag.contains("Shr")) {
            this.drawerAttributes.setIsConcealed(tag.getBoolean("Shr"));
        } else {
            this.drawerAttributes.setIsConcealed(false);
        }
        if (tag.contains("Qua")) {
            this.drawerAttributes.setIsShowingQuantity(tag.getBoolean("Qua"));
        } else {
            this.drawerAttributes.setIsShowingQuantity(false);
        }
        this.loading = false;
    }

    @Override
    public CompoundTag writePortable(HolderLookup.Provider provider, CompoundTag tag) {
        tag = super.writePortable(provider, tag);
        EnumSet<LockAttribute> attrs = EnumSet.noneOf(LockAttribute.class);
        if (this.drawerAttributes.isItemLocked(LockAttribute.LOCK_EMPTY)) {
            attrs.add(LockAttribute.LOCK_EMPTY);
        }
        if (this.drawerAttributes.isItemLocked(LockAttribute.LOCK_POPULATED)) {
            attrs.add(LockAttribute.LOCK_POPULATED);
        }
        if (!attrs.isEmpty()) {
            tag.putByte("Lock", (byte)LockAttribute.getBitfield(attrs));
        }
        if (this.drawerAttributes.isConcealed()) {
            tag.putBoolean("Shr", true);
        }
        if (this.drawerAttributes.isShowingQuantity()) {
            tag.putBoolean("Qua", true);
        }
        return tag;
    }

    public void setChanged() {
        if (this.isRedstone() && this.getLevel() != null) {
            this.getLevel().updateNeighborsAt(this.getBlockPos(), this.getBlockState().getBlock());
            this.getLevel().updateNeighborsAt(this.getBlockPos().below(), this.getBlockState().getBlock());
        }
        super.setChanged();
    }

    protected void syncClientCount(int slot, int count) {
        if (this.getLevel() != null && this.getLevel().isClientSide) {
            return;
        }
        PacketDistributor.sendToPlayersNear((ServerLevel)((ServerLevel)this.getLevel()), null, (double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ(), (double)500.0, (CustomPacketPayload)new CountUpdateMessage(this.getBlockPos(), slot, count), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientUpdateCount(int slot, int count) {
        if (this.getLevel() == null || !this.getLevel().isClientSide) {
            return;
        }
        Minecraft.getInstance().tell(() -> this.clientUpdateCountAsync(slot, count));
    }

    @OnlyIn(value=Dist.CLIENT)
    private void clientUpdateCountAsync(int slot, int count) {
        IDrawer drawer = this.getDrawer(slot);
        if (drawer.isEnabled() && drawer.getStoredItemCount() != count) {
            drawer.setStoredItemCount(count);
        }
    }

    @Override
    public boolean dataPacketRequiresRenderUpdate() {
        return true;
    }

    @Override
    @Deprecated
    public int getDrawerCount() {
        return this.getGroup().getDrawerCount();
    }

    @Override
    @Deprecated
    @NotNull
    public IDrawer getDrawer(int slot) {
        return this.getGroup().getDrawer(slot);
    }

    @Override
    @Deprecated
    public int[] getAccessibleDrawerSlots() {
        return this.getGroup().getAccessibleDrawerSlots();
    }

    @Override
    public <T> T getCapability(@NotNull BlockCapability<T, Void> capability) {
        if (this.level == null) {
            return null;
        }
        return (T)this.level.getCapability(capability, this.getBlockPos(), this.getBlockState(), (BlockEntity)this, null);
    }

    @NotNull
    public ModelData getModelData() {
        return ModelData.builder().with(ATTRIBUTES, (Object)this.drawerAttributes).build();
    }

    private class DrawerUpgradeData
    extends UpgradeData {
        DrawerUpgradeData() {
            super(7);
        }

        @Override
        public boolean canAddUpgrade(@NotNull ItemStack upgrade) {
            if (!super.canAddUpgrade(upgrade)) {
                return false;
            }
            if (upgrade.getItem() == ModItems.ONE_STACK_UPGRADE.get()) {
                int lostStackCapacity = BlockEntityDrawers.this.upgradeData.getStorageMultiplier() * (BlockEntityDrawers.this.getEffectiveDrawerCapacity() - 1);
                return this.stackCapacityCheck(lostStackCapacity);
            }
            return true;
        }

        @Override
        public boolean canRemoveUpgrade(int slot) {
            if (!super.canRemoveUpgrade(slot)) {
                return false;
            }
            ItemStack upgrade = this.getUpgrade(slot);
            if (upgrade.getItem() instanceof ItemUpgradeStorage) {
                int storageLevel = ((ItemUpgradeStorage)upgrade.getItem()).level.getLevel();
                int storageMult = CommonConfig.UPGRADES.getLevelMult(storageLevel);
                int effectiveStorageMult = BlockEntityDrawers.this.upgradeData.getStorageMultiplier();
                if (effectiveStorageMult == storageMult) {
                    --storageMult;
                }
                int addedStackCapacity = storageMult * BlockEntityDrawers.this.getEffectiveDrawerCapacity();
                return this.stackCapacityCheck(addedStackCapacity);
            }
            return true;
        }

        @Override
        public boolean canSwapUpgrade(int slot, @NotNull ItemStack add) {
            if (!this.canRemoveUpgrade(slot) || !this.canAddUpgrade(add)) {
                return false;
            }
            ItemStack upgrade = this.getUpgrade(slot);
            if (upgrade.getItem() == ModItems.ONE_STACK_UPGRADE.get()) {
                return true;
            }
            if (add.getItem() instanceof ItemUpgradeStorage) {
                return true;
            }
            int currentUpgradeMult = BlockEntityDrawers.this.upgradeData.getStorageMultiplier();
            int storageLevel = ((ItemUpgradeStorage)upgrade.getItem()).level.getLevel();
            int storageMult = CommonConfig.UPGRADES.getLevelMult(storageLevel);
            int removedStacks = Math.min(currentUpgradeMult * BlockEntityDrawers.this.getEffectiveDrawerCapacity() - 1, currentUpgradeMult * (BlockEntityDrawers.this.getEffectiveDrawerCapacity() - 1) + storageMult);
            return this.stackCapacityCheck(removedStacks);
        }

        @Override
        protected void onUpgradeChanged(ItemStack oldUpgrade, ItemStack newUpgrade) {
            if (BlockEntityDrawers.this.getLevel() != null && !BlockEntityDrawers.this.getLevel().isClientSide) {
                BlockEntityDrawers.this.setChanged();
                BlockEntityDrawers.this.markBlockForUpdate();
            }
        }

        private boolean stackCapacityCheck(int stackCapacity) {
            for (int i = 0; i < BlockEntityDrawers.this.getDrawerCount(); ++i) {
                IDrawer drawer = BlockEntityDrawers.this.getDrawer(i);
                if (!drawer.isEnabled() || drawer.isEmpty()) continue;
                int addedItemCapacity = stackCapacity * drawer.getStoredItemStackSize();
                if (drawer.getMaxCapacity() - addedItemCapacity >= drawer.getStoredItemCount()) continue;
                return false;
            }
            return true;
        }
    }

    private class DrawerAttributes
    extends BasicDrawerAttributes {
        private DrawerAttributes() {
        }

        @Override
        protected void onAttributeChanged() {
            if (!BlockEntityDrawers.this.loading && !BlockEntityDrawers.this.drawerAttributes.isItemLocked(LockAttribute.LOCK_POPULATED)) {
                for (int slot = 0; slot < BlockEntityDrawers.this.getGroup().getDrawerCount(); ++slot) {
                    if (!BlockEntityDrawers.this.emptySlotCanBeCleared(slot)) continue;
                    IDrawer drawer = BlockEntityDrawers.this.getGroup().getDrawer(slot);
                    drawer.setStoredItem(ItemStack.EMPTY);
                }
            }
            BlockEntityDrawers.this.onAttributeChanged();
            if (BlockEntityDrawers.this.getLevel() != null && !BlockEntityDrawers.this.getLevel().isClientSide) {
                BlockEntityDrawers.this.setChanged();
                BlockEntityDrawers.this.markBlockForUpdate();
            }
        }
    }
}

