/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.IFractionalDrawer;
import com.jaquadro.minecraft.storagedrawers.block.BlockCompDrawers;
import com.jaquadro.minecraft.storagedrawers.block.EnumCompDrawer;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.FractionalDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.config.CommonConfig;
import com.jaquadro.minecraft.storagedrawers.core.ModBlockEntities;
import com.jaquadro.minecraft.storagedrawers.network.CountUpdateMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public abstract class BlockEntityDrawersComp
extends BlockEntityDrawers {
    public BlockEntityDrawersComp(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
    }

    @Override
    protected boolean emptySlotCanBeCleared(int slot) {
        if (slot != 0) {
            return false;
        }
        IDrawerGroup iDrawerGroup = this.getGroup();
        if (iDrawerGroup instanceof FractionalDrawerGroup) {
            FractionalDrawerGroup fracGroup = (FractionalDrawerGroup)iDrawerGroup;
            return !this.getGroup().getDrawer(0).isEmpty() && fracGroup.getPooledCount() == 0;
        }
        return false;
    }

    @Override
    public boolean dataPacketRequiresRenderUpdate() {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientUpdateCount(int slot, int count) {
        if (this.getLevel() == null || !this.getLevel().isClientSide) {
            return;
        }
        Minecraft.getInstance().tell(() -> this.clientUpdateCountAsync(count));
    }

    @OnlyIn(value=Dist.CLIENT)
    private void clientUpdateCountAsync(int count) {
        if (this.getGroup() instanceof FractionalDrawerGroup) {
            ((FractionalDrawerGroup)this.getGroup()).setPooledCount(count);
        }
    }

    private class GroupData
    extends FractionalDrawerGroup {
        public GroupData(int slotCount) {
            super(slotCount);
        }

        @Override
        protected Level getWorld() {
            return BlockEntityDrawersComp.this.getLevel();
        }

        @Override
        public boolean isGroupValid() {
            return BlockEntityDrawersComp.this.isGroupValid();
        }

        @Override
        protected void log(String message) {
            if (!this.getWorld().isClientSide && ((Boolean)CommonConfig.GENERAL.debugTrace.get()).booleanValue()) {
                StorageDrawers.log.info(message);
            }
        }

        @Override
        protected int getStackCapacity() {
            return BlockEntityDrawersComp.this.upgrades().getStorageMultiplier() * BlockEntityDrawersComp.this.getEffectiveDrawerCapacity();
        }

        @Override
        protected void onItemChanged() {
            if (this.getWorld() != null && !this.getWorld().isClientSide) {
                int usedSlots = 0;
                for (int slot : this.getAccessibleDrawerSlots()) {
                    IFractionalDrawer drawer = this.getDrawer(slot);
                    if (drawer.isEmpty()) continue;
                    ++usedSlots;
                }
                usedSlots = Math.max(usedSlots, 1);
                EnumCompDrawer open = (EnumCompDrawer)((Object)BlockEntityDrawersComp.this.getBlockState().getValue(BlockCompDrawers.SLOTS));
                if (open.getOpenSlots() != usedSlots) {
                    this.getWorld().setBlock(BlockEntityDrawersComp.this.worldPosition, (BlockState)BlockEntityDrawersComp.this.getBlockState().setValue(BlockCompDrawers.SLOTS, (Comparable)((Object)EnumCompDrawer.byOpenSlots(usedSlots))), 3);
                }
                BlockEntityDrawersComp.this.setChanged();
                BlockEntityDrawersComp.this.markBlockForUpdate();
            }
        }

        @Override
        protected void onAmountChanged() {
            if (this.getWorld() != null && !this.getWorld().isClientSide) {
                PacketDistributor.sendToPlayersNear((ServerLevel)((ServerLevel)BlockEntityDrawersComp.this.getLevel()), null, (double)BlockEntityDrawersComp.this.getBlockPos().getX(), (double)BlockEntityDrawersComp.this.getBlockPos().getY(), (double)BlockEntityDrawersComp.this.getBlockPos().getZ(), (double)500.0, (CustomPacketPayload)new CountUpdateMessage(BlockEntityDrawersComp.this.getBlockPos(), 0, this.getPooledCount()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                BlockEntityDrawersComp.this.setChanged();
            }
        }

        @Override
        public <T> T getCapability(@NotNull BlockCapability<T, Void> capability) {
            if (BlockEntityDrawersComp.this.level == null) {
                return null;
            }
            return (T)BlockEntityDrawersComp.this.level.getCapability(capability, BlockEntityDrawersComp.this.getBlockPos(), BlockEntityDrawersComp.this.getBlockState(), (BlockEntity)BlockEntityDrawersComp.this, null);
        }
    }

    public static class Slot3
    extends BlockEntityDrawersComp {
        private final GroupData groupData = new GroupData(3);

        public Slot3(BlockPos pos, BlockState state) {
            super((BlockEntityType)ModBlockEntities.FRACTIONAL_DRAWERS_3.get(), pos, state);
            this.injectPortableData(this.groupData);
        }

        @Override
        @NotNull
        public IDrawerGroup getGroup() {
            return this.groupData;
        }

        @Override
        protected void onAttributeChanged() {
            super.onAttributeChanged();
            this.groupData.syncAttributes();
        }
    }
}

